/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot.incoming;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.ignite.internal.table.distributed.TableMessagesFactory;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite.internal.table.distributed.raft.snapshot.SnapshotUri;
import org.apache.ignite.internal.table.distributed.raft.snapshot.incoming.IncomingSnapshotReader;
import org.apache.ignite.internal.table.distributed.raft.snapshot.message.SnapshotMetaResponse;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.MessagingService;
import org.apache.ignite.network.NetworkMessage;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotCopier;
import org.apache.ignite.raft.jraft.storage.snapshot.SnapshotReader;

public class IncomingSnapshotCopier
extends SnapshotCopier {
    private static final TableMessagesFactory MSG_FACTORY = new TableMessagesFactory();
    private final PartitionSnapshotStorage snapshotStorage;
    private final SnapshotUri snapshotUri;
    private final ExecutorService threadPool = Executors.newSingleThreadExecutor();
    private RaftOutter.SnapshotMeta snapshotMeta;

    public IncomingSnapshotCopier(PartitionSnapshotStorage snapshotStorage, SnapshotUri snapshotUri) {
        this.snapshotStorage = snapshotStorage;
        this.snapshotUri = snapshotUri;
    }

    public void cancel() {
    }

    public void join() throws InterruptedException {
    }

    public void start() {
        ClusterNode sourceNode = this.snapshotStorage.topologyService().getByConsistentId(this.snapshotUri.nodeName);
        MessagingService messagingService = this.snapshotStorage.outgoingSnapshotsManager().messagingService();
        this.threadPool.submit(() -> {
            CompletableFuture metaRequestFuture = messagingService.invoke(sourceNode, (NetworkMessage)MSG_FACTORY.snapshotMetaRequest().id(this.snapshotUri.snapshotId).build(), 1000L);
            metaRequestFuture.whenComplete((networkMessage, throwable) -> {
                SnapshotMetaResponse metaResponse = (SnapshotMetaResponse)networkMessage;
                this.snapshotMeta = metaResponse.meta();
            });
        });
    }

    public SnapshotReader getReader() {
        return new IncomingSnapshotReader(this.snapshotMeta);
    }

    public void close() throws IOException {
        this.threadPool.shutdownNow();
    }
}

