/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl;

import java.util.Map;
import org.apache.ignite.internal.cli.core.CallExecutionPipelineProvider;
import org.apache.ignite.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite.internal.cli.core.repl.ReplBuilder;
import org.apache.ignite.internal.cli.core.repl.executor.RegistryCommandExecutor;
import org.apache.ignite.internal.cli.core.repl.prompt.PromptProvider;
import org.apache.ignite.internal.cli.core.repl.terminal.TerminalCustomizer;
import org.jline.reader.Completer;
import org.jline.terminal.Terminal;
import picocli.CommandLine;

public class Repl {
    private final PromptProvider promptProvider;
    private final Map<String, String> aliases;
    private final TerminalCustomizer terminalCustomizer;
    private final Class<?> commandClass;
    private final CommandLine.IDefaultValueProvider defaultValueProvider;
    private final CallExecutionPipelineProvider provider;
    private final Completer completer;
    private final String historyFileName;
    private final boolean tailTipWidgetsEnabled;
    private final Runnable onStart;

    public Repl(PromptProvider promptProvider, Class<?> commandClass, CommandLine.IDefaultValueProvider defaultValueProvider, Map<String, String> aliases, TerminalCustomizer terminalCustomizer, CallExecutionPipelineProvider provider, Completer completer, String historyFileName, boolean tailTipWidgetsEnabled, Runnable onStart) {
        this.promptProvider = promptProvider;
        this.commandClass = commandClass;
        this.defaultValueProvider = defaultValueProvider;
        this.aliases = aliases;
        this.terminalCustomizer = terminalCustomizer;
        this.provider = provider;
        this.completer = completer;
        this.historyFileName = historyFileName;
        this.tailTipWidgetsEnabled = tailTipWidgetsEnabled;
        this.onStart = onStart;
    }

    public static ReplBuilder builder() {
        return new ReplBuilder();
    }

    public PromptProvider getPromptProvider() {
        return this.promptProvider;
    }

    public Class<?> commandClass() {
        return this.commandClass;
    }

    public CommandLine.IDefaultValueProvider defaultValueProvider() {
        return this.defaultValueProvider;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void customizeTerminal(Terminal terminal) {
        this.terminalCustomizer.customize(terminal);
    }

    public CallExecutionPipeline<?, ?> getPipeline(RegistryCommandExecutor executor, ExceptionHandlers exceptionHandlers, String line) {
        return this.provider.get(executor, exceptionHandlers, line);
    }

    public Completer getCompleter() {
        return this.completer;
    }

    public String getHistoryFileName() {
        return this.historyFileName;
    }

    public boolean isTailTipWidgetsEnabled() {
        return this.tailTipWidgetsEnabled;
    }

    public void onStart() {
        this.onStart.run();
    }
}

