/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.commands.cluster.config;

import jakarta.inject.Inject;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigUpdateCall;
import org.apache.ignite.internal.cli.call.configuration.ClusterConfigUpdateCallInput;
import org.apache.ignite.internal.cli.commands.BaseCommand;
import org.apache.ignite.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"Updates cluster configuration"})
public class ClusterConfigUpdateReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Parameters(index="0")
    private String config;
    @Inject
    ClusterConfigUpdateCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::configUpdateCallInput).then(Flows.fromCall(this.call)).exceptionHandler(new ClusterNotInitializedExceptionHandler("Cannot update cluster config", "cluster init")).verbose(this.verbose).print().start();
    }

    private ClusterConfigUpdateCallInput configUpdateCallInput(String clusterUrl) {
        return ClusterConfigUpdateCallInput.builder().config(this.config).clusterUrl(clusterUrl).build();
    }
}

