/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.compute.message.ExecuteResponse;
import org.apache.ignite.internal.compute.message.ExecuteResponseBuilder;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ExecuteResponseImpl
implements ExecuteResponse {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private Object result;
    private byte[] resultByteArray;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private ExecuteResponseImpl(Object result, byte[] resultByteArray, Throwable throwable, byte[] throwableByteArray) {
        this.result = result;
        this.resultByteArray = resultByteArray;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    byte[] resultByteArray() {
        return this.resultByteArray;
    }

    @Override
    public Object result() {
        return this.result;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(ExecuteResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExecuteResponseImpl otherMessage = (ExecuteResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result, this.throwable);
        return result;
    }

    public static ExecuteResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject resultByteArraymo = marshaller.marshal(this.result);
        usedDescriptors.addAll((IntCollection)resultByteArraymo.usedDescriptorIds());
        this.resultByteArray = resultByteArraymo.bytes();
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.result = marshaller.unmarshal(this.resultByteArray, descriptorsObj);
        this.resultByteArray = null;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements ExecuteResponseBuilder {
        private Object result;
        private byte[] resultByteArray;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public ExecuteResponseBuilder result(Object result) {
            this.result = result;
            return this;
        }

        @Override
        public ExecuteResponseBuilder resultByteArray(byte[] resultByteArray) {
            this.resultByteArray = resultByteArray;
            return this;
        }

        @Override
        public ExecuteResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public ExecuteResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public Object result() {
            return this.result;
        }

        @Override
        public byte[] resultByteArray() {
            return this.resultByteArray;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public ExecuteResponse build() {
            return new ExecuteResponseImpl(this.result, this.resultByteArray, this.throwable, this.throwableByteArray);
        }
    }
}

