/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypes;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeSystem;
import org.apache.ignite.internal.util.CollectionUtils;

public class IgniteTypeFactory
extends JavaTypeFactoryImpl {
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_YEAR_MONTH = new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, SqlParserPos.ZERO);
    private static final SqlIntervalQualifier INTERVAL_QUALIFIER_DAY_TIME = new SqlIntervalQualifier(TimeUnit.DAY, TimeUnit.SECOND, SqlParserPos.ZERO);
    private final Charset charset = SqlUtil.translateCharacterSetName((String)Charset.defaultCharset().name()) != null ? Charset.defaultCharset() : StandardCharsets.UTF_8;

    public IgniteTypeFactory() {
        this(IgniteTypeSystem.INSTANCE);
    }

    public IgniteTypeFactory(RelDataTypeSystem typeSystem) {
        super(typeSystem);
    }

    public Type getJavaClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: 
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: 
                case INTEGER: 
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case BIGINT: 
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return ByteString.class;
                }
                case GEOMETRY: {
                    throw new IllegalArgumentException("Type is not supported.");
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public static NativeType relDataTypeToNative(RelDataType relType) {
        assert (relType instanceof BasicSqlType || relType instanceof IntervalSqlType) : "Not supported.";
        switch (relType.getSqlTypeName()) {
            case BOOLEAN: {
                throw new IllegalArgumentException("Type is not supported yet.");
            }
            case TINYINT: {
                return NativeTypes.INT8;
            }
            case SMALLINT: {
                return NativeTypes.INT16;
            }
            case INTEGER: {
                return NativeTypes.INT32;
            }
            case BIGINT: {
                return NativeTypes.INT64;
            }
            case DECIMAL: {
                assert (relType.getPrecision() != -1);
                return NativeTypes.decimalOf((int)relType.getPrecision(), (int)relType.getScale());
            }
            case REAL: 
            case FLOAT: {
                return NativeTypes.FLOAT;
            }
            case DOUBLE: {
                return NativeTypes.DOUBLE;
            }
            case DATE: {
                return NativeTypes.DATE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return relType.getPrecision() == -1 ? NativeTypes.time() : NativeTypes.time((int)relType.getPrecision());
            }
            case TIMESTAMP: {
                return relType.getPrecision() == -1 ? NativeTypes.datetime() : NativeTypes.datetime((int)relType.getPrecision());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return relType.getPrecision() == -1 ? NativeTypes.timestamp() : NativeTypes.timestamp((int)relType.getPrecision());
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: {
                throw new IllegalArgumentException("Type is not supported yet.");
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                throw new IllegalArgumentException("Type is not supported yet.");
            }
            case VARCHAR: 
            case CHAR: {
                return relType.getPrecision() == -1 ? NativeTypes.stringOf((int)Integer.MAX_VALUE) : NativeTypes.stringOf((int)relType.getPrecision());
            }
            case BINARY: 
            case VARBINARY: {
                return relType.getPrecision() == -1 ? NativeTypes.blobOf((int)Integer.MAX_VALUE) : NativeTypes.blobOf((int)relType.getPrecision());
            }
        }
        throw new IllegalArgumentException("Type is not supported.");
    }

    public Type getResultClass(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            return ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
        }
        if (type instanceof BasicSqlType || type instanceof IntervalSqlType) {
            switch (type.getSqlTypeName()) {
                case VARCHAR: 
                case CHAR: {
                    return String.class;
                }
                case DATE: {
                    return LocalDate.class;
                }
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: {
                    return LocalTime.class;
                }
                case TIMESTAMP: {
                    return LocalDateTime.class;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return Instant.class;
                }
                case INTEGER: {
                    return type.isNullable() ? Integer.class : Integer.TYPE;
                }
                case INTERVAL_YEAR: 
                case INTERVAL_YEAR_MONTH: 
                case INTERVAL_MONTH: {
                    return Period.class;
                }
                case BIGINT: {
                    return type.isNullable() ? Long.class : Long.TYPE;
                }
                case INTERVAL_DAY: 
                case INTERVAL_DAY_HOUR: 
                case INTERVAL_DAY_MINUTE: 
                case INTERVAL_DAY_SECOND: 
                case INTERVAL_HOUR: 
                case INTERVAL_HOUR_MINUTE: 
                case INTERVAL_HOUR_SECOND: 
                case INTERVAL_MINUTE: 
                case INTERVAL_MINUTE_SECOND: 
                case INTERVAL_SECOND: {
                    return Duration.class;
                }
                case SMALLINT: {
                    return type.isNullable() ? Short.class : Short.TYPE;
                }
                case TINYINT: {
                    return type.isNullable() ? Byte.class : Byte.TYPE;
                }
                case DECIMAL: {
                    return BigDecimal.class;
                }
                case BOOLEAN: {
                    return type.isNullable() ? Boolean.class : Boolean.TYPE;
                }
                case DOUBLE: {
                    return type.isNullable() ? Double.class : Double.TYPE;
                }
                case REAL: 
                case FLOAT: {
                    return type.isNullable() ? Float.class : Float.TYPE;
                }
                case BINARY: 
                case VARBINARY: {
                    return byte[].class;
                }
                case GEOMETRY: {
                    throw new IllegalArgumentException("Type is not supported.");
                }
                case SYMBOL: {
                    return Enum.class;
                }
                case ANY: 
                case OTHER: {
                    return Object.class;
                }
                case NULL: {
                    return Void.class;
                }
            }
        }
        switch (type.getSqlTypeName()) {
            case ROW: {
                return Object[].class;
            }
            case MAP: {
                return Map.class;
            }
            case ARRAY: 
            case MULTISET: {
                return List.class;
            }
        }
        return null;
    }

    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (types.size() >= 1);
        if (types.size() == 1 || this.allEquals(types)) {
            return (RelDataType)CollectionUtils.first(types);
        }
        return super.leastRestrictive(types);
    }

    public Charset getDefaultCharset() {
        return this.charset;
    }

    public RelDataType toSql(RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            Class clazz = ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass();
            if (clazz == Duration.class) {
                return this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_DAY_TIME), true);
            }
            if (clazz == Period.class) {
                return this.createTypeWithNullability(this.createSqlIntervalType(INTERVAL_QUALIFIER_YEAR_MONTH), true);
            }
        }
        return super.toSql(type);
    }

    public RelDataType createType(Type type) {
        if (type == Duration.class || type == Period.class || type == LocalDate.class || type == LocalDateTime.class || type == LocalTime.class) {
            return this.createJavaType((Class)type);
        }
        return super.createType(type);
    }

    private boolean allEquals(List<RelDataType> types) {
        assert (types.size() > 1);
        RelDataType first = (RelDataType)CollectionUtils.first(types);
        for (int i = 1; i < types.size(); ++i) {
            if (Objects.equals(first, types.get(i))) continue;
            return false;
        }
        return true;
    }
}

