/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessageBuilder;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class QueryBatchMessageImpl
implements QueryBatchMessage {
    public static final short GROUP_TYPE = 4;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final int batchId;
    @IgniteToStringInclude
    private final long exchangeId;
    @IgniteToStringInclude
    private final long fragmentId;
    @IgniteToStringInclude
    private final boolean last;
    @IgniteToStringInclude
    private final UUID queryId;
    @IgniteToStringInclude
    private List<Object> rows;
    private byte[] rowsByteArray;

    private QueryBatchMessageImpl(int batchId, long exchangeId, long fragmentId, boolean last, UUID queryId, List<Object> rows, byte[] rowsByteArray) {
        this.batchId = batchId;
        this.exchangeId = exchangeId;
        this.fragmentId = fragmentId;
        this.last = last;
        this.queryId = queryId;
        this.rows = rows;
        this.rowsByteArray = rowsByteArray;
    }

    @Override
    public int batchId() {
        return this.batchId;
    }

    @Override
    public long exchangeId() {
        return this.exchangeId;
    }

    @Override
    public long fragmentId() {
        return this.fragmentId;
    }

    @Override
    public boolean last() {
        return this.last;
    }

    @Override
    public UUID queryId() {
        return this.queryId;
    }

    byte[] rowsByteArray() {
        return this.rowsByteArray;
    }

    @Override
    public List<Object> rows() {
        return this.rows;
    }

    public short groupType() {
        return 4;
    }

    public String toString() {
        return S.toString(QueryBatchMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryBatchMessageImpl otherMessage = (QueryBatchMessageImpl)other;
        return Objects.equals(this.queryId, otherMessage.queryId) && Objects.equals(this.rows, otherMessage.rows) && this.batchId == otherMessage.batchId && this.exchangeId == otherMessage.exchangeId && this.fragmentId == otherMessage.fragmentId && this.last == otherMessage.last;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.batchId, this.exchangeId, this.fragmentId, this.last, this.queryId, this.rows);
        return result;
    }

    public static QueryBatchMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject rowsByteArraymo = marshaller.marshal(this.rows);
        usedDescriptors.addAll((IntCollection)rowsByteArraymo.usedDescriptorIds());
        this.rowsByteArray = rowsByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.rows = (List)marshaller.unmarshal(this.rowsByteArray, descriptorsObj);
        this.rowsByteArray = null;
    }

    private static class Builder
    implements QueryBatchMessageBuilder {
        private int batchId;
        private long exchangeId;
        private long fragmentId;
        private boolean last;
        private UUID queryId;
        private List<Object> rows;
        private byte[] rowsByteArray;

        private Builder() {
        }

        @Override
        public QueryBatchMessageBuilder batchId(int batchId) {
            this.batchId = batchId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder exchangeId(long exchangeId) {
            this.exchangeId = exchangeId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder fragmentId(long fragmentId) {
            this.fragmentId = fragmentId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder last(boolean last) {
            this.last = last;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder queryId(UUID queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder rows(List<Object> rows) {
            this.rows = rows;
            return this;
        }

        @Override
        public QueryBatchMessageBuilder rowsByteArray(byte[] rowsByteArray) {
            this.rowsByteArray = rowsByteArray;
            return this;
        }

        @Override
        public int batchId() {
            return this.batchId;
        }

        @Override
        public long exchangeId() {
            return this.exchangeId;
        }

        @Override
        public long fragmentId() {
            return this.fragmentId;
        }

        @Override
        public boolean last() {
            return this.last;
        }

        @Override
        public UUID queryId() {
            return this.queryId;
        }

        @Override
        public List<Object> rows() {
            return this.rows;
        }

        @Override
        public byte[] rowsByteArray() {
            return this.rowsByteArray;
        }

        @Override
        public QueryBatchMessage build() {
            return new QueryBatchMessageImpl(this.batchId, this.exchangeId, this.fragmentId, this.last, this.queryId, this.rows, this.rowsByteArray);
        }
    }
}

