/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class SnapshotOperationRequest
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final UUID reqId;
    private final String snpName;
    private final String snpPath;
    @GridToStringInclude
    private final Set<UUID> nodes;
    @GridToStringInclude
    private final Collection<String> grps;
    private final UUID opNodeId;
    private volatile Throwable err;
    private volatile List<String> warnings;
    @GridToStringExclude
    private transient SnapshotMetadata meta;
    @GridToStringExclude
    private volatile transient boolean streamerWrn;
    private volatile transient boolean startStageEnded;
    private final long startTime;
    private final boolean incremental;
    private final int incIdx;
    private final boolean onlyPrimary;
    private final boolean dump;
    private final boolean compress;
    private final boolean encrypt;

    public SnapshotOperationRequest(UUID reqId, UUID opNodeId, String snpName, String snpPath, @Nullable Collection<String> grps, Set<UUID> nodes, boolean incremental, int incIdx, boolean onlyPrimary, boolean dump, boolean compress, boolean encrypt) {
        this.reqId = reqId;
        this.opNodeId = opNodeId;
        this.snpName = snpName;
        this.grps = grps;
        this.nodes = nodes;
        this.snpPath = snpPath;
        this.incremental = incremental;
        this.incIdx = incIdx;
        this.onlyPrimary = onlyPrimary;
        this.dump = dump;
        this.compress = compress;
        this.encrypt = encrypt;
        this.startTime = U.currentTimeMillis();
    }

    public UUID requestId() {
        return this.reqId;
    }

    public String snapshotName() {
        return this.snpName;
    }

    public String snapshotPath() {
        return this.snpPath;
    }

    @Nullable
    public Collection<String> groups() {
        return this.grps;
    }

    public Set<UUID> nodes() {
        return this.nodes;
    }

    public UUID operationalNodeId() {
        return this.opNodeId;
    }

    public Throwable error() {
        return this.err;
    }

    public void error(Throwable err) {
        this.err = err;
    }

    public boolean incremental() {
        return this.incremental;
    }

    public int incrementIndex() {
        return this.incIdx;
    }

    public boolean onlyPrimary() {
        return this.onlyPrimary;
    }

    public boolean dump() {
        return this.dump;
    }

    public boolean compress() {
        return this.compress;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    public long startTime() {
        return this.startTime;
    }

    protected boolean startStageEnded() {
        return this.startStageEnded;
    }

    protected void startStageEnded(boolean startStageEnded) {
        this.startStageEnded = startStageEnded;
    }

    public List<String> warnings() {
        return this.warnings;
    }

    public void warnings(List<String> warnings) {
        assert (this.warnings == null);
        this.warnings = warnings;
    }

    public boolean streamerWarning() {
        return this.streamerWrn;
    }

    public boolean streamerWarning(boolean val) {
        this.streamerWrn = val;
        return this.streamerWrn;
    }

    public SnapshotMetadata meta() {
        return this.meta;
    }

    public void meta(SnapshotMetadata meta) {
        this.meta = meta;
    }

    public String toString() {
        return S.toString(SnapshotOperationRequest.class, this);
    }
}

