/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicAbstractUpdateRequest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridNearAtomicCheckUpdateRequest
extends GridCacheIdMessage {
    private static final long serialVersionUID = 0L;
    public static final int CACHE_MSG_IDX = GridNearAtomicCheckUpdateRequest.nextIndexId();
    @GridDirectTransient
    private GridNearAtomicAbstractUpdateRequest updateReq;
    private int partId;
    private long futId;

    public GridNearAtomicCheckUpdateRequest() {
    }

    GridNearAtomicCheckUpdateRequest(GridNearAtomicAbstractUpdateRequest updateReq) {
        assert (updateReq != null && updateReq.fullSync()) : updateReq;
        this.updateReq = updateReq;
        this.cacheId = updateReq.cacheId();
        this.partId = updateReq.partition();
        this.futId = updateReq.futureId();
        assert (this.partId >= 0);
    }

    public final long futureId() {
        return this.futId;
    }

    GridNearAtomicAbstractUpdateRequest updateRequest() {
        return this.updateReq;
    }

    @Override
    public int partition() {
        return this.partId;
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public short directType() {
        return -50;
    }

    @Override
    public byte fieldsCount() {
        return 6;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeInt("partId", this.partId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.partId = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicCheckUpdateRequest.class);
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicCheckUpdateRequest.class, this);
    }
}

