/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheIndexesForceRebuildCommand;
import org.apache.ignite.internal.management.cache.CacheScheduleIndexesRebuildCommandArg;
import org.apache.ignite.internal.management.cache.ScheduleIndexRebuildTask;
import org.apache.ignite.internal.management.cache.ScheduleIndexRebuildTaskRes;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.lang.IgnitePair;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class CacheScheduleIndexesRebuildCommand
implements ComputeCommand<CacheScheduleIndexesRebuildCommandArg, ScheduleIndexRebuildTaskRes> {
    public static final String PREF_INDEXES_NOT_FOUND = "WARNING: These indexes were not found:";
    public static final String PREF_REBUILD_NOT_SCHEDULED = "WARNING: Indexes rebuild was not scheduled for any cache. Check command input.";
    public static final String PREF_REBUILD_NOT_SCHEDULED_MULTI = "WARNING: Indexes rebuild was not scheduled for any cache on the following nodes. Check command input:";

    @Override
    public String description() {
        return "Schedules rebuild of the indexes for specified caches via the Maintenance Mode. Schedules rebuild of specified caches and cache-groups";
    }

    @Override
    public Class<CacheScheduleIndexesRebuildCommandArg> argClass() {
        return CacheScheduleIndexesRebuildCommandArg.class;
    }

    @Override
    public Class<ScheduleIndexRebuildTask> taskClass() {
        return ScheduleIndexRebuildTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, CacheScheduleIndexesRebuildCommandArg arg) {
        UUID[] uUIDArray;
        if (arg.allNodes() || F.isEmpty(arg.nodeIds()) && arg.nodeId() == null) {
            return nodes;
        }
        CommandUtils.nodeOrAll(arg.nodeId(), nodes);
        if (arg.nodeId() == null) {
            uUIDArray = arg.nodeIds();
        } else {
            UUID[] uUIDArray2 = new UUID[1];
            uUIDArray = uUIDArray2;
            uUIDArray2[0] = arg.nodeId();
        }
        return CommandUtils.nodes(uUIDArray, nodes);
    }

    @Override
    public void printResult(CacheScheduleIndexesRebuildCommandArg arg, ScheduleIndexRebuildTaskRes results, Consumer<String> printer) {
        if (arg.nodeId() != null) {
            CacheScheduleIndexesRebuildCommand.printSingleResult(results, printer);
            return;
        }
        HashMap missedCaches = new HashMap();
        HashMap missedGrps = new HashMap();
        HashMap notFoundIndexes = new HashMap();
        HashMap scheduled = new HashMap();
        HashSet<UUID> notScheduled = new HashSet<UUID>();
        results.results().forEach((nodeId, res) -> {
            CacheIndexesForceRebuildCommand.storeEntryToNodesResults(missedCaches, res.notFoundCacheNames(), nodeId);
            CacheIndexesForceRebuildCommand.storeEntryToNodesResults(missedGrps, res.notFoundGroupNames(), nodeId);
            CacheIndexesForceRebuildCommand.storeEntryToNodesResults(notFoundIndexes, CacheScheduleIndexesRebuildCommand.extractCacheIndexNames(res.notFoundIndexes()), nodeId);
            if (CacheScheduleIndexesRebuildCommand.hasAtLeastOneIndex(res.cacheToIndexes())) {
                CacheIndexesForceRebuildCommand.storeEntryToNodesResults(scheduled, CacheScheduleIndexesRebuildCommand.extractCacheIndexNames(res.cacheToIndexes()), nodeId);
            } else {
                notScheduled.add((UUID)nodeId);
            }
        });
        SB b = new SB();
        if (!F.isEmpty(missedCaches)) {
            CacheIndexesForceRebuildCommand.printBlock(b, "WARNING: These caches were not found:", missedCaches, GridStringBuilder::a);
        }
        if (!F.isEmpty(missedGrps)) {
            CacheIndexesForceRebuildCommand.printBlock(b, "WARNING: These cache groups were not found:", missedGrps, GridStringBuilder::a);
        }
        if (!F.isEmpty(notFoundIndexes)) {
            CacheIndexesForceRebuildCommand.printBlock(b, PREF_INDEXES_NOT_FOUND, notFoundIndexes, GridStringBuilder::a);
        }
        if (!F.isEmpty(notScheduled)) {
            CacheIndexesForceRebuildCommand.printHeader(b, PREF_REBUILD_NOT_SCHEDULED_MULTI);
            CacheIndexesForceRebuildCommand.printEntryNewLine(b);
            b.a(CacheIndexesForceRebuildCommand.nodeIdsString(notScheduled));
        }
        if (!F.isEmpty(scheduled)) {
            CacheIndexesForceRebuildCommand.printBlock(b, "Indexes rebuild was scheduled for these caches:", scheduled, GridStringBuilder::a);
        }
        printer.accept(b.toString().trim());
    }

    private static Collection<String> extractCacheIndexNames(Map<String, Set<String>> cacheIndexes) {
        return F.flatCollections(cacheIndexes.entrySet().stream().map(cIdxs -> ((Set)cIdxs.getValue()).stream().map(idx -> CacheScheduleIndexesRebuildCommand.indexAndCacheInfo((String)cIdxs.getKey(), idx)).collect(Collectors.toList())).collect(Collectors.toList()));
    }

    private static String indexAndCacheInfo(String cache, String index) {
        return "'" + index + "' (of cache '" + cache + "')";
    }

    private static void printSingleResult(ScheduleIndexRebuildTaskRes result, Consumer<String> printer) {
        result.results().forEach((nodeId, res) -> {
            CacheScheduleIndexesRebuildCommand.printMissed(printer, "WARNING: These caches were not found:", res.notFoundCacheNames());
            CacheScheduleIndexesRebuildCommand.printMissed(printer, "WARNING: These cache groups were not found:", res.notFoundGroupNames());
            if (CacheScheduleIndexesRebuildCommand.hasAtLeastOneIndex(res.notFoundIndexes())) {
                printer.accept(PREF_INDEXES_NOT_FOUND);
                CacheScheduleIndexesRebuildCommand.printCachesAndIndexes(res.notFoundIndexes(), printer);
            }
            if (!F.isEmpty(res.cacheToIndexes()) && CacheScheduleIndexesRebuildCommand.hasAtLeastOneIndex(res.cacheToIndexes())) {
                printer.accept("Indexes rebuild was scheduled for these caches:");
                CacheScheduleIndexesRebuildCommand.printCachesAndIndexes(res.cacheToIndexes(), printer);
            } else {
                printer.accept(PREF_REBUILD_NOT_SCHEDULED);
            }
            printer.accept("");
        });
    }

    private static void printMissed(Consumer<String> printer, String message, Set<String> missed) {
        if (F.isEmpty(missed)) {
            return;
        }
        printer.accept(message);
        missed.stream().sorted().forEach(name -> printer.accept("  " + name));
        printer.accept("");
    }

    private static void printCachesAndIndexes(Map<String, Set<String>> cachesToIndexes, Consumer<String> printer) {
        cachesToIndexes.forEach((cacheName, indexes) -> {
            printer.accept("  " + cacheName + ":");
            indexes.forEach(index -> printer.accept("    " + index));
        });
    }

    private static boolean hasAtLeastOneIndex(Map<String, Set<String>> cacheToIndexes) {
        return !F.isEmpty(cacheToIndexes) && cacheToIndexes.values().stream().anyMatch(indexes -> !indexes.isEmpty());
    }

    static <T> void storeCacheAndIndexResults(Map<IgnitePair<T>, Set<UUID>> to, Map<T, Set<T>> values, UUID nodeId) {
        if (F.isEmpty(values)) {
            return;
        }
        values.forEach((cache, indexes) -> indexes.forEach(idx -> to.compute(new IgnitePair<Object>(cache, idx), (c0, idxs0) -> {
            if (idxs0 == null) {
                idxs0 = new HashSet<UUID>();
            }
            idxs0.add(nodeId);
            return idxs0;
        })));
    }
}

