/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.websession;

import java.sql.Timestamp;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.platform.websession.PlatformDotNetSessionData;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PlatformDotNetSessionLockResult
implements Binarylizable {
    private boolean success;
    private PlatformDotNetSessionData data;
    private Timestamp lockTime;
    private long lockId;

    public PlatformDotNetSessionLockResult() {
    }

    public PlatformDotNetSessionLockResult(boolean success, PlatformDotNetSessionData data, Timestamp lockTime, long lockId) {
        assert (success ^ data == null);
        this.success = success;
        this.data = data;
        this.lockTime = lockTime;
        this.lockId = lockId;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter raw = writer.rawWriter();
        this.writeBinary(raw);
    }

    public void writeBinary(BinaryRawWriter writer) {
        writer.writeBoolean(this.success);
        if (this.success) {
            this.data.writeBinary(writer);
        }
        writer.writeTimestamp(this.lockTime);
        writer.writeLong(this.lockId);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader raw = reader.rawReader();
        this.success = raw.readBoolean();
        if (this.success) {
            this.data = new PlatformDotNetSessionData();
            this.data.readBinary(raw);
        }
        this.lockTime = raw.readTimestamp();
        this.lockId = raw.readLong();
    }

    public String toString() {
        return S.toString(PlatformDotNetSessionLockResult.class, this);
    }
}

