/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.prometheus;

import com.google.common.annotations.VisibleForTesting;
import io.opencensus.exporter.metrics.util.MetricExporter;
import io.opencensus.exporter.metrics.util.MetricReader;
import io.opencensus.exporter.stats.prometheus.PrometheusExportUtils;
import io.opencensus.exporter.stats.prometheus.PrometheusStatsConfiguration;
import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.MetricProducerManager;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PrometheusStatsCollector
extends Collector
implements Collector.Describable {
    private static final Logger logger = Logger.getLogger(PrometheusStatsCollector.class.getName());
    private static final Tracer tracer = Tracing.getTracer();
    private static final String DESCRIBE_METRICS_FOR_PROMETHEUS = "DescribeMetricsToPrometheus";
    private static final String EXPORT_METRICS_TO_PROMETHEUS = "ExportMetricsToPrometheus";
    private final MetricReader collectMetricReader;
    private final MetricReader describeMetricReader;
    private final String namespace;

    public static void createAndRegister() {
        new PrometheusStatsCollector(Metrics.getExportComponent().getMetricProducerManager(), "").register();
    }

    public static void createAndRegister(PrometheusStatsConfiguration configuration) {
        CollectorRegistry registry = configuration.getRegistry();
        if (registry == null) {
            registry = CollectorRegistry.defaultRegistry;
        }
        new PrometheusStatsCollector(Metrics.getExportComponent().getMetricProducerManager(), configuration.getNamespace()).register(registry);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ExportMetricExporter exportMetricExporter = new ExportMetricExporter(this.namespace);
        this.collectMetricReader.readAndExport((MetricExporter)exportMetricExporter);
        return exportMetricExporter.samples;
    }

    public List<Collector.MetricFamilySamples> describe() {
        DescribeMetricExporter describeMetricExporter = new DescribeMetricExporter(this.namespace);
        this.describeMetricReader.readAndExport((MetricExporter)describeMetricExporter);
        return describeMetricExporter.samples;
    }

    @VisibleForTesting
    PrometheusStatsCollector(MetricProducerManager metricProducerManager, String namespace) {
        this.collectMetricReader = MetricReader.create((MetricReader.Options)MetricReader.Options.builder().setMetricProducerManager(metricProducerManager).setSpanName(EXPORT_METRICS_TO_PROMETHEUS).build());
        this.describeMetricReader = MetricReader.create((MetricReader.Options)MetricReader.Options.builder().setMetricProducerManager(metricProducerManager).setSpanName(DESCRIBE_METRICS_FOR_PROMETHEUS).build());
        this.namespace = namespace;
    }

    private static String exceptionMessage(Throwable e) {
        return e.getMessage() != null ? e.getMessage() : e.getClass().getName();
    }

    private static final class DescribeMetricExporter
    extends MetricExporter {
        private final ArrayList<Collector.MetricFamilySamples> samples = new ArrayList();
        private final String namespace;

        private DescribeMetricExporter(String namespace) {
            this.namespace = namespace;
        }

        public void export(Collection<Metric> metrics) {
            this.samples.ensureCapacity(metrics.size());
            for (Metric metric : metrics) {
                try {
                    this.samples.add(PrometheusExportUtils.createDescribableMetricFamilySamples(metric.getMetricDescriptor(), this.namespace));
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exception thrown when describing metrics.", e);
                    tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription("Exception thrown when describing Prometheus Metrics: " + PrometheusStatsCollector.exceptionMessage(e)));
                }
            }
        }
    }

    private static final class ExportMetricExporter
    extends MetricExporter {
        private final ArrayList<Collector.MetricFamilySamples> samples = new ArrayList();
        private final String namespace;

        private ExportMetricExporter(String namespace) {
            this.namespace = namespace;
        }

        public void export(Collection<Metric> metrics) {
            this.samples.ensureCapacity(metrics.size());
            for (Metric metric : metrics) {
                MetricDescriptor metricDescriptor = metric.getMetricDescriptor();
                if (PrometheusExportUtils.containsDisallowedLeLabelForHistogram(PrometheusExportUtils.convertToLabelNames(metricDescriptor.getLabelKeys()), PrometheusExportUtils.getType(metricDescriptor.getType())) || PrometheusExportUtils.containsDisallowedQuantileLabelForSummary(PrometheusExportUtils.convertToLabelNames(metricDescriptor.getLabelKeys()), PrometheusExportUtils.getType(metricDescriptor.getType()))) continue;
                try {
                    this.samples.add(PrometheusExportUtils.createMetricFamilySamples(metric, this.namespace));
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exception thrown when collecting metric samples.", e);
                    tracer.getCurrentSpan().setStatus(Status.UNKNOWN.withDescription("Exception thrown when collecting Prometheus Metric Samples: " + PrometheusStatsCollector.exceptionMessage(e)));
                }
            }
        }
    }
}

