/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework.report.jfreechart;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.probes.PercentileProbe;
import org.yardstickframework.probes.ThroughputLatencyProbe;
import org.yardstickframework.report.jfreechart.JFreeChartGenerationMode;
import org.yardstickframework.report.jfreechart.JFreeChartGraphPlotterArguments;
import org.yardstickframework.report.jfreechart.JFreeChartPlotInfo;
import org.yardstickframework.report.jfreechart.JFreeChartResultPageGenerator;
import org.yardstickframework.report.jfreechart.JFreeChartSummaryMode;
import org.yardstickframework.writers.BenchmarkProbePointCsvWriter;

public class JFreeChartGraphPlotter {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final String INPUT_FILE_EXTENSION = ".csv";
    private static final String MULTIPLE_DRIVERS_MARKER_FILE = ".multiple-drivers";
    private static final Color[] PLOT_COLORS = new Color[]{new Color(39, 174, 96), new Color(41, 128, 185), new Color(192, 57, 43), new Color(142, 68, 173), new Color(44, 62, 80), new Color(243, 156, 18), new Color(211, 84, 0), new Color(127, 140, 141), new Color(22, 160, 133)};
    static final Comparator<File> FILE_NAME_COMP = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };

    public static void main(String[] cmdArgs) {
        try {
            JFreeChartGraphPlotterArguments args = new JFreeChartGraphPlotterArguments();
            JCommander jCommander = BenchmarkUtils.jcommander(cmdArgs, args, "<graph-plotter>");
            if (args.help()) {
                jCommander.usage();
                return;
            }
            if (args.inputFolders().isEmpty()) {
                JFreeChartGraphPlotter.errorHelp("Input folders are not defined.");
                return;
            }
            List<String> inFoldersAsString = args.inputFolders();
            ArrayList<File> inFolders = new ArrayList<File>(inFoldersAsString.size());
            for (String folderAsString : inFoldersAsString) {
                inFolders.add(new File(folderAsString).getAbsoluteFile());
            }
            for (File inFolder : inFolders) {
                if (inFolder.exists()) continue;
                JFreeChartGraphPlotter.errorHelp("Folder does not exist: " + inFolder.getAbsolutePath());
                return;
            }
            ArrayList<List<List<File>>> benchFolders = new ArrayList<List<List<File>>>();
            for (File inFolder : inFolders) {
                File[] dirs0 = inFolder.listFiles();
                if (dirs0 == null || dirs0.length == 0) continue;
                ArrayList<File> dirs = new ArrayList<File>(Arrays.asList(dirs0));
                Collections.sort(dirs, FILE_NAME_COMP);
                boolean multipleDrivers = false;
                for (File f : dirs) {
                    if (!f.isFile() || !MULTIPLE_DRIVERS_MARKER_FILE.equals(f.getName())) continue;
                    multipleDrivers = true;
                    break;
                }
                ArrayList<List<File>> mulDrvFiles = new ArrayList<List<File>>();
                if (multipleDrivers) {
                    for (File f : dirs) {
                        List<File> files = JFreeChartGraphPlotter.getFiles(f);
                        if (files == null) continue;
                        mulDrvFiles.add(files);
                    }
                } else {
                    List<File> files = JFreeChartGraphPlotter.getFiles(inFolder);
                    if (files != null) {
                        mulDrvFiles.add(files);
                    }
                }
                benchFolders.add(JFreeChartGraphPlotter.mergeMultipleDriverLists(mulDrvFiles));
            }
            if (benchFolders.isEmpty()) {
                JFreeChartGraphPlotter.errorHelp("Input folders are empty or have invalid structure: " + inFoldersAsString);
                return;
            }
            String outputFolder = JFreeChartGraphPlotter.outputFolder(inFolders);
            JFreeChartGenerationMode mode = args.generationMode();
            if (mode == JFreeChartGenerationMode.COMPOUND) {
                JFreeChartGraphPlotter.processCompoundMode(outputFolder, benchFolders, args);
            } else if (mode == JFreeChartGenerationMode.COMPARISON) {
                JFreeChartGraphPlotter.processComparisonMode(outputFolder, benchFolders, args);
            } else if (mode == JFreeChartGenerationMode.STANDARD) {
                JFreeChartGraphPlotter.processStandardMode(benchFolders, args);
            } else {
                JFreeChartGraphPlotter.errorHelp("Unknown generation mode: " + (Object)((Object)args.generationMode()));
            }
        }
        catch (ParameterException e) {
            JFreeChartGraphPlotter.errorHelp("Invalid parameter.", e);
        }
        catch (Exception e) {
            JFreeChartGraphPlotter.errorHelp("Failed to execute graph generator.", e);
        }
    }

    private static List<File> getFiles(File inFolder) {
        File[] dirs = inFolder.listFiles();
        if (dirs == null || dirs.length == 0) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(dirs));
        int i = 0;
        while (i < files.size()) {
            if (!((File)files.get(i)).isDirectory()) {
                files.remove(i);
                continue;
            }
            ++i;
        }
        Collections.sort(files, FILE_NAME_COMP);
        return files;
    }

    private static List<List<File>> mergeMultipleDriverLists(List<List<File>> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<File>> res = new ArrayList<List<File>>();
        int idx = -1;
        while (true) {
            ++idx;
            ArrayList<File> l = new ArrayList<File>();
            for (List<File> files : list) {
                if (files.size() <= idx) continue;
                l.add(files.get(idx));
            }
            if (l.isEmpty()) break;
            res.add(l);
        }
        return res;
    }

    private static void processCompoundMode(String outputFolder, List<List<List<File>>> benchFolders, JFreeChartGraphPlotterArguments args) throws Exception {
        HashMap<String, List<List<List<File>>>> res = new HashMap<String, List<List<List<File>>>>();
        for (List<List<File>> f0 : benchFolders) {
            for (List<File> f1 : f0) {
                HashMap res0 = new HashMap();
                for (File f2 : f1) {
                    Map<String, List<File>> map;
                    if (!f2.isDirectory() || (map = JFreeChartGraphPlotter.files(f2)).isEmpty()) continue;
                    JFreeChartGraphPlotter.mergeMaps(res0, map);
                }
                if (res0.isEmpty()) continue;
                JFreeChartGraphPlotter.mergeMaps(res, res0);
            }
        }
        if (res.isEmpty()) {
            return;
        }
        String parentFolderName = "results-" + JFreeChartGenerationMode.COMPOUND.name().toLowerCase() + '-' + FORMAT.format(new Date());
        File folderToWrite = new File(outputFolder, parentFolderName = BenchmarkUtils.fixFolderName(parentFolderName));
        if (!folderToWrite.exists() && !folderToWrite.mkdir()) {
            JFreeChartGraphPlotter.throwException("Can not create folder: " + folderToWrite.getAbsolutePath());
        }
        JFreeChartGraphPlotter.processFilesPerProbe(res, folderToWrite, args, JFreeChartGenerationMode.COMPOUND);
    }

    private static void processComparisonMode(String outputFolder, List<List<List<File>>> benchFolders, JFreeChartGraphPlotterArguments args) throws Exception {
        String parentFolderName = "results-" + JFreeChartGenerationMode.COMPARISON.name().toLowerCase() + '-' + FORMAT.format(new Date());
        parentFolderName = BenchmarkUtils.fixFolderName(parentFolderName);
        File parentFolderToWrite = new File(outputFolder, parentFolderName);
        int idx = -1;
        while (true) {
            ++idx;
            boolean filesExist = false;
            HashMap<String, List<List<List<File>>>> res = new HashMap<String, List<List<List<File>>>>();
            for (List<List<File>> files : benchFolders) {
                if (files.size() <= idx) continue;
                filesExist = true;
                List<File> f = files.get(idx);
                HashMap res0 = new HashMap();
                for (File f0 : f) {
                    Map<String, List<File>> map;
                    if (!f0.isDirectory() || (map = JFreeChartGraphPlotter.files(f0)).isEmpty()) continue;
                    JFreeChartGraphPlotter.mergeMaps(res0, map);
                }
                if (res0.isEmpty()) continue;
                JFreeChartGraphPlotter.mergeMaps(res, res0);
            }
            if (!filesExist) break;
            List fList = res.isEmpty() ? null : (List)res.values().iterator().next();
            File parFile = fList == null || fList.isEmpty() ? null : ((File)((List)((List)fList.get(0)).get(0)).get(0)).getParentFile();
            String suffix = parFile == null ? "" : parFile.getName();
            String time = JFreeChartGraphPlotter.parseTime(suffix);
            if (time == null && parFile != null) {
                suffix = (parFile = parFile.getParentFile()) == null ? "" : parFile.getName();
                time = JFreeChartGraphPlotter.parseTime(suffix);
            }
            String string = suffix = time == null ? "" : suffix.substring(time.length());
            String idxPrefix = idx < 9 ? "00" : (idx < 99 ? "0" : "");
            String folName = idxPrefix + (idx + 1) + suffix;
            File folderToWrite = new File(parentFolderToWrite, folName = BenchmarkUtils.fixFolderName(folName));
            if (!folderToWrite.exists() && !folderToWrite.mkdirs()) {
                JFreeChartGraphPlotter.throwException("Can not create folder: " + folderToWrite.getAbsolutePath());
            }
            JFreeChartGraphPlotter.processFilesPerProbe(res, folderToWrite, args, JFreeChartGenerationMode.COMPARISON);
        }
    }

    private static void processStandardMode(List<List<List<File>>> inFolders, JFreeChartGraphPlotterArguments args) throws Exception {
        for (List<List<File>> f0 : inFolders) {
            for (List<File> f1 : f0) {
                for (File f2 : f1) {
                    HashMap<String, List<JFreeChartPlotInfo>> infoMap = new HashMap<String, List<JFreeChartPlotInfo>>();
                    for (List<File> files : JFreeChartGraphPlotter.files(f2).values()) {
                        for (File file : files) {
                            List<PlotData> plotData = JFreeChartGraphPlotter.readData(file);
                            if (plotData.isEmpty()) continue;
                            JFreeChartGraphPlotter.processPlots(file.getParentFile(), Collections.singleton(plotData), infoMap, JFreeChartGenerationMode.STANDARD);
                        }
                    }
                    JFreeChartResultPageGenerator.generate(f2, args, infoMap);
                }
            }
        }
    }

    private static void processFilesPerProbe(Map<String, List<List<List<File>>>> res, File folderToWrite, JFreeChartGraphPlotterArguments args, JFreeChartGenerationMode mode) throws Exception {
        HashMap<String, List<JFreeChartPlotInfo>> infoMap = new HashMap<String, List<JFreeChartPlotInfo>>();
        for (Map.Entry<String, List<List<List<File>>>> entry : res.entrySet()) {
            ArrayList<List<PlotData>> plots = new ArrayList<List<PlotData>>(entry.getValue().size());
            for (List<List<File>> files : entry.getValue()) {
                List<PlotData> pd;
                if ((files.size() > 1 || files.get(0).size() > 1) && args.summaryMode() == JFreeChartSummaryMode.SUM_ONLY) {
                    if (JFreeChartGraphPlotter.isProbeResultFile(entry, ThroughputLatencyProbe.class) || JFreeChartGraphPlotter.isProbeResultFile(entry, PercentileProbe.class)) {
                        ArrayList<List<PlotData>> plots0 = new ArrayList<List<PlotData>>(entry.getValue().size());
                        for (List<File> files0 : files) {
                            for (File file : files0) {
                                pd = JFreeChartGraphPlotter.readData(file);
                                if (pd.isEmpty()) continue;
                                plots0.add(pd);
                            }
                        }
                        List<PlotData> sumPlot = JFreeChartGraphPlotter.addSummaryPlot(plots0);
                        if (sumPlot.isEmpty()) continue;
                        plots.add(sumPlot);
                        continue;
                    }
                    List<PlotData> pd2 = JFreeChartGraphPlotter.readData(files.get(0).get(0));
                    if (pd2.isEmpty()) continue;
                    plots.add(pd2);
                    continue;
                }
                for (List<File> f0 : files) {
                    ArrayList<List<PlotData>> l = new ArrayList<List<PlotData>>(files.size());
                    for (File f1 : f0) {
                        pd = JFreeChartGraphPlotter.readData(f1);
                        if (pd.isEmpty()) continue;
                        plots.add(pd);
                        l.add(pd);
                    }
                    if (l.size() <= 1 || args.summaryMode() != JFreeChartSummaryMode.INDIVIDUAL_AND_SUM) continue;
                    if (JFreeChartGraphPlotter.isProbeResultFile(entry, ThroughputLatencyProbe.class) || JFreeChartGraphPlotter.isProbeResultFile(entry, PercentileProbe.class)) {
                        List<PlotData> sumPlot = JFreeChartGraphPlotter.addSummaryPlot(l);
                        if (sumPlot.isEmpty()) continue;
                        plots.add(sumPlot);
                        continue;
                    }
                    List<PlotData> pd3 = JFreeChartGraphPlotter.readData(f0.get(0));
                    if (pd3.isEmpty()) continue;
                    plots.add(pd3);
                }
            }
            JFreeChartGraphPlotter.processPlots(folderToWrite, plots, infoMap, mode);
        }
        if (!infoMap.isEmpty()) {
            JFreeChartResultPageGenerator.generate(folderToWrite, args, infoMap);
        }
    }

    private static <T> boolean isProbeResultFile(Map.Entry<String, T> entry, Class probeCls) {
        return entry.getKey().equals(probeCls.getSimpleName() + INPUT_FILE_EXTENSION);
    }

    private static List<PlotData> addSummaryPlot(Collection<List<PlotData>> plots) {
        int idx = -1;
        ArrayList<PlotData> sumPlot = new ArrayList<PlotData>();
        while (true) {
            ++idx;
            PlotData sumPlotData = null;
            for (List<PlotData> plotData0 : plots) {
                if (plotData0.size() <= idx) continue;
                PlotData plotData = plotData0.get(idx);
                double[][] data = plotData.series().data;
                if (sumPlotData == null) {
                    PlotSeries sumSeries = new PlotSeries(plotData.series().seriesName);
                    PlotSeries.access$002(sumSeries, new double[data.length][]);
                    sumPlotData = new PlotData(plotData.plotName(), sumSeries, plotData.xAxisLabel, plotData.yAxisLabel);
                }
                sumPlotData.series().addConfigurations(plotData.series().cfg);
                double[][] sumData = sumPlotData.series().data;
                if (sumData[0] == null) {
                    sumData[0] = JFreeChartGraphPlotter.copy(data[0]);
                    sumData[1] = JFreeChartGraphPlotter.copy(data[1]);
                    continue;
                }
                if (sumData[0].length <= data[0].length) {
                    for (int i = 0; i < sumData[0].length; ++i) {
                        double[] dArray = sumData[1];
                        int n = i;
                        dArray[n] = dArray[n] + data[1][i];
                    }
                    continue;
                }
                double[] tmp = sumData[1];
                sumData[0] = JFreeChartGraphPlotter.copy(data[0]);
                sumData[1] = JFreeChartGraphPlotter.copy(data[1]);
                for (int i = 0; i < data[0].length; ++i) {
                    double[] dArray = sumData[1];
                    int n = i;
                    dArray[n] = dArray[n] + tmp[i];
                }
            }
            if (sumPlotData == null) break;
            sumPlot.add(sumPlotData);
        }
        return sumPlot;
    }

    private static double[] copy(double[] src) {
        double[] res = new double[src.length];
        System.arraycopy(src, 0, res, 0, src.length);
        return res;
    }

    private static <T> void mergeMaps(Map<String, List<T>> res, Map<String, T> map) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            List<T> list = res.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<T>();
                res.put(entry.getKey(), list);
            }
            list.add(entry.getValue());
        }
    }

    private static Map<String, List<File>> files(File folder) {
        File[] dirs = folder.listFiles();
        if (dirs == null || dirs.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, List<File>> res = new HashMap<String, List<File>>();
        JFreeChartGraphPlotter.files0(dirs, res);
        return res;
    }

    private static void files0(File[] files, Map<String, List<File>> res) {
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList<File> fs = new ArrayList<File>(Arrays.asList(files));
        Collections.sort(fs, FILE_NAME_COMP);
        for (File file : fs) {
            if (file.isDirectory()) {
                JFreeChartGraphPlotter.files0(file.listFiles(), res);
                continue;
            }
            JFreeChartGraphPlotter.addFile(file, res);
        }
    }

    private static void addFile(File file, Map<String, List<File>> res) {
        if (file.isDirectory()) {
            return;
        }
        if (!file.canRead()) {
            JFreeChartGraphPlotter.errorHelp("File can not be read: " + file.getAbsolutePath());
            return;
        }
        if (file.getName().endsWith(INPUT_FILE_EXTENSION)) {
            List<File> list = res.get(file.getName());
            if (list == null) {
                list = new ArrayList<File>();
                res.put(file.getName(), list);
            }
            list.add(file);
        }
    }

    private static void processPlots(File folderToWrite, Collection<List<PlotData>> plots, Map<String, List<JFreeChartPlotInfo>> infoMap, JFreeChartGenerationMode mode) throws Exception {
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        int idx = -1;
        while (true) {
            ++idx;
            DefaultXYDataset dataSet = new DefaultXYDataset();
            ArrayList<JFreeChartPlotInfo> infoList = new ArrayList<JFreeChartPlotInfo>();
            String xAxisLabel = "";
            String yAxisLabel = "";
            String plotName = "";
            int cnt = 0;
            for (List<PlotData> plotData0 : plots) {
                if (plotData0.size() <= idx) continue;
                PlotData plotData = plotData0.get(idx);
                dataSet.addSeries((Comparable)((Object)(plotData.plotName() + "_" + cnt++)), plotData.series().data);
                xAxisLabel = plotData.xAxisLabel;
                yAxisLabel = plotData.yAxisLabel;
                plotName = plotData.plotName();
                infoList.add(JFreeChartGraphPlotter.info(plotData.series(), mode));
            }
            if (infoList.isEmpty()) break;
            JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)xAxisLabel, (String)yAxisLabel, (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            AxisSpace as = new AxisSpace();
            as.add(150.0, RectangleEdge.LEFT);
            XYPlot plot = (XYPlot)chart.getPlot();
            BasicStroke stroke = new BasicStroke(1.0f);
            plot.setRenderer((XYItemRenderer)renderer);
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setRangeGridlinePaint((Paint)Color.GRAY);
            plot.setDomainGridlinePaint((Paint)Color.GRAY);
            plot.setFixedRangeAxisSpace(as);
            plot.setOutlineStroke((Stroke)stroke);
            for (int i = 0; i < infoList.size(); ++i) {
                Color color = PLOT_COLORS[i % PLOT_COLORS.length];
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
                ((JFreeChartPlotInfo)infoList.get(i)).color(Integer.toHexString(color.getRGB()).substring(2));
            }
            ValueAxis axis = plot.getRangeAxis();
            Font font = new Font("Helvetica,Arial,sans-serif", 1, axis.getTickLabelFont().getSize() + 5);
            axis.setTickLabelFont(font);
            axis.setLabelFont(font);
            plot.getDomainAxis().setTickLabelFont(font);
            plot.getDomainAxis().setLabelFont(font);
            chart.setTitle(new TextTitle(yAxisLabel, new Font(font.getName(), font.getStyle(), 30)));
            File res = new File(folderToWrite, plotName + ".png");
            ChartUtilities.saveChartAsPNG((File)res, (JFreeChart)chart, (int)1000, (int)500, (ChartRenderingInfo)info);
            infoMap.put(res.getAbsolutePath(), infoList);
            BenchmarkUtils.println("Chart is saved to file: ", res);
        }
    }

    private static JFreeChartPlotInfo info(PlotSeries series, JFreeChartGenerationMode mode) {
        double sum = 0.0;
        double min = 9.223372036854776E18;
        double max = -9.223372036854776E18;
        int len = series.data[1].length;
        if (len == 1) {
            double val = series.data[1][0];
            return new JFreeChartPlotInfo(series.seriesName, series.configuration(), val, val, val, 0.0, mode);
        }
        for (int i = 0; i < len; ++i) {
            double val = series.data[1][i];
            min = Math.min(min, val);
            max = Math.max(max, val);
            sum += val;
        }
        double avg = sum / (double)len;
        double s = 0.0;
        for (int i = 0; i < len; ++i) {
            double val = series.data[1][i];
            s += Math.pow(val - avg, 2.0);
        }
        double stdDiv = Math.sqrt(s / (double)(len - 1));
        return new JFreeChartPlotInfo(series.seriesName, series.configuration(), avg, min, max, stdDiv, mode);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<PlotData> readData(File file) throws Exception {
        ArrayList<PlotData> data = new ArrayList<PlotData>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            long initTime = 0L;
            String drvNames = null;
            String[] metaInfo = null;
            while ((line = br.readLine()) != null) {
                int i;
                if (line.startsWith("--")) continue;
                if (line.startsWith("@@")) {
                    drvNames = line.substring("@@".length());
                    List<String> drvNamesList = Arrays.asList(drvNames.split(","));
                    Collections.sort(drvNamesList);
                    drvNames = drvNamesList.toString().replaceAll("\\[", "").replaceAll("]", "");
                    continue;
                }
                if (line.startsWith("**")) {
                    metaInfo = line.substring("**".length()).split("\",\"");
                    continue;
                }
                String[] split = line.split(",");
                if (data.isEmpty()) {
                    initTime = Long.parseLong(split[0]);
                    int plotNum = split.length - 1;
                    if (plotNum < 1) {
                        JFreeChartGraphPlotter.throwException("Invalid data file: " + file.getAbsolutePath());
                    }
                    String xAxisLabel = metaInfo == null || metaInfo.length == 0 ? "" : metaInfo[0].replace("\"", "");
                    for (int i2 = 0; i2 < plotNum; ++i2) {
                        PlotSeries single = new PlotSeries(drvNames);
                        single.addConfiguration(file.getParentFile().getName());
                        String yAxisLabel = metaInfo == null || i2 + 1 >= metaInfo.length ? "" : metaInfo[i2 + 1].replace("\"", "");
                        String plotName = file.getName().replace(INPUT_FILE_EXTENSION, "");
                        String cnt = Integer.toString(i2 + 1);
                        cnt = cnt.length() == 1 ? "0" + cnt : cnt;
                        data.add(new PlotData("Plot_" + plotName + "_" + cnt, single, xAxisLabel, yAxisLabel));
                    }
                }
                double[] tup = new double[split.length];
                for (i = 0; i < tup.length; ++i) {
                    double d;
                    tup[i] = d = i == 0 ? (double)(Long.parseLong(split[0]) - initTime) : Double.parseDouble(split[i]);
                }
                for (i = 0; i < split.length - 1; ++i) {
                    ((PlotData)data.get(i)).series().rawData().add(new double[]{tup[0], tup[i + 1]});
                }
            }
            for (PlotData plotData : data) {
                plotData.series().finish();
            }
            ArrayList<PlotData> arrayList = data;
            return arrayList;
        }
        catch (Exception e) {
            JFreeChartGraphPlotter.errorHelp("Exception is raised while processing file (will skip): " + file.getAbsolutePath(), e);
            return Collections.emptyList();
        }
    }

    static String parseTime(String fName) {
        int i = fName.indexOf(45, fName.indexOf(45) + 1);
        if (i != -1) {
            try {
                String time = fName.substring(0, i);
                BenchmarkProbePointCsvWriter.FORMAT.parse(time);
                return time;
            }
            catch (ParseException ignored) {
                return null;
            }
        }
        return null;
    }

    private static String outputFolder(List<File> inFolders) {
        return inFolders.size() != 1 ? null : (inFolders.get(0).getParent() == null ? inFolders.get(0).getName() : inFolders.get(0).getParent());
    }

    private static void throwException(String msg) throws Exception {
        throw new Exception("ERROR: " + msg);
    }

    static void errorHelp(String msg) {
        System.err.println("ERROR: " + msg);
        System.err.println("Type '--help' for usage.");
    }

    static void errorHelp(String msg, Throwable t) {
        JFreeChartGraphPlotter.errorHelp(msg);
        if (t != null) {
            t.printStackTrace();
        }
    }

    static class PlotSeries {
        private final String seriesName;
        private final List<String> cfg = new ArrayList<String>();
        private List<double[]> rawData = new ArrayList<double[]>();
        private double[][] data;

        PlotSeries(String seriesName) {
            this.seriesName = seriesName;
        }

        public void addConfiguration(String cfg) {
            this.cfg.add(cfg);
        }

        public void addConfigurations(List<String> cfg) {
            this.cfg.addAll(cfg);
        }

        public Collection<String> configuration() {
            Collections.sort(this.cfg);
            return this.cfg;
        }

        public List<double[]> rawData() {
            return this.rawData;
        }

        public void correctValues() {
            int i;
            int firstNanIdx = -1;
            for (i = 0; i < this.rawData.size(); ++i) {
                double val = this.rawData.get(i)[1];
                if (PlotSeries.incorrect(val)) {
                    if (firstNanIdx != -1) continue;
                    firstNanIdx = i;
                    continue;
                }
                if (i <= 0 || firstNanIdx == -1) continue;
                for (int j = i; j >= firstNanIdx; --j) {
                    double newVal;
                    if (j - 1 < 0 || !PlotSeries.incorrect(this.rawData.get(j - 1)[1])) continue;
                    this.rawData.get((int)(j - 1))[1] = newVal = j - 2 >= 0 && !PlotSeries.incorrect(this.rawData.get(j - 2)[1]) ? (this.rawData.get(j - 2)[1] + this.rawData.get(j)[1]) / 2.0 : this.rawData.get(j)[1];
                }
                firstNanIdx = -1;
            }
            if (firstNanIdx != -1) {
                for (i = firstNanIdx; i < this.rawData.size(); ++i) {
                    double newVal;
                    if (i - 1 < 0 || !PlotSeries.incorrect(this.rawData.get(i)[1])) continue;
                    this.rawData.get((int)i)[1] = newVal = i + 1 < this.rawData.size() && !PlotSeries.incorrect(this.rawData.get(i + 1)[1]) ? (this.rawData.get(i + 1)[1] + this.rawData.get(i - 1)[1]) / 2.0 : this.rawData.get(i - 1)[1];
                }
            }
        }

        private static boolean incorrect(double val) {
            return Double.isNaN(val) || Double.isInfinite(val);
        }

        public void finish() {
            this.correctValues();
            this.data = new double[2][];
            this.data[0] = new double[this.rawData.size()];
            this.data[1] = new double[this.rawData.size()];
            for (int i = 0; i < this.rawData.size(); ++i) {
                double[] tup = this.rawData.get(i);
                this.data[0][i] = tup[0];
                this.data[1][i] = tup[1];
            }
            this.rawData = null;
        }

        static /* synthetic */ double[][] access$002(PlotSeries x0, double[][] x1) {
            x0.data = x1;
            return x1;
        }
    }

    private static class PlotData {
        private final PlotSeries series;
        private final String plotName;
        private final String xAxisLabel;
        private final String yAxisLabel;

        PlotData(String plotName, PlotSeries series, String xAxisLabel, String yAxisLabel) {
            this.plotName = plotName;
            this.series = series;
            this.xAxisLabel = xAxisLabel;
            this.yAxisLabel = yAxisLabel;
        }

        public PlotSeries series() {
            return this.series;
        }

        public String plotName() {
            return this.plotName;
        }
    }
}

