/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.client.thin.ClientBinaryMarshaller;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientUtils;
import org.apache.ignite.internal.client.thin.FieldsQueryPager;
import org.apache.ignite.internal.client.thin.GenericQueryPager;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.client.thin.TcpClientTransactions;
import org.jetbrains.annotations.Nullable;

class ClientFieldsQueryPager
extends GenericQueryPager<List<?>>
implements FieldsQueryPager<List<?>> {
    private final boolean keepBinary;
    private List<String> fieldNames = new ArrayList<String>();
    private final ClientUtils serDes;

    ClientFieldsQueryPager(ReliableChannel ch, @Nullable TcpClientTransactions.TcpClientTransaction tx, ClientOperation qryOp, ClientOperation pageQryOp, Consumer<PayloadOutputChannel> qryWriter, boolean keepBinary, ClientBinaryMarshaller marsh) {
        super(ch, tx, qryOp, pageQryOp, qryWriter);
        this.keepBinary = keepBinary;
        this.serDes = new ClientUtils(marsh);
    }

    @Override
    Collection<List<?>> readEntries(PayloadInputChannel payloadCh) {
        BinaryInputStream in = payloadCh.in();
        if (!this.hasFirstPage()) {
            this.fieldNames = new ArrayList<String>(ClientUtils.collection(in, ignored -> (String)this.serDes.readObject(in, this.keepBinary)));
        }
        int rowCnt = in.readInt();
        ArrayList res = new ArrayList(rowCnt);
        for (int r = 0; r < rowCnt; ++r) {
            ArrayList row = new ArrayList(this.fieldNames.size());
            for (int f = 0; f < this.fieldNames.size(); ++f) {
                row.add(this.serDes.readObject(in, this.keepBinary));
            }
            res.add(row);
        }
        return res;
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }
}

