/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Asserts;

public class AsyncEchoHandler
implements AsyncServerExchangeHandler {
    private final BasicAsyncEntityConsumer entityConsumer = new BasicAsyncEntityConsumer();
    private final AtomicReference<AsyncEntityProducer> entityProducerRef = new AtomicReference<Object>(null);

    public void releaseResources() {
        this.entityConsumer.releaseResources();
        AsyncEntityProducer producer = this.entityProducerRef.getAndSet(null);
        if (producer != null) {
            producer.releaseResources();
        }
    }

    public void handleRequest(HttpRequest request, EntityDetails entityDetails, final ResponseChannel responseChannel, final HttpContext context) throws HttpException, IOException {
        String method = request.getMethod();
        if (!("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method))) {
            throw new MethodNotSupportedException(method + " not supported by " + this.getClass().getName());
        }
        if (entityDetails != null) {
            final ContentType contentType = ContentType.parseLenient((CharSequence)entityDetails.getContentType());
            this.entityConsumer.streamStart(entityDetails, (FutureCallback)new FutureCallback<byte[]>(){

                public void completed(byte[] content) {
                    BasicAsyncEntityProducer entityProducer = new BasicAsyncEntityProducer(content, contentType);
                    AsyncEchoHandler.this.entityProducerRef.set(entityProducer);
                    try {
                        responseChannel.sendResponse((HttpResponse)new BasicHttpResponse(200), (EntityDetails)entityProducer, context);
                    }
                    catch (IOException | HttpException ex) {
                        this.failed((Exception)ex);
                    }
                }

                public void failed(Exception ex) {
                    AsyncEchoHandler.this.releaseResources();
                }

                public void cancelled() {
                    AsyncEchoHandler.this.releaseResources();
                }
            });
        } else {
            responseChannel.sendResponse((HttpResponse)new BasicHttpResponse(200), null, context);
            this.entityConsumer.releaseResources();
        }
    }

    public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        this.entityConsumer.updateCapacity(capacityChannel);
    }

    public void consume(ByteBuffer src) throws IOException {
        this.entityConsumer.consume(src);
    }

    public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        this.entityConsumer.streamEnd(trailers);
    }

    public int available() {
        AsyncEntityProducer producer = this.entityProducerRef.get();
        Asserts.notNull((Object)producer, (String)"Entity producer");
        return producer.available();
    }

    public void produce(DataStreamChannel channel) throws IOException {
        AsyncEntityProducer producer = this.entityProducerRef.get();
        Asserts.notNull((Object)producer, (String)"Entity producer");
        producer.produce(channel);
    }

    public void failed(Exception cause) {
        this.releaseResources();
    }
}

