/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.parameters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.NamedParameterDefinition;
import org.apache.hop.core.parameters.UnknownParamException;

public class NamedParametersDefnitions
implements INamedParameterDefinitions {
    protected Map<String, NamedParameterDefinition> params = new HashMap<String, NamedParameterDefinition>();

    @Override
    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        if (this.params.get(key) != null) {
            throw new DuplicateParamException("Duplicate parameter '" + key + "' detected.");
        }
        NamedParameterDefinition oneParam = new NamedParameterDefinition();
        oneParam.key = key;
        oneParam.defaultValue = defValue;
        oneParam.description = description;
        this.params.put(key, oneParam);
    }

    @Override
    public String getParameterDescription(String key) throws UnknownParamException {
        String description = null;
        NamedParameterDefinition theParam = this.params.get(key);
        if (theParam != null) {
            description = theParam.description;
        }
        return description;
    }

    @Override
    public String getParameterDefault(String key) throws UnknownParamException {
        String value = null;
        NamedParameterDefinition theParam = this.params.get(key);
        if (theParam != null) {
            value = theParam.defaultValue;
        }
        return value;
    }

    @Override
    public String[] listParameters() {
        Set<String> keySet = this.params.keySet();
        Object[] paramArray = keySet.toArray(new String[0]);
        Arrays.sort(paramArray);
        return paramArray;
    }

    @Override
    public void removeAllParameters() {
        this.params.clear();
    }
}

