/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DatastoreEmulatorOptions {
    private final Map<String, String> envVars;
    private final String cmd;
    private final List<String> cmdLineOptions;
    private final String projectId;

    DatastoreEmulatorOptions(Map<String, String> envVars, String cmd, List<String> cmdLineOptions, String projectId) {
        this.envVars = envVars;
        this.cmd = cmd;
        this.cmdLineOptions = cmdLineOptions;
        this.projectId = projectId;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public List<String> getCmdLineOptions() {
        return this.cmdLineOptions;
    }

    public String getCmd() {
        return this.cmd;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    public static class Builder {
        private final Map<String, String> envVars = new HashMap<String, String>();
        private final List<String> cmdLineOptions = new ArrayList<String>();
        private String cmd = "./cloud_datastore_emulator";
        private String projectId;

        public DatastoreEmulatorOptions build() {
            return new DatastoreEmulatorOptions(this.envVars, this.cmd, this.cmdLineOptions, this.projectId);
        }

        public Builder addEnvVar(String var, String value) {
            this.envVars.put(var, value);
            return this;
        }

        public Builder addCmdLineOption(String option) {
            this.cmdLineOptions.add(option);
            return this;
        }

        public Builder addCmdLineOptions(Collection<String> options) {
            this.cmdLineOptions.addAll(options);
            return this;
        }

        public Builder setCommand(String cmd) {
            this.cmd = cmd;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }
    }
}

