/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AttributeValueCoder
extends AtomicCoder<AttributeValue> {
    private static final @UnknownKeyFor @NonNull @Initialized AttributeValueCoder INSTANCE = new AttributeValueCoder();
    private static final @UnknownKeyFor @NonNull @Initialized ListCoder<@UnknownKeyFor @NonNull @Initialized String> LIST_STRING_CODER = ListCoder.of((Coder)StringUtf8Coder.of());
    private static final @UnknownKeyFor @NonNull @Initialized ListCoder<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> LIST_BYTE_CODER = ListCoder.of((Coder)ByteArrayCoder.of());
    private static final @UnknownKeyFor @NonNull @Initialized ListCoder<@UnknownKeyFor @NonNull @Initialized AttributeValue> LIST_ATTRIBUTE_CODER = ListCoder.of((Coder)AttributeValueCoder.of());
    private static final @UnknownKeyFor @NonNull @Initialized MapCoder<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue> MAP_ATTRIBUTE_CODER = MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)AttributeValueCoder.of());

    private AttributeValueCoder() {
    }

    public static @UnknownKeyFor @NonNull @Initialized AttributeValueCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized AttributeValue value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (value.getS() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.s.toString(), outStream);
            StringUtf8Coder.of().encode(value.getS(), outStream);
        } else if (value.getN() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.n.toString(), outStream);
            StringUtf8Coder.of().encode(value.getN(), outStream);
        } else if (value.getBOOL() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.bOOL.toString(), outStream);
            BooleanCoder.of().encode(value.getBOOL(), outStream);
        } else if (value.getB() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.b.toString(), outStream);
            ByteArrayCoder.of().encode(this.convertToByteArray(value.getB()), outStream);
        } else if (value.getSS() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.sS.toString(), outStream);
            LIST_STRING_CODER.encode((Iterable)value.getSS(), outStream);
        } else if (value.getNS() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.nS.toString(), outStream);
            LIST_STRING_CODER.encode((Iterable)value.getNS(), outStream);
        } else if (value.getBS() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.bS.toString(), outStream);
            LIST_BYTE_CODER.encode(this.convertToListByteArray(value.getBS()), outStream);
        } else if (value.getL() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.l.toString(), outStream);
            LIST_ATTRIBUTE_CODER.encode((Iterable)value.getL(), outStream);
        } else if (value.getM() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.m.toString(), outStream);
            MAP_ATTRIBUTE_CODER.encode(value.getM(), outStream);
        } else if (value.getNULL() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.nULLValue.toString(), outStream);
            BooleanCoder.of().encode(value.getNULL(), outStream);
        } else {
            throw new CoderException("Unknown Type");
        }
    }

    public @UnknownKeyFor @NonNull @Initialized AttributeValue decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        AttributeValue attrValue = new AttributeValue();
        String type = StringUtf8Coder.of().decode(inStream);
        AttributeValueType attrType = AttributeValueType.valueOf(type);
        switch (attrType) {
            case s: {
                attrValue.setS(StringUtf8Coder.of().decode(inStream));
                break;
            }
            case n: {
                attrValue.setN(StringUtf8Coder.of().decode(inStream));
                break;
            }
            case bOOL: {
                attrValue.setBOOL(BooleanCoder.of().decode(inStream));
                break;
            }
            case b: {
                attrValue.setB(ByteBuffer.wrap(ByteArrayCoder.of().decode(inStream)));
                break;
            }
            case sS: {
                attrValue.setSS((Collection)LIST_STRING_CODER.decode(inStream));
                break;
            }
            case nS: {
                attrValue.setNS((Collection)LIST_STRING_CODER.decode(inStream));
                break;
            }
            case bS: {
                attrValue.setBS(this.convertToListByteBuffer((List)LIST_BYTE_CODER.decode(inStream)));
                break;
            }
            case l: {
                attrValue.setL((Collection)LIST_ATTRIBUTE_CODER.decode(inStream));
                break;
            }
            case m: {
                attrValue.setM(MAP_ATTRIBUTE_CODER.decode(inStream));
                break;
            }
            case nULLValue: {
                attrValue.setNULL(BooleanCoder.of().decode(inStream));
                break;
            }
            default: {
                throw new CoderException("Unknown Type");
            }
        }
        return attrValue;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> convertToListByteArray(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteBuffer> listByteBuffer) {
        return listByteBuffer.stream().map(this::convertToByteArray).collect(Collectors.toList());
    }

    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] convertToByteArray(@UnknownKeyFor @NonNull @Initialized ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        buffer.position(buffer.position() - bytes.length);
        return bytes;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ByteBuffer> convertToListByteBuffer(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> listByteArr) {
        return listByteArr.stream().map(ByteBuffer::wrap).collect(Collectors.toList());
    }

    private static enum AttributeValueType {
        s,
        n,
        b,
        sS,
        nS,
        bS,
        m,
        l,
        bOOL,
        nULLValue;

    }
}

