/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotSelectionStrategyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SlotSelectionStrategyUtils.class);

    public static SlotSelectionStrategy selectSlotSelectionStrategy(JobType jobType, Configuration configuration) {
        boolean evenlySpreadOutSlots = configuration.getBoolean(ClusterOptions.EVENLY_SPREAD_OUT_SLOTS_STRATEGY);
        LocationPreferenceSlotSelectionStrategy locationPreferenceSlotSelectionStrategy = evenlySpreadOutSlots ? LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut() : LocationPreferenceSlotSelectionStrategy.createDefault();
        boolean isLocalRecoveryEnabled = configuration.getBoolean(CheckpointingOptions.LOCAL_RECOVERY);
        if (isLocalRecoveryEnabled) {
            if (jobType == JobType.STREAMING) {
                return PreviousAllocationSlotSelectionStrategy.create(locationPreferenceSlotSelectionStrategy);
            }
            LOG.warn("Batch job does not support local recovery. Falling back to use " + locationPreferenceSlotSelectionStrategy.getClass());
            return locationPreferenceSlotSelectionStrategy;
        }
        return locationPreferenceSlotSelectionStrategy;
    }

    private SlotSelectionStrategyUtils() {
    }
}

