/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.execution;

import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.ui.core.PropsUi;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public abstract class DragViewZoomBase
extends Composite {
    protected Canvas canvas;
    protected DPoint offset;
    protected Point maximum;
    protected float magnification = 1.0f;
    protected org.apache.hop.core.gui.Rectangle viewPort;
    protected org.apache.hop.core.gui.Rectangle graphPort;
    protected boolean viewDrag;
    protected Point viewDragStart;
    protected DPoint viewDragBaseOffset;
    protected boolean viewPortNavigation;
    protected Point viewPortStart;

    public DragViewZoomBase(Composite parent, int style) {
        super(parent, style);
    }

    public abstract void redraw();

    public Point screen2real(int x, int y) {
        float correctedMagnification = this.calculateCorrectedMagnification();
        DPoint real = new DPoint(((double)x - this.offset.x) / (double)correctedMagnification - this.offset.x, ((double)y - this.offset.y) / (double)correctedMagnification - this.offset.y);
        return real.toPoint();
    }

    protected float calculateCorrectedMagnification() {
        return (float)((double)this.magnification * PropsUi.getInstance().getZoomFactor());
    }

    public abstract void setZoomLabel();

    @GuiKeyboardShortcut(key=0x1000007)
    @GuiOsxKeyboardShortcut(key=0x1000007)
    public void viewReset() {
        this.offset = new DPoint(0.0, 0.0);
        this.redraw();
    }

    @GuiKeyboardShortcut(key=0x1000003)
    @GuiOsxKeyboardShortcut(key=0x1000003)
    public void viewLeft() {
        this.offset.x += (double)(15.0f * this.magnification) * PropsUi.getNativeZoomFactor();
        this.validateOffset();
        this.redraw();
    }

    @GuiKeyboardShortcut(key=0x1000004)
    @GuiOsxKeyboardShortcut(key=0x1000004)
    public void viewRight() {
        this.offset.x -= (double)(15.0f * this.magnification) * PropsUi.getNativeZoomFactor();
        this.validateOffset();
        this.redraw();
    }

    @GuiKeyboardShortcut(key=0x1000001)
    @GuiOsxKeyboardShortcut(key=0x1000001)
    public void viewUp() {
        this.offset.y += (double)(15.0f * this.magnification) * PropsUi.getNativeZoomFactor();
        this.validateOffset();
        this.redraw();
    }

    @GuiKeyboardShortcut(key=0x1000002)
    @GuiOsxKeyboardShortcut(key=0x1000002)
    public void viewDown() {
        this.offset.y -= (double)(15.0f * this.magnification) * PropsUi.getNativeZoomFactor();
        this.validateOffset();
        this.redraw();
    }

    @GuiKeyboardShortcut(control=true, key=43)
    public void zoomIn() {
        this.magnification += 0.1f;
        if (this.magnification > 10.0f) {
            this.magnification = 10.0f;
        }
        this.setZoomLabel();
        this.redraw();
    }

    public void zoomIn(MouseEvent mouseEvent) {
        double oldZoomFactor = PropsUi.getNativeZoomFactor() * Math.max(0.1, (double)this.magnification);
        Point area = this.getArea();
        double oldViewWidth = (double)area.x / oldZoomFactor;
        double oldViewHeight = (double)area.y / oldZoomFactor;
        this.magnification += 0.1f;
        if (this.magnification > 10.0f) {
            this.magnification = 10.0f;
        }
        double zoomFactor = PropsUi.getNativeZoomFactor() * Math.max(0.1, (double)this.magnification);
        double viewWidth = (double)area.x / zoomFactor;
        double viewHeight = (double)area.y / zoomFactor;
        this.offset.x += Math.floor((double)mouseEvent.x / (double)area.x * 100.0) / 100.0 * (viewWidth - oldViewWidth);
        this.offset.y += Math.floor((double)mouseEvent.y / (double)area.y * 100.0) / 100.0 * (viewHeight - oldViewHeight);
        this.setZoomLabel();
        this.redraw();
    }

    @GuiKeyboardShortcut(control=true, key=61)
    public void zoomIn2() {
        this.zoomIn();
    }

    @GuiKeyboardShortcut(control=true, key=45)
    public void zoomOut() {
        this.magnification -= 0.1f;
        if (this.magnification < 0.1f) {
            this.magnification = 0.1f;
        }
        this.setZoomLabel();
        this.redraw();
    }

    public void zoomOut(MouseEvent mouseEvent) {
        double oldZoomFactor = PropsUi.getNativeZoomFactor() * Math.max(0.1, (double)this.magnification);
        Point area = this.getArea();
        double oldViewWidth = (double)area.x / oldZoomFactor;
        double oldViewHeight = (double)area.y / oldZoomFactor;
        this.magnification -= 0.1f;
        if (this.magnification < 0.1f) {
            this.magnification = 0.1f;
        }
        double zoomFactor = PropsUi.getNativeZoomFactor() * Math.max(0.1, (double)this.magnification);
        double viewWidth = (double)area.x / zoomFactor;
        double viewHeight = (double)area.y / zoomFactor;
        this.offset.x += (double)mouseEvent.x / (double)area.x * (viewWidth - oldViewWidth);
        this.offset.y += (double)mouseEvent.y / (double)area.y * (viewHeight - oldViewHeight);
        this.offset.x = this.offset.x > 0.0 ? 0.0 : this.offset.x;
        this.offset.y = this.offset.y > 0.0 ? 0.0 : this.offset.y;
        this.setZoomLabel();
        this.redraw();
    }

    @GuiKeyboardShortcut(control=true, key=48)
    public void zoom100Percent() {
        this.magnification = 1.0f;
        this.setZoomLabel();
        this.redraw();
    }

    @GuiKeyboardShortcut(control=true, key=0x1000030)
    public void zoom100Percent2() {
        this.zoom100Percent();
    }

    @GuiKeyboardShortcut(control=true, key=42)
    public void zoomFitToScreen() {
        if (this.maximum.x <= 0 || this.maximum.y <= 0) {
            return;
        }
        Rectangle canvasBounds = this.canvas.getBounds();
        double zoomXPct = (double)canvasBounds.width / ((double)this.maximum.x * PropsUi.getNativeZoomFactor()) * 0.9;
        double zoomYPct = (double)canvasBounds.height / ((double)this.maximum.y * PropsUi.getNativeZoomFactor()) * 0.9;
        this.magnification = (float)Math.min(zoomXPct, zoomYPct);
        this.offset = new DPoint(0.0, 0.0);
        this.setZoomLabel();
        this.canvas.redraw();
    }

    @GuiKeyboardShortcut(control=true, key=16777258)
    public void zoomFitToScreen2() {
        this.zoomFitToScreen();
    }

    protected boolean setupDragView(int button, boolean control, Point screenClick) {
        if (this.viewPort != null && this.viewPort.contains(screenClick)) {
            this.viewPortNavigation = true;
            this.viewPortStart = new Point(screenClick);
            this.viewDragBaseOffset = new DPoint(this.offset);
            this.setCursor(this.getDisplay().getSystemCursor(5));
            return true;
        }
        boolean bl = this.viewDrag = button == 2 || control && button == 1;
        if (this.viewDrag) {
            this.viewDragStart = screenClick;
            this.viewDragBaseOffset = new DPoint(this.offset);
            this.setCursor(this.getDisplay().getSystemCursor(5));
            return true;
        }
        return false;
    }

    protected void dragViewPort(Point clickLocation) {
        double deltaX = clickLocation.x - this.viewPortStart.x;
        double deltaY = clickLocation.y - this.viewPortStart.y;
        int wiggleX = this.viewPort.width;
        int wiggleY = this.viewPort.height;
        double deltaXPct = wiggleX == 0 ? 0.0 : deltaX / ((double)wiggleX / 0.25);
        double deltaYPct = wiggleY == 0 ? 0.0 : deltaY / ((double)wiggleY / 0.25);
        double deltaOffSetX = deltaXPct * (double)this.maximum.x;
        double deltaOffSetY = deltaYPct * (double)this.maximum.y;
        this.offset = new DPoint(this.viewDragBaseOffset.x - deltaOffSetX, this.viewDragBaseOffset.y - deltaOffSetY);
        this.validateOffset();
        this.redraw();
    }

    public void validateOffset() {
        double maxY;
        double maxX;
        double minY;
        double zoomFactor = PropsUi.getNativeZoomFactor() * Math.max(0.1, (double)this.magnification);
        double graphWidth = this.maximum.x;
        double graphHeight = this.maximum.y;
        Point area = this.getArea();
        double viewWidth = (double)area.x / zoomFactor;
        double viewHeight = (double)area.y / zoomFactor;
        double overshootPct = 0.75;
        double overshootWidth = viewWidth * overshootPct;
        double overshootHeight = viewHeight * overshootPct;
        double minX = -graphWidth - overshootWidth;
        if (this.offset.x < minX) {
            this.offset.x = minX;
        }
        if (this.offset.y < (minY = -graphHeight - overshootHeight)) {
            this.offset.y = minY;
        }
        if (this.offset.x > (maxX = overshootWidth)) {
            this.offset.x = maxX;
        }
        if (this.offset.y > (maxY = overshootHeight)) {
            this.offset.y = maxY;
        }
    }

    protected Point getArea() {
        Rectangle rect = this.canvas.getClientArea();
        return new Point(rect.width, rect.height);
    }

    protected void dragView(Point lastClick, Point moved) {
        double zoomFactor = PropsUi.getNativeZoomFactor() * Math.max(0.1, (double)this.magnification);
        double deltaX = (double)(lastClick.x - moved.x) / zoomFactor;
        double deltaY = (double)(lastClick.y - moved.y) / zoomFactor;
        this.offset.x = this.viewDragBaseOffset.x - deltaX;
        this.offset.y = this.viewDragBaseOffset.y - deltaY;
        this.validateOffset();
        this.redraw();
    }

    protected void mouseScrolled(MouseEvent mouseEvent) {
        if (mouseEvent.count > 0) {
            this.zoomIn(mouseEvent);
        } else {
            this.zoomOut(mouseEvent);
        }
    }
}

