/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.state;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.messages.PrepareMessage;
import org.apache.cassandra.repair.state.AbstractCompletable;
import org.apache.cassandra.repair.state.ValidationState;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.streaming.PreviewKind;
import org.apache.cassandra.utils.TimeUUID;

public class ParticipateState
extends AbstractCompletable<TimeUUID> {
    public final InetAddressAndPort initiator;
    public final List<TableId> tableIds;
    public final Collection<Range<Token>> ranges;
    public final boolean incremental;
    public final long repairedAt;
    public final boolean global;
    public final PreviewKind previewKind;
    private final ConcurrentMap<UUID, ValidationState> validations = new ConcurrentHashMap<UUID, ValidationState>();
    public final Phase phase = new Phase();

    public ParticipateState(InetAddressAndPort initiator, PrepareMessage msg) {
        super(msg.parentRepairSession);
        this.initiator = initiator;
        this.tableIds = msg.tableIds;
        this.ranges = msg.ranges;
        this.incremental = msg.isIncremental;
        this.repairedAt = msg.repairedAt;
        this.global = msg.isGlobal;
        this.previewKind = msg.previewKind;
    }

    public boolean register(ValidationState state) {
        ValidationState current = this.validations.putIfAbsent((UUID)state.id, state);
        return current == null;
    }

    public Collection<ValidationState> validations() {
        return this.validations.values();
    }

    public Collection<UUID> validationIds() {
        return this.validations.keySet();
    }

    public class Phase
    extends AbstractCompletable.BasePhase {
    }
}

