/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkExecutorInfo;
import org.apache.spark.SparkExecutorInfoImpl;
import org.apache.spark.SparkJobInfo;
import org.apache.spark.SparkJobInfoImpl;
import org.apache.spark.SparkStageInfo;
import org.apache.spark.SparkStageInfoImpl;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.MemoryMetrics;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i3AAC\u0006\u0001%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0011\u0019)\u0003\u0001\"\u0001\fM!)!\u0006\u0001C\u0001W!)q\b\u0001C\u0001\u0001\")\u0011\t\u0001C\u0001\u0001\")!\t\u0001C\u0001\u0007\")A\n\u0001C\u0001\u001b\")A\u000b\u0001C\u0001+\n\u00112\u000b]1sWN#\u0018\r^;t)J\f7m[3s\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0017AA:d!\tYB$D\u0001\f\u0013\ti2B\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\u0003ti>\u0014X\r\u0005\u0002!G5\t\u0011E\u0003\u0002#\u0017\u000511\u000f^1ukNL!\u0001J\u0011\u0003\u001d\u0005\u0003\bo\u0015;biV\u001c8\u000b^8sK\u00061A(\u001b8jiz\"2a\n\u0015*!\tY\u0002\u0001C\u0003\u001a\u0007\u0001\u0007!\u0004C\u0003\u001f\u0007\u0001\u0007q$A\thKRTuNY%eg\u001a{'o\u0012:pkB$\"\u0001\f\u001a\u0011\u0007Qis&\u0003\u0002/+\t)\u0011I\u001d:bsB\u0011A\u0003M\u0005\u0003cU\u00111!\u00138u\u0011\u0015\u0019D\u00011\u00015\u0003!QwNY$s_V\u0004\bCA\u001b=\u001d\t1$\b\u0005\u00028+5\t\u0001H\u0003\u0002:#\u00051AH]8pizJ!aO\u000b\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003wU\t\u0011cZ3u\u0003\u000e$\u0018N^3Ti\u0006<W-\u00133t)\u0005a\u0013aD4fi\u0006\u001bG/\u001b<f\u0015>\u0014\u0017\nZ:\u0002\u0015\u001d,GOS8c\u0013:4w\u000e\u0006\u0002E\u0015B\u0019A#R$\n\u0005\u0019+\"AB(qi&|g\u000e\u0005\u0002\u001c\u0011&\u0011\u0011j\u0003\u0002\r'B\f'o\u001b&pE&sgm\u001c\u0005\u0006\u0017\u001e\u0001\raL\u0001\u0006U>\u0014\u0017\nZ\u0001\rO\u0016$8\u000b^1hK&sgm\u001c\u000b\u0003\u001dJ\u00032\u0001F#P!\tY\u0002+\u0003\u0002R\u0017\tq1\u000b]1sWN#\u0018mZ3J]\u001a|\u0007\"B*\t\u0001\u0004y\u0013aB:uC\u001e,\u0017\nZ\u0001\u0011O\u0016$X\t_3dkR|'/\u00138g_N,\u0012A\u0016\t\u0004)5:\u0006CA\u000eY\u0013\tI6BA\tTa\u0006\u00148.\u0012=fGV$xN]%oM>\u0004")
public class SparkStatusTracker {
    private final AppStatusStore store;

    public int[] getJobIdsForGroup(String jobGroup) {
        Option expected = Option$.MODULE$.apply((Object)jobGroup);
        return (int[])((TraversableOnce)((TraversableLike)this.store.jobsList(null).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkStatusTracker.$anonfun$getJobIdsForGroup$1(expected, x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.jobId()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public int[] getActiveStageIds() {
        return (int[])((TraversableOnce)this.store.stageList(Arrays.asList((Object[])new StageStatus[]{StageStatus.ACTIVE}), this.store.stageList$default$2(), this.store.stageList$default$3(), this.store.stageList$default$4(), this.store.stageList$default$5()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.stageId()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public int[] getActiveJobIds() {
        return (int[])((TraversableOnce)this.store.jobsList(Arrays.asList((Object[])new JobExecutionStatus[]{JobExecutionStatus.RUNNING})).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.jobId()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public Option<SparkJobInfo> getJobInfo(int jobId) {
        return this.store.asOption((Function0 & Serializable & scala.Serializable)() -> $this.store.job(jobId)).map((Function1 & Serializable & scala.Serializable)job -> new SparkJobInfoImpl(jobId, (int[])job.stageIds().toArray(ClassTag$.MODULE$.Int()), job.status()));
    }

    public Option<SparkStageInfo> getStageInfo(int stageId) {
        return this.store.asOption((Function0 & Serializable & scala.Serializable)() -> $this.store.lastStageAttempt(stageId)).map((Function1 & Serializable & scala.Serializable)stage -> new SparkStageInfoImpl(stageId, stage.attemptId(), BoxesRunTime.unboxToLong((Object)stage.submissionTime().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), stage.name(), stage.numTasks(), stage.numActiveTasks(), stage.numCompleteTasks(), stage.numFailedTasks()));
    }

    public SparkExecutorInfo[] getExecutorInfos() {
        return (SparkExecutorInfo[])((TraversableOnce)this.store.executorList(true).map((Function1 & Serializable & scala.Serializable)exec -> {
            Tuple2<String, Object> tuple2 = Utils$.MODULE$.parseHostPort(exec.hostPort());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            String host2 = (String)tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            long cachedMem = BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)mem -> BoxesRunTime.boxToLong((long)SparkStatusTracker.$anonfun$getExecutorInfos$2(mem))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new SparkExecutorInfoImpl(host2, port2, cachedMem, exec.activeTasks(), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.usedOnHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.usedOffHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.totalOnHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), BoxesRunTime.unboxToLong((Object)exec.memoryMetrics().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.totalOffHeapStorageMemory())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SparkExecutorInfo.class));
    }

    public static final /* synthetic */ boolean $anonfun$getJobIdsForGroup$1(Option expected$1, JobData x$1) {
        Option<String> option = x$1.jobGroup();
        Option option2 = expected$1;
        return !(option != null ? !option.equals((Object)option2) : option2 != null);
    }

    public static final /* synthetic */ long $anonfun$getExecutorInfos$2(MemoryMetrics mem) {
        return mem.usedOnHeapStorageMemory() + mem.usedOffHeapStorageMemory();
    }

    public SparkStatusTracker(SparkContext sc, AppStatusStore store) {
        this.store = store;
    }
}

