/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.orabulkloader;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transforms.orabulkloader.OraBulkLoaderMeta;

public class OraBulkDataOutput {
    private OraBulkLoaderMeta meta;
    private Writer output = null;
    private StringBuilder outbuf = null;
    private boolean first = true;
    private int[] fieldNumbers = null;
    private String enclosure = null;
    private SimpleDateFormat sdfDate = null;
    private SimpleDateFormat sdfDateTime = null;
    private String recTerm;

    public OraBulkDataOutput(OraBulkLoaderMeta meta, String recTerm) {
        this.meta = meta;
        this.recTerm = recTerm;
    }

    public void open(IVariables variables, Process sqlldrProcess) throws HopException {
        String loadMethod = this.meta.getLoadMethod();
        try {
            OutputStream os;
            if ("AUTO_CONCURRENT".equals(loadMethod)) {
                os = sqlldrProcess.getOutputStream();
            } else {
                String dataFilePath = this.getFilename(this.getFileObject(this.meta.getDataFile(), variables));
                File dataFile = new File(dataFilePath);
                dataFile.getParentFile().mkdirs();
                os = new FileOutputStream(dataFile, false);
            }
            String encoding = this.meta.getEncoding();
            this.output = Utils.isEmpty((CharSequence)encoding) ? new BufferedWriter(new OutputStreamWriter(os)) : new BufferedWriter(new OutputStreamWriter(os, encoding));
        }
        catch (IOException e) {
            throw new HopException("IO exception occured: " + e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    Writer getOutput() {
        return this.output;
    }

    private String createEscapedString(String orig, String enclosure) {
        StringBuilder buf = new StringBuilder(orig);
        Const.repl((StringBuilder)buf, (String)enclosure, (String)(enclosure + enclosure));
        return buf.toString();
    }

    public void writeLine(IRowMeta rowMeta, Object[] row) throws HopException {
        if (this.first) {
            this.first = false;
            this.enclosure = this.meta.getEnclosure();
            this.fieldNumbers = new int[this.meta.getMappings().size()];
            for (int i = 0; i < this.fieldNumbers.length; ++i) {
                this.fieldNumbers[i] = rowMeta.indexOfValue(this.meta.getMappings().get(i).getFieldStream());
                if (this.fieldNumbers[i] >= 0) continue;
                throw new HopException("Could not find field " + this.meta.getMappings().get(i).getFieldStream() + " in stream");
            }
            this.sdfDate = new SimpleDateFormat("yyyy-MM-dd");
            this.sdfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            this.outbuf = new StringBuilder();
        }
        this.outbuf.setLength(0);
        block13: for (int i = 0; i < this.fieldNumbers.length; ++i) {
            if (i != 0) {
                this.outbuf.append(',');
            }
            int number = this.fieldNumbers[i];
            IValueMeta valueMeta = rowMeta.getValueMeta(number);
            if (row[number] == null) {
                this.outbuf.append(this.enclosure);
                this.outbuf.append(this.enclosure);
                continue;
            }
            switch (valueMeta.getType()) {
                case 2: {
                    String s = rowMeta.getString(row, number);
                    this.outbuf.append(this.enclosure);
                    if (null != s) {
                        if (s.contains(this.enclosure)) {
                            s = this.createEscapedString(s, this.enclosure);
                        }
                        this.outbuf.append(s);
                    }
                    this.outbuf.append(this.enclosure);
                    continue block13;
                }
                case 5: {
                    Long l = rowMeta.getInteger(row, number);
                    this.outbuf.append(this.enclosure);
                    if (null != l) {
                        this.outbuf.append(l);
                    }
                    this.outbuf.append(this.enclosure);
                    continue block13;
                }
                case 1: {
                    Double d = rowMeta.getNumber(row, number);
                    this.outbuf.append(this.enclosure);
                    if (null != d) {
                        this.outbuf.append(d);
                    }
                    this.outbuf.append(this.enclosure);
                    continue block13;
                }
                case 6: {
                    BigDecimal bd = rowMeta.getBigNumber(row, number);
                    this.outbuf.append(this.enclosure);
                    if (null != bd) {
                        this.outbuf.append(bd);
                    }
                    this.outbuf.append(this.enclosure);
                    continue block13;
                }
                case 3: {
                    Date dt = rowMeta.getDate(row, number);
                    this.outbuf.append(this.enclosure);
                    if (null != dt) {
                        String mask = this.meta.getMappings().get(i).getDateMask();
                        if ("DATETIME".equals(mask)) {
                            this.outbuf.append(this.sdfDateTime.format(dt));
                        } else {
                            this.outbuf.append(this.sdfDate.format(dt));
                        }
                    }
                    this.outbuf.append(this.enclosure);
                    continue block13;
                }
                case 4: {
                    Boolean b = rowMeta.getBoolean(row, number);
                    this.outbuf.append(this.enclosure);
                    if (null != b) {
                        if (b.booleanValue()) {
                            this.outbuf.append('Y');
                        } else {
                            this.outbuf.append('N');
                        }
                    }
                    this.outbuf.append(this.enclosure);
                    continue block13;
                }
                case 8: {
                    byte[] byt = rowMeta.getBinary(row, number);
                    this.outbuf.append("<startlob>");
                    this.outbuf.append(byt);
                    this.outbuf.append("<endlob>");
                    continue block13;
                }
                case 9: {
                    Timestamp timestamp = (Timestamp)rowMeta.getDate(row, number);
                    this.outbuf.append(this.enclosure);
                    if (null != timestamp) {
                        this.outbuf.append(timestamp.toString());
                    }
                    this.outbuf.append(this.enclosure);
                    continue block13;
                }
                default: {
                    throw new HopException("Unsupported type");
                }
            }
        }
        this.outbuf.append(this.recTerm);
        try {
            this.output.append(this.outbuf);
        }
        catch (IOException e) {
            throw new HopException("IO exception occured: " + e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    String getFilename(FileObject fileObject) {
        return HopVfs.getFilename((FileObject)fileObject);
    }

    @VisibleForTesting
    FileObject getFileObject(String fileName, IVariables variables) throws HopFileException {
        return HopVfs.getFileObject((String)variables.resolve(fileName));
    }
}

