/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avroencode;

import java.util.ArrayList;
import org.apache.avro.generic.GenericData;
import org.apache.hop.avro.transforms.avroencode.AvroEncodeData;
import org.apache.hop.avro.transforms.avroencode.AvroEncodeMeta;
import org.apache.hop.avro.transforms.avroencode.SourceField;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

public class AvroEncode
extends BaseTransform<AvroEncodeMeta, AvroEncodeData> {
    public AvroEncode(TransformMeta transformMeta, AvroEncodeMeta meta, AvroEncodeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((AvroEncodeData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((AvroEncodeMeta)this.meta).getFields(((AvroEncodeData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((AvroEncodeData)this.data).sourceFieldIndexes = new ArrayList<Integer>();
            for (SourceField field : ((AvroEncodeMeta)this.meta).getSourceFields()) {
                int index = this.getInputRowMeta().indexOfValue(field.getSourceFieldName());
                if (index < 0) {
                    throw new HopException("Unable to find input field " + field.getSourceFieldName());
                }
                IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(index);
                ((AvroEncodeData)this.data).sourceFieldIndexes.add(index);
            }
            String schemaName = this.resolve(((AvroEncodeMeta)this.meta).getSchemaName());
            String namespace = this.resolve(((AvroEncodeMeta)this.meta).getNamespace());
            String documentation = this.resolve(((AvroEncodeMeta)this.meta).getDocumentation());
            ((AvroEncodeData)this.data).avroSchema = AvroEncodeMeta.createAvroSchema(schemaName, namespace, documentation, this.getInputRowMeta(), ((AvroEncodeMeta)this.meta).getSourceFields());
            if (this.log.isDetailed()) {
                this.log.logDetailed("Schema: " + ((AvroEncodeData)this.data).avroSchema.toString(true));
            }
        }
        GenericData.Record genericRecord = new GenericData.Record(((AvroEncodeData)this.data).avroSchema);
        for (int i = 0; i < ((AvroEncodeMeta)this.meta).getSourceFields().size(); ++i) {
            SourceField field = ((AvroEncodeMeta)this.meta).getSourceFields().get(i);
            int index = ((AvroEncodeData)this.data).sourceFieldIndexes.get(i);
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(index);
            Object value = row[index];
            Object nativeValue = valueMeta.getNativeDataType(value);
            genericRecord.put(field.calculateTargetFieldName(), nativeValue);
        }
        Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((AvroEncodeData)this.data).outputRowMeta.size());
        outputRow[this.getInputRowMeta().size()] = genericRecord;
        this.putRow(((AvroEncodeData)this.data).outputRowMeta, outputRow);
        return true;
    }
}

