/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class PCollectionRowTuple
implements PInput,
POutput {
    final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
    final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> pcollectionMap;

    public static @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple empty(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return new PCollectionRowTuple(pipeline);
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple of(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc) {
        return PCollectionRowTuple.empty(pc.getPipeline()).and(tag, pc);
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc2) {
        return PCollectionRowTuple.of(tag1, pc1).and(tag2, pc2);
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc2, @UnknownKeyFor @NonNull @Initialized String tag3, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc3) {
        return PCollectionRowTuple.of(tag1, pc1, tag2, pc2).and(tag3, pc3);
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc2, @UnknownKeyFor @NonNull @Initialized String tag3, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc3, @UnknownKeyFor @NonNull @Initialized String tag4, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc4) {
        return PCollectionRowTuple.of(tag1, pc1, tag2, pc2, tag3, pc3).and(tag4, pc4);
    }

    public static @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple of(@UnknownKeyFor @NonNull @Initialized String tag1, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc1, @UnknownKeyFor @NonNull @Initialized String tag2, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc2, @UnknownKeyFor @NonNull @Initialized String tag3, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc3, @UnknownKeyFor @NonNull @Initialized String tag4, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc4, @UnknownKeyFor @NonNull @Initialized String tag5, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc5) {
        return PCollectionRowTuple.of(tag1, pc1, tag2, pc2, tag3, pc3, tag4, pc4).and(tag5, pc5);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple and(@UnknownKeyFor @NonNull @Initialized String tag, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        return new PCollectionRowTuple(this.pipeline, new ImmutableMap.Builder<String, PCollection<Row>>().putAll(this.pcollectionMap).put(tag, pc).build());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean has(@UnknownKeyFor @NonNull @Initialized String tag) {
        return this.pcollectionMap.containsKey(tag);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> get(@UnknownKeyFor @NonNull @Initialized String tag) {
        PCollection<Row> pcollection = this.pcollectionMap.get(tag);
        if (pcollection == null) {
            throw new IllegalArgumentException("Tag not found in this PCollectionRowTuple tuple");
        }
        return pcollection;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> getAll() {
        return this.pcollectionMap;
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized ? super @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionRowTuple(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        this(pipeline, new LinkedHashMap<String, PCollection<Row>>());
    }

    PCollectionRowTuple(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> pcollectionMap) {
        this.pipeline = pipeline;
        this.pcollectionMap = Collections.unmodifiableMap(pcollectionMap);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.pcollectionMap.forEach((tag, value) -> builder.put(new TupleTag((String)tag), value));
        return builder.build();
    }

    @Override
    public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        for (Map.Entry<String, PCollection<Row>> entry : this.pcollectionMap.entrySet()) {
            String tag = entry.getKey();
            PCollection<Row> pc = entry.getValue();
            if (!pc.getName().equals(PValueBase.defaultName(transformName))) continue;
            pc.setName(String.format("%s.%s", transformName, tag));
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object other) {
        if (!(other instanceof PCollectionRowTuple)) {
            return false;
        }
        PCollectionRowTuple that = (PCollectionRowTuple)other;
        return this.pipeline.equals(that.pipeline) && this.pcollectionMap.equals(that.pcollectionMap);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.pipeline, this.pcollectionMap);
    }
}

