/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.SplittableParDo;
import org.apache.beam.sdk.util.construction.WriteFilesTranslation;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PTransformMatchers {
    private PTransformMatchers() {
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher urnEqualTo(@UnknownKeyFor @NonNull @Initialized String urn) {
        return new EqualUrnPTransformMatcher(urn);
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher classEqualTo(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform> clazz) {
        return new EqualClassPTransformMatcher(clazz);
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher requiresStableInputParDoSingle() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof ParDo.SingleOutput) {
                    DoFn fn = ((ParDo.SingleOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().requiresStableInput();
                }
                return false;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matchesDuringValidation(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("RequiresStableInputParDoSingleMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher requiresStableInputParDoMulti() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof ParDo.MultiOutput) {
                    DoFn fn = ((ParDo.MultiOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().requiresStableInput();
                }
                return false;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matchesDuringValidation(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("RequiresStableInputParDoMultiMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher splittableParDoSingle() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof ParDo.SingleOutput) {
                    DoFn fn = ((ParDo.SingleOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().isSplittable();
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("SplittableParDoSingleMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher stateOrTimerParDoSingle() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof ParDo.SingleOutput) {
                    DoFn fn = ((ParDo.SingleOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.usesState() || signature.usesTimers();
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("StateOrTimerParDoSingleMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher splittableParDoMulti() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof ParDo.MultiOutput) {
                    DoFn fn = ((ParDo.MultiOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().isSplittable();
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("SplittableParDoMultiMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher splittableParDo() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                if ("beam:transform:pardo:v1".equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()))) {
                    try {
                        return ParDoTranslation.isSplittable(application);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Transform with URN %s could not be translated", "beam:transform:pardo:v1"), e);
                    }
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("SplittableParDoMultiMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher splittableProcessKeyedBounded() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof SplittableParDo.ProcessKeyedElements) {
                    DoFn fn = ((SplittableParDo.ProcessKeyedElements)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().isSplittable() && signature.isBoundedPerElement() == PCollection.IsBounded.BOUNDED;
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("SplittableProcessKeyedBoundedMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher splittableProcessKeyedUnbounded() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof SplittableParDo.ProcessKeyedElements) {
                    DoFn fn = ((SplittableParDo.ProcessKeyedElements)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.processElement().isSplittable() && signature.isBoundedPerElement() == PCollection.IsBounded.UNBOUNDED;
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("SplittableProcessKeyedUnboundedMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher stateOrTimerParDo() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                if ("beam:transform:pardo:v1".equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()))) {
                    try {
                        return ParDoTranslation.usesStateOrTimers(application);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Transform with URN %s could not be translated", "beam:transform:pardo:v1"), e);
                    }
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("StateOrTimerParDoMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher stateOrTimerParDoMulti() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                Object transform = application.getTransform();
                if (transform instanceof ParDo.MultiOutput) {
                    DoFn fn = ((ParDo.MultiOutput)transform).getFn();
                    DoFnSignature signature = DoFnSignatures.signatureForDoFn(fn);
                    return signature.usesState() || signature.usesTimers();
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("StateOrTimerParDoMultiMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher parDoWithFnType(final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DoFn> fnType) {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                DoFn fn;
                if (application.getTransform() instanceof ParDo.SingleOutput) {
                    fn = ((ParDo.SingleOutput)application.getTransform()).getFn();
                } else if (application.getTransform() instanceof ParDo.MultiOutput) {
                    fn = ((ParDo.MultiOutput)application.getTransform()).getFn();
                } else {
                    return false;
                }
                return fnType.equals(fn.getClass());
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("ParDoWithFnTypeMatcher").add("fnType", fnType).toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher createViewWithViewFn(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized ViewFn> viewFnType) {
        return application -> {
            if (!(application.getTransform() instanceof View.CreatePCollectionView)) {
                return false;
            }
            View.CreatePCollectionView createView = (View.CreatePCollectionView)application.getTransform();
            ViewFn viewFn = createView.getView().getViewFn();
            return viewFn.getClass().equals(viewFnType);
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher emptyFlatten() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                return application.getTransform() instanceof Flatten.PCollections && application.getInputs().isEmpty();
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("EmptyFlattenMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher flattenWithDuplicateInputs() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                if (application.getTransform() instanceof Flatten.PCollections) {
                    HashSet<PValue> observed = new HashSet<PValue>();
                    for (PValue pValue : application.getInputs().values()) {
                        boolean firstInstance = observed.add(pValue);
                        if (firstInstance) continue;
                        return true;
                    }
                }
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("FlattenWithDuplicateInputsMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher groupIntoBatches() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                return application.getTransform().getClass().equals(GroupIntoBatches.class);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matchesDuringValidation(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("groupIntoBatches").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher groupWithShardableStates() {
        return new PTransformMatcher(){

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                return application.getTransform().getClass().equals(GroupIntoBatches.WithShardedKey.class);
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized boolean matchesDuringValidation(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
                return false;
            }

            @SideEffectFree
            public @UnknownKeyFor @NonNull @Initialized String toString() {
                return MoreObjects.toStringHelper("groupWithShardableStatesMatcher").toString();
            }
        };
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransformMatcher writeWithRunnerDeterminedSharding() {
        return application -> {
            if ("beam:transform:write_files:v1".equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()))) {
                try {
                    return WriteFilesTranslation.isRunnerDeterminedSharding(application);
                }
                catch (IOException exc) {
                    throw new RuntimeException(String.format("Transform with URN %s failed to parse: %s", "beam:transform:write_files:v1", application.getTransform()), exc);
                }
            }
            return false;
        };
    }

    private static class EqualClassPTransformMatcher
    implements PTransformMatcher {
        private final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform> clazz;

        private EqualClassPTransformMatcher(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform> clazz) {
            this.clazz = clazz;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
            return application.getTransform().getClass().equals(this.clazz);
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(EqualClassPTransformMatcher.class).add("class", this.clazz).toString();
        }
    }

    private static class EqualUrnPTransformMatcher
    implements PTransformMatcher {
        private final @UnknownKeyFor @NonNull @Initialized String urn;

        private EqualUrnPTransformMatcher(@UnknownKeyFor @NonNull @Initialized String urn) {
            this.urn = urn;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean matches(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> application) {
            return this.urn.equals(PTransformTranslation.urnForTransformOrNull(application.getTransform()));
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this).add("urn", this.urn).toString();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualUrnPTransformMatcher that = (EqualUrnPTransformMatcher)o;
            return this.urn.equals(that.urn);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.urn);
        }
    }
}

