/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Sets {
    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> intersectDistinct(@UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.intersectDistinct());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> intersectDistinct() {
        SerializableBiFunction intersectFn = (numberOfElementsinLeft, numberOfElementsinRight) -> numberOfElementsinLeft > 0L && numberOfElementsinRight > 0L ? 1L : 0L;
        return new SetImplCollections(intersectFn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> intersectAll(@UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.intersectAll());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> intersectAll() {
        return new SetImplCollections(Math::min);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> exceptDistinct(@UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.exceptDistinct());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> exceptDistinct() {
        SerializableBiFunction exceptFn = (numberOfElementsinLeft, numberOfElementsinRight) -> numberOfElementsinLeft > 0L && numberOfElementsinRight == 0L ? 1L : 0L;
        return new SetImplCollections(exceptFn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> exceptAll(@UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.exceptAll());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> exceptAll() {
        SerializableBiFunction exceptFn = (numberOfElementsinLeft, numberOfElementsinRight) -> Math.max(numberOfElementsinLeft - numberOfElementsinRight, 0L);
        return new SetImplCollections(exceptFn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> unionDistinct(@UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.unionDistinct());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> unionDistinct() {
        SerializableBiFunction unionFn = (numberOfElementsinLeft, numberOfElementsinRight) -> 1L;
        return new SetImplCollections(unionFn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> unionAll(@UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection) {
        Preconditions.checkNotNull(rightCollection, "rightCollection argument is null");
        return new SetImpl(rightCollection, Sets.unionAll());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Flatten.PCollections<T> unionAll() {
        return Flatten.pCollections();
    }

    private static class SetImplCollections<@UnknownKeyFor T>
    extends PTransform<PCollectionList<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> fn;

        private SetImplCollections(@UnknownKeyFor @NonNull @Initialized SerializableBiFunction<@UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long, @UnknownKeyFor @NonNull @Initialized Long> fn) {
            this.fn = fn;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<T> input) {
            List<PCollection<T>> all = input.getAll();
            MapElements elementToVoid = MapElements.via(new SimpleFunction<T, KV<T, Void>>(){

                @Override
                public @UnknownKeyFor @NonNull @Initialized KV<T, @UnknownKeyFor @Nullable @Initialized Void> apply(T element) {
                    return KV.of(element, null);
                }
            });
            Preconditions.checkArgument(all.size() > 1, "must have at least two input to a PCollectionList");
            PCollection<T> first = all.get(0);
            Pipeline pipeline = first.getPipeline();
            String firstName = first.getName();
            final ArrayList allTags = new ArrayList();
            KeyedPCollectionTuple keyedPCollectionTuple = KeyedPCollectionTuple.empty(pipeline);
            for (PCollection<T> col : all) {
                TupleTag tag = new TupleTag();
                PCollection kvOfElementAndVoid = (PCollection)col.apply("PrepareKVs" + col.getName(), elementToVoid);
                allTags.add(tag);
                keyedPCollectionTuple = keyedPCollectionTuple.and(tag, kvOfElementAndVoid);
            }
            PCollection coGbkResults = (PCollection)keyedPCollectionTuple.apply("CBKAll" + firstName, CoGroupByKey.create());
            PCollection results = (PCollection)coGbkResults.apply("FilterSetElement" + firstName, ParDo.of(new DoFn<KV<T, CoGbkResult>, T>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
                    KV elementGroups = (KV)c.element();
                    CoGbkResult value = (CoGbkResult)elementGroups.getValue();
                    Object element = elementGroups.getKey();
                    long numberOfOutputs = Iterables.size(value.getAll((TupleTag)allTags.get(0)));
                    List tail = allTags.subList(1, allTags.size());
                    for (TupleTag tag : tail) {
                        long nextSize = Iterables.size(value.getAll(tag));
                        numberOfOutputs = (Long)fn.apply(numberOfOutputs, nextSize);
                    }
                    for (long i = 0L; i < numberOfOutputs; ++i) {
                        c.output(element);
                    }
                }
            }));
            return results.setCoder(first.getCoder());
        }
    }

    private static class SetImpl<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final transient @UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection;
        private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> listTransformFn;

        private SetImpl(@UnknownKeyFor @NonNull @Initialized PCollection<T> rightCollection, @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> listTransformFn) {
            this.rightCollection = rightCollection;
            this.listTransformFn = listTransformFn;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> leftCollection) {
            return PCollectionList.of(leftCollection).and(this.rightCollection).apply(this.listTransformFn);
        }
    }
}

