/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.metrics.AutoValue_MetricQueryResults;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

@AutoValue
public abstract class MetricQueryResults {
    public abstract @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> getCounters();

    public abstract @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> getDistributions();

    public abstract @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> getGauges();

    static <T> void printMetrics(@UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<T>> metrics, @UnknownKeyFor @NonNull @Initialized StringBuilder sb) {
        ImmutableList<MetricResult<T>> metricsList = ImmutableList.copyOf(metrics);
        if (!metricsList.isEmpty()) {
            sb.append(type).append("(");
            boolean first = true;
            for (MetricResult metricResult : metricsList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(metricResult.getKey()).append(": ").append(metricResult.getAttempted());
                if (!metricResult.hasCommitted()) continue;
                Object committed = metricResult.getCommitted();
                sb.append(", ").append(committed);
            }
            sb.append(")");
        }
    }

    @SideEffectFree
    public final @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricQueryResults(");
        MetricQueryResults.printMetrics("Counters", this.getCounters(), sb);
        MetricQueryResults.printMetrics("Distributions", this.getDistributions(), sb);
        MetricQueryResults.printMetrics("Gauges", this.getGauges(), sb);
        sb.append(")");
        return sb.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized MetricQueryResults create(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized Long>> counters, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized DistributionResult>> distributions, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MetricResult<@UnknownKeyFor @NonNull @Initialized GaugeResult>> gauges) {
        return new AutoValue_MetricQueryResults(counters, distributions, gauges);
    }
}

