/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class OffsetRange
implements Serializable,
HasDefaultTracker<OffsetRange, OffsetRangeTracker> {
    private final @UnknownKeyFor @NonNull @Initialized long from;
    private final @UnknownKeyFor @NonNull @Initialized long to;

    public OffsetRange(@UnknownKeyFor @NonNull @Initialized long from, @UnknownKeyFor @NonNull @Initialized long to) {
        Preconditions.checkArgument(from <= to, "Malformed range [%s, %s)", from, to);
        this.from = from;
        this.to = to;
    }

    public @UnknownKeyFor @NonNull @Initialized long getFrom() {
        return this.from;
    }

    public @UnknownKeyFor @NonNull @Initialized long getTo() {
        return this.to;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized OffsetRangeTracker newTracker() {
        return new OffsetRangeTracker(this);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "[" + this.from + ", " + this.to + ')';
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetRange that = (OffsetRange)o;
        if (this.from != that.from) {
            return false;
        }
        return this.to == that.to;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = (int)(this.from ^ this.from >>> 32);
        result = 31 * result + (int)(this.to ^ this.to >>> 32);
        return result;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OffsetRange> split(@UnknownKeyFor @NonNull @Initialized long desiredNumOffsetsPerSplit, @UnknownKeyFor @NonNull @Initialized long minNumOffsetPerSplit) {
        ArrayList<OffsetRange> res = new ArrayList<OffsetRange>();
        long start = this.getFrom();
        long maxEnd = this.getTo();
        while (start < maxEnd) {
            long end = start + desiredNumOffsetsPerSplit;
            long remaining = maxEnd - (end = Math.min(end, maxEnd));
            if (remaining < desiredNumOffsetsPerSplit / 4L || remaining < minNumOffsetPerSplit) {
                end = maxEnd;
            }
            res.add(new OffsetRange(start, end));
            start = end;
        }
        return res;
    }

    public static class Coder
    extends AtomicCoder<OffsetRange> {
        private static final @UnknownKeyFor @NonNull @Initialized Coder INSTANCE = new Coder();
        private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized OffsetRange> TYPE_DESCRIPTOR = new TypeDescriptor<OffsetRange>(){};

        public static @UnknownKeyFor @NonNull @Initialized Coder of() {
            return INSTANCE;
        }

        @Override
        public void encode(@UnknownKeyFor @NonNull @Initialized OffsetRange value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            VarInt.encode(value.from, outStream);
            VarInt.encode(value.to, outStream);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized OffsetRange decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
            return new OffsetRange(VarInt.decodeLong(inStream), VarInt.decodeLong(inStream));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized OffsetRange value) {
            return true;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized long getEncodedElementByteSize(@UnknownKeyFor @NonNull @Initialized OffsetRange value) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return (long)VarInt.getLength(value.from) + (long)VarInt.getLength(value.to);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
            return true;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized OffsetRange> getEncodedTypeDescriptor() {
            return TYPE_DESCRIPTOR;
        }
    }
}

