/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_WritePartition_Result;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.WriteBundlesToFiles;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class WritePartition<@UnknownKeyFor DestinationT>
extends DoFn<Iterable<WriteBundlesToFiles.Result<DestinationT>>, KV<ShardedKey<DestinationT>, Result>> {
    private final @UnknownKeyFor @NonNull @Initialized boolean singletonTable;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations;
    private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefix;
    private final @UnknownKeyFor @NonNull @Initialized int maxNumFiles;
    private final @UnknownKeyFor @NonNull @Initialized long maxSizeBytes;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RowWriterFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> rowWriterFactory;
    private @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized Result>> multiPartitionsTag;
    private @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized Result>> singlePartitionTag;

    WritePartition(@UnknownKeyFor @NonNull @Initialized boolean singletonTable, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tempFilePrefix, @UnknownKeyFor @NonNull @Initialized int maxNumFiles, @UnknownKeyFor @NonNull @Initialized long maxSizeBytes, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized Result>> multiPartitionsTag, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized Result>> singlePartitionTag, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized RowWriterFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> rowWriterFactory) {
        this.singletonTable = singletonTable;
        this.dynamicDestinations = dynamicDestinations;
        this.tempFilePrefix = tempFilePrefix;
        this.maxNumFiles = maxNumFiles;
        this.maxSizeBytes = maxSizeBytes;
        this.multiPartitionsTag = multiPartitionsTag;
        this.singlePartitionTag = singlePartitionTag;
        this.rowWriterFactory = rowWriterFactory;
    }

    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        DestinationData destinationData;
        Object destination;
        ArrayList results = Lists.newArrayList((Iterable)((Iterable)c.element()));
        if (results.isEmpty() && this.singletonTable) {
            String tempFilePrefix = (String)c.sideInput(this.tempFilePrefix);
            DestinationT destination2 = this.dynamicDestinations.getDestination(null);
            BigQueryRowWriter<?> bigQueryRowWriter = this.rowWriterFactory.createRowWriter(tempFilePrefix, destination2);
            bigQueryRowWriter.close();
            BigQueryRowWriter.Result writerResult = bigQueryRowWriter.getResult();
            results.add(new WriteBundlesToFiles.Result<DestinationT>(writerResult.resourceId.toString(), writerResult.byteSize, destination2));
        }
        HashMap currentResults = Maps.newHashMap();
        for (WriteBundlesToFiles.Result result : results) {
            destination = result.destination;
            destinationData = currentResults.computeIfAbsent(destination, k -> DestinationData.create(this.maxNumFiles, this.maxSizeBytes));
            PartitionData latestPartition = destinationData.getLatestPartition();
            if (!latestPartition.canAccept(1, result.fileByteSize)) {
                latestPartition = PartitionData.withMaximums(this.maxNumFiles, this.maxSizeBytes);
                destinationData.addPartition(latestPartition);
            }
            latestPartition.addFilename(result.filename);
            latestPartition.addFiles(1);
            latestPartition.addBytes(result.fileByteSize);
        }
        for (Map.Entry entry : currentResults.entrySet()) {
            destination = entry.getKey();
            destinationData = (DestinationData)entry.getValue();
            TupleTag<KV<ShardedKey<DestinationT>, Result>> outputTag = destinationData.getPartitions().size() == 1 ? this.singlePartitionTag : this.multiPartitionsTag;
            for (int i = 0; i < destinationData.getPartitions().size(); ++i) {
                PartitionData partitionData = destinationData.getPartitions().get(i);
                c.output(outputTag, (Object)KV.of((Object)ShardedKey.of(destination, (int)(i + 1)), (Object)new AutoValue_WritePartition_Result(partitionData.getFilenames(), c.pane().isFirst())));
            }
        }
    }

    private static class DestinationData {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionData> partitions = Lists.newArrayList();

        private DestinationData() {
        }

        private static @UnknownKeyFor @NonNull @Initialized DestinationData create(@UnknownKeyFor @NonNull @Initialized int maxNumFiles, @UnknownKeyFor @NonNull @Initialized long maxSizeBytes) {
            DestinationData destinationData = new DestinationData();
            destinationData.partitions.add(new PartitionData(maxNumFiles, maxSizeBytes));
            return destinationData;
        }

        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionData> getPartitions() {
            return this.partitions;
        }

        @UnknownKeyFor @NonNull @Initialized PartitionData getLatestPartition() {
            return this.partitions.get(this.partitions.size() - 1);
        }

        void addPartition(@UnknownKeyFor @NonNull @Initialized PartitionData partition) {
            this.partitions.add(partition);
        }
    }

    private static class PartitionData {
        private @UnknownKeyFor @NonNull @Initialized int numFiles = 0;
        private @UnknownKeyFor @NonNull @Initialized long byteSize = 0L;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> filenames = Lists.newArrayList();
        private final @UnknownKeyFor @NonNull @Initialized int maxNumFiles;
        private final @UnknownKeyFor @NonNull @Initialized long maxSizeBytes;

        private PartitionData(@UnknownKeyFor @NonNull @Initialized int maxNumFiles, @UnknownKeyFor @NonNull @Initialized long maxSizeBytes) {
            this.maxNumFiles = maxNumFiles;
            this.maxSizeBytes = maxSizeBytes;
        }

        static @UnknownKeyFor @NonNull @Initialized PartitionData withMaximums(@UnknownKeyFor @NonNull @Initialized int maxNumFiles, @UnknownKeyFor @NonNull @Initialized long maxSizeBytes) {
            return new PartitionData(maxNumFiles, maxSizeBytes);
        }

        @UnknownKeyFor @NonNull @Initialized int getNumFiles() {
            return this.numFiles;
        }

        void addFiles(@UnknownKeyFor @NonNull @Initialized int numFiles) {
            this.numFiles += numFiles;
        }

        @UnknownKeyFor @NonNull @Initialized long getByteSize() {
            return this.byteSize;
        }

        void addBytes(@UnknownKeyFor @NonNull @Initialized long numBytes) {
            this.byteSize += numBytes;
        }

        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getFilenames() {
            return this.filenames;
        }

        void addFilename(@UnknownKeyFor @NonNull @Initialized String filename) {
            this.filenames.add(filename);
        }

        @UnknownKeyFor @NonNull @Initialized boolean canAccept(@UnknownKeyFor @NonNull @Initialized int numFiles, @UnknownKeyFor @NonNull @Initialized long numBytes) {
            if (this.filenames.isEmpty()) {
                return true;
            }
            return this.numFiles + numFiles <= this.maxNumFiles && this.byteSize + numBytes <= this.maxSizeBytes;
        }
    }

    static class ResultCoder
    extends AtomicCoder<Result> {
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> FILENAMES_CODER = ListCoder.of((Coder)StringUtf8Coder.of());
        private static final @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Boolean> FIRST_PANE_CODER = BooleanCoder.of();
        static final @UnknownKeyFor @NonNull @Initialized ResultCoder INSTANCE = new ResultCoder();

        ResultCoder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized Result value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            FILENAMES_CODER.encode(value.getFilenames(), outStream);
            FIRST_PANE_CODER.encode((Object)value.isFirstPane(), outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized Result decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return new AutoValue_WritePartition_Result((List)FILENAMES_CODER.decode(inStream), (Boolean)FIRST_PANE_CODER.decode(inStream));
        }
    }

    @AutoValue
    static abstract class Result {
        Result() {
        }

        public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getFilenames();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean isFirstPane();
    }
}

