/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.compress.CompressionInputStream;
import org.apache.hop.core.compress.CompressionProviderFactory;
import org.apache.hop.core.compress.ICompressionProvider;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.file.EncodingType;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.gui.ITextFileInputField;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.common.ICsvInputAwareMeta;
import org.apache.hop.pipeline.transforms.file.BaseFileField;
import org.apache.hop.pipeline.transforms.fileinput.text.DirectoryDialogButtonListenerFactory;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileCSVImportProgressDialog;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileFilter;
import org.apache.hop.pipeline.transforms.fileinput.text.TextFileInputMeta;
import org.apache.hop.staticschema.metadata.SchemaDefinition;
import org.apache.hop.staticschema.util.SchemaDefinitionUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.common.ICsvInputAwareImportProgressDialog;
import org.apache.hop.ui.pipeline.transform.common.ICsvInputAwareTransformDialog;
import org.apache.hop.ui.pipeline.transform.common.IGetFieldsCapableTransformDialog;
import org.apache.hop.ui.pipeline.transform.common.TextFileLineUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextFileInputDialog
extends BaseTransformDialog
implements ITransformDialog,
IGetFieldsCapableTransformDialog<TextFileInputMeta>,
ICsvInputAwareTransformDialog {
    private static final Class<?> PKG = TextFileInputMeta.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private CTabFolder wTabFolder;
    private TextVar wExcludeFilemask;
    private Button wAccFilenames;
    private MetaSelectionLine<SchemaDefinition> wSchemaDefinition;
    private Label wlPassThruFields;
    private Button wPassThruFields;
    private Label wlAccField;
    private Text wAccField;
    private Label wlAccTransform;
    private CCombo wAccTransform;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Label wlFilemask;
    private TextVar wFilemask;
    private Button wbShowFiles;
    private Button wFirst;
    private Button wFirstHeader;
    private CCombo wFiletype;
    private Button wbSeparator;
    private TextVar wSeparator;
    private Text wEnclosure;
    private Text wEscape;
    private Button wHeader;
    private Label wlNrHeader;
    private Text wNrHeader;
    private Button wFooter;
    private Label wlNrFooter;
    private Text wNrFooter;
    private Button wWraps;
    private Label wlNrWraps;
    private Text wNrWraps;
    private Button wLayoutPaged;
    private Label wlNrLinesPerPage;
    private Text wNrLinesPerPage;
    private Label wlNrLinesDocHeader;
    private Text wNrLinesDocHeader;
    private CCombo wCompression;
    private Button wNoempty;
    private Button wInclFilename;
    private Label wlInclFilenameField;
    private Text wInclFilenameField;
    private Button wInclRownum;
    private Label wlRownumByFileField;
    private Button wRownumByFile;
    private Label wlInclRownumField;
    private Text wInclRownumField;
    private CCombo wFormat;
    private CCombo wEncoding;
    private CCombo wLength;
    private Text wLimit;
    private Button wDateLenient;
    private CCombo wDateLocale;
    private Button wErrorIgnored;
    private Button wSkipBadFiles;
    private Label wlSkipErrorLines;
    private Button wSkipErrorLines;
    private Label wlErrorCount;
    private Text wErrorCount;
    private Label wlErrorFields;
    private Text wErrorFields;
    private Label wlErrorText;
    private Text wErrorText;
    private Label wlWarnDestDir;
    private Button wbbWarnDestDir;
    private TextVar wWarnDestDir;
    private Label wlWarnExt;
    private Text wWarnExt;
    private Label wlErrorDestDir;
    private Button wbbErrorDestDir;
    private TextVar wErrorDestDir;
    private Label wlErrorExt;
    private Text wErrorExt;
    private Label wlLineNrDestDir;
    private Button wbbLineNrDestDir;
    private TextVar wLineNrDestDir;
    private Label wlLineNrExt;
    private Text wLineNrExt;
    private TableView wFilter;
    private TableView wFields;
    private Button wAddResult;
    private final TextFileInputMeta input;
    private Button wMinWidth;
    private Vector<ITextFileInputField> fields;
    private int middle;
    private int margin;
    private ModifyListener lsMod;
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};
    private boolean gotEncodings = false;
    protected boolean firstClickOnDateLocale;
    private TextVar wShortFileFieldName;
    private TextVar wPathFieldName;
    private TextVar wIsHiddenName;
    private TextVar wLastModificationTimeName;
    private TextVar wUriName;
    private TextVar wRootUriName;
    private TextVar wExtensionFieldName;
    private TextVar wSizeFieldName;
    private Text wBadFileField;
    private Text wBadFileMessageField;

    public TextFileInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (TextFileInputMeta)((Object)in);
        this.firstClickOnDateLocale = true;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        TextFileInputDialog textFileInputDialog = this;
        this.margin = textFileInputDialog.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Preview.Button", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, this.margin, null);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.addFilesTab();
        this.addContentTab();
        this.addErrorTab();
        this.addFiltersTabs();
        this.addFieldsTabs();
        this.addAdditionalFieldsTab();
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wFirst.addListener(13, e -> this.first(false));
        this.wFirstHeader.addListener(13, e -> this.first(true));
        this.wGet.addListener(13, e -> this.get());
        this.wMinWidth.addListener(13, e -> this.setMinimalWidth());
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (TextFileInputDialog.this.wFilename.getText() == null || TextFileInputDialog.this.wFilename.getText().isEmpty()) {
                    TextFileInputDialog.this.displayErrorDialog(new HopException(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorAddingFile.ErrorMessage", (String[])new String[0])), "TextFileInputDialog.ErrorAddingFile.DialogMessage");
                    return;
                }
                TextFileInputDialog.this.wFilenameList.add(new String[]{TextFileInputDialog.this.wFilename.getText(), TextFileInputDialog.this.wFilemask.getText(), TextFileInputDialog.this.wExcludeFilemask.getText(), TextFileInputMeta.RequiredFilesCode[0], TextFileInputMeta.RequiredFilesCode[0]});
                TextFileInputDialog.this.wFilename.setText("");
                TextFileInputDialog.this.wFilemask.setText("");
                TextFileInputDialog.this.wExcludeFilemask.setText("");
                TextFileInputDialog.this.wFilenameList.removeEmptyRows();
                TextFileInputDialog.this.wFilenameList.setRowNums();
                TextFileInputDialog.this.wFilenameList.optWidth(true);
                TextFileInputDialog.this.checkCompressedFile();
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = TextFileInputDialog.this.wFilenameList.getSelectionIndices();
                TextFileInputDialog.this.wFilenameList.remove(idx);
                TextFileInputDialog.this.wFilenameList.removeEmptyRows();
                TextFileInputDialog.this.wFilenameList.setRowNums();
                TextFileInputDialog.this.checkCompressedFile();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = TextFileInputDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = TextFileInputDialog.this.wFilenameList.getItem(idx);
                    TextFileInputDialog.this.wFilename.setText(string[0]);
                    TextFileInputDialog.this.wFilemask.setText(string[1]);
                    TextFileInputDialog.this.wExcludeFilemask.setText(string[2]);
                    TextFileInputDialog.this.wFilenameList.remove(idx);
                }
                TextFileInputDialog.this.wFilenameList.removeEmptyRows();
                TextFileInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFileInputDialog.this.showFiles();
            }
        });
        this.wbSeparator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                TextFileInputDialog.this.wSeparator.getTextWidget().insert("\t");
            }
        });
        SelectionAdapter lsFlags = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFileInputDialog.this.setFlags();
            }
        };
        this.wInclFilename.addSelectionListener((SelectionListener)lsFlags);
        this.wInclRownum.addSelectionListener((SelectionListener)lsFlags);
        this.wRownumByFile.addSelectionListener((SelectionListener)lsFlags);
        this.wErrorIgnored.addSelectionListener((SelectionListener)lsFlags);
        this.wSkipBadFiles.addSelectionListener((SelectionListener)lsFlags);
        this.wHeader.addSelectionListener((SelectionListener)lsFlags);
        this.wFooter.addSelectionListener((SelectionListener)lsFlags);
        this.wWraps.addSelectionListener((SelectionListener)lsFlags);
        this.wLayoutPaged.addSelectionListener((SelectionListener)lsFlags);
        this.wAccFilenames.addSelectionListener((SelectionListener)lsFlags);
        this.wbbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.txt", "*.csv", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        this.wTabFolder.setSelection(0);
        this.getData(this.input);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void checkCompressedFile() {
        if (this.wFilenameList.getItemCount() > 0) {
            for (int i = 0; i < this.wFilenameList.getItemCount(); ++i) {
                String[] fileRecord = this.wFilenameList.getItem(i);
                String fileExtension = FilenameUtils.getExtension((String)fileRecord[i]);
                Collection compProviders = CompressionProviderFactory.getInstance().getCompressionProviders();
                for (ICompressionProvider provider : compProviders) {
                    if (provider.getDefaultExtension() == null || !provider.getDefaultExtension().equals(fileExtension)) continue;
                    int toBeSelected = ArrayUtils.indexOf((Object[])this.wCompression.getItems(), (Object)provider.getName());
                    this.wCompression.select(toBeSelected);
                    return;
                }
            }
            this.wCompression.select(ArrayUtils.indexOf((Object[])this.wCompression.getItems(), (Object)CompressionProviderFactory.getInstance().getCompressionProviderByName("None").getName()));
        }
    }

    private void showFiles() {
        TextFileInputMeta tfii = new TextFileInputMeta();
        this.getInfo(tfii, true);
        String[] files = FileInputList.createFilePathList((IVariables)this.variables, (String[])tfii.inputFiles.fileName, (String[])tfii.inputFiles.fileMask, (String[])tfii.inputFiles.excludeFileMask, (String[])tfii.inputFiles.fileRequired, (boolean[])tfii.inputFiles.includeSubFolderBoolean());
        if (files != null && files.length > 0) {
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, files, "Files read", "Files read:");
            esd.setViewOnly();
            esd.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NoFilesFound.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void addFilesTab() {
        CTabItem wFileTab = new CTabItem(this.wTabFolder, 0);
        wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        wFileTab.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FileTab.TabTitle", (String[])new String[0]));
        ScrolledComposite wFileSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wFileSComp.setLayout((Layout)new FillLayout());
        Composite wFileComp = new Composite((Composite)wFileSComp, 0);
        PropsUi.setLook((Widget)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment(0, 0);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdbaFilename.top = new FormAttachment(0, 0);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -this.margin);
        fdFilename.top = new FormAttachment(0, 0);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlFilemask = new Label(wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Filemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilemask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, this.margin);
        fdlFilemask.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilemask.setLayoutData((Object)fdlFilemask);
        this.wFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilemask);
        this.wFilemask.addModifyListener(this.lsMod);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(this.middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wFilename, this.margin);
        fdFilemask.right = new FormAttachment((Control)this.wbaFilename, -this.margin);
        this.wFilemask.setLayoutData((Object)fdFilemask);
        Label wlExcludeFilemask = new Label(wFileComp, 131072);
        wlExcludeFilemask.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ExcludeFilemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExcludeFilemask);
        FormData fdlExcludeFilemask = new FormData();
        fdlExcludeFilemask.left = new FormAttachment(0, 0);
        fdlExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdlExcludeFilemask.right = new FormAttachment(this.middle, -this.margin);
        wlExcludeFilemask.setLayoutData((Object)fdlExcludeFilemask);
        this.wExcludeFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wExcludeFilemask);
        this.wExcludeFilemask.addModifyListener(this.lsMod);
        FormData fdExcludeFilemask = new FormData();
        fdExcludeFilemask.left = new FormAttachment(this.middle, 0);
        fdExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, this.margin);
        fdExcludeFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wExcludeFilemask.setLayoutData((Object)fdExcludeFilemask);
        this.wlFilenameList = new Label(wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilenameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdlFilenameList.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbdFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilenameDelete.Button", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilenameDelete.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.left = new FormAttachment((Control)this.wbdFilename, 0, 16384);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, this.margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(this.middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        this.wFirst = new Button(wFileComp, 8);
        this.wFirst.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.First.Button", (String[])new String[0]));
        FormData fdFirst = new FormData();
        fdFirst.left = new FormAttachment((Control)this.wbShowFiles, this.margin * 2);
        fdFirst.bottom = new FormAttachment(100, 0);
        this.wFirst.setLayoutData((Object)fdFirst);
        this.wFirstHeader = new Button(wFileComp, 8);
        this.wFirstHeader.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FirstHeader.Button", (String[])new String[0]));
        FormData fdFirstHeader = new FormData();
        fdFirstHeader.left = new FormAttachment((Control)this.wFirst, this.margin * 2);
        fdFirstHeader.bottom = new FormAttachment(100, 0);
        this.wFirstHeader.setLayoutData((Object)fdFirstHeader);
        Group gAccepting = new Group(wFileComp, 16);
        gAccepting.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AcceptingGroup.Label", (String[])new String[0]));
        FormLayout acceptingLayout = new FormLayout();
        acceptingLayout.marginWidth = 3;
        acceptingLayout.marginHeight = 3;
        gAccepting.setLayout((Layout)acceptingLayout);
        PropsUi.setLook((Widget)gAccepting);
        Label wlAccFilenames = new Label((Composite)gAccepting, 131072);
        wlAccFilenames.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AcceptFilenames.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAccFilenames);
        FormData fdlAccFilenames = new FormData();
        fdlAccFilenames.top = new FormAttachment(0, this.margin);
        fdlAccFilenames.left = new FormAttachment(0, 0);
        fdlAccFilenames.right = new FormAttachment(this.middle, -this.margin);
        wlAccFilenames.setLayoutData((Object)fdlAccFilenames);
        this.wAccFilenames = new Button((Composite)gAccepting, 32);
        this.wAccFilenames.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AcceptFilenames.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAccFilenames);
        FormData fdAccFilenames = new FormData();
        fdAccFilenames.top = new FormAttachment((Control)wlAccFilenames, 0, 0x1000000);
        fdAccFilenames.left = new FormAttachment(this.middle, 0);
        fdAccFilenames.right = new FormAttachment(100, 0);
        this.wAccFilenames.setLayoutData((Object)fdAccFilenames);
        this.wlPassThruFields = new Label((Composite)gAccepting, 131072);
        this.wlPassThruFields.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.PassThruFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlPassThruFields);
        FormData fdlPassThruFields = new FormData();
        fdlPassThruFields.top = new FormAttachment((Control)this.wAccFilenames, this.margin);
        fdlPassThruFields.left = new FormAttachment(0, 0);
        fdlPassThruFields.right = new FormAttachment(this.middle, -this.margin);
        this.wlPassThruFields.setLayoutData((Object)fdlPassThruFields);
        this.wPassThruFields = new Button((Composite)gAccepting, 32);
        this.wPassThruFields.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.PassThruFields.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wPassThruFields);
        FormData fdPassThruFields = new FormData();
        fdPassThruFields.top = new FormAttachment((Control)this.wlPassThruFields, 0, 0x1000000);
        fdPassThruFields.left = new FormAttachment(this.middle, 0);
        fdPassThruFields.right = new FormAttachment(100, 0);
        this.wPassThruFields.setLayoutData((Object)fdPassThruFields);
        this.wlAccTransform = new Label((Composite)gAccepting, 131072);
        this.wlAccTransform.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AcceptTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAccTransform);
        FormData fdlAccTransform = new FormData();
        fdlAccTransform.top = new FormAttachment((Control)this.wPassThruFields, this.margin);
        fdlAccTransform.left = new FormAttachment(0, 0);
        fdlAccTransform.right = new FormAttachment(this.middle, -this.margin);
        this.wlAccTransform.setLayoutData((Object)fdlAccTransform);
        this.wAccTransform = new CCombo((Composite)gAccepting, 18436);
        this.wAccTransform.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AcceptTransform.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAccTransform);
        FormData fdAccTransform = new FormData();
        fdAccTransform.top = new FormAttachment((Control)this.wPassThruFields, this.margin);
        fdAccTransform.left = new FormAttachment(this.middle, 0);
        fdAccTransform.right = new FormAttachment(100, 0);
        this.wAccTransform.setLayoutData((Object)fdAccTransform);
        this.wlAccField = new Label((Composite)gAccepting, 131072);
        this.wlAccField.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AcceptField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAccField);
        FormData fdlAccField = new FormData();
        fdlAccField.top = new FormAttachment((Control)this.wAccTransform, this.margin);
        fdlAccField.left = new FormAttachment(0, 0);
        fdlAccField.right = new FormAttachment(this.middle, -this.margin);
        this.wlAccField.setLayoutData((Object)fdlAccField);
        this.wAccField = new Text((Composite)gAccepting, 18436);
        this.wAccField.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AcceptField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAccField);
        FormData fdAccField = new FormData();
        fdAccField.top = new FormAttachment((Control)this.wAccTransform, this.margin);
        fdAccField.left = new FormAttachment(this.middle, 0);
        fdAccField.right = new FormAttachment(100, 0);
        this.wAccField.setLayoutData((Object)fdAccField);
        List prevTransforms = this.pipelineMeta.findPreviousTransforms(this.pipelineMeta.findTransform(this.transformName));
        for (TransformMeta prevTransform : prevTransforms) {
            this.wAccTransform.add(prevTransform.getName());
        }
        FormData fdAccepting = new FormData();
        fdAccepting.left = new FormAttachment(0, 0);
        fdAccepting.right = new FormAttachment(100, 0);
        fdAccepting.bottom = new FormAttachment((Control)this.wFirstHeader, -this.margin * 2);
        gAccepting.setLayoutData((Object)fdAccepting);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FileDirColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.WildcardColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Files.ExcludeWildcard.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RequiredColumn.Column", (String[])new String[0]), 2, YES_NO_COMBO), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO)};
        colinfo[0].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RegExpColumn.Column", (String[])new String[0]));
        colinfo[1].setUsingVariables(true);
        colinfo[2].setUsingVariables(true);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Files.ExcludeWildcard.Tooltip", (String[])new String[0]));
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RequiredColumn.Tooltip", (String[])new String[0]));
        colinfo[4].setToolTip(BaseMessages.getString(PKG, (String)"TextFileInputDialog.IncludeSubDirs.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67588, colinfo, 4, this.lsMod, this.props);
        PropsUi.setLook((Widget)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(this.middle, 0);
        fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -this.margin);
        fdFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, this.margin);
        fdFilenameList.bottom = new FormAttachment((Control)gAccepting, -this.margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.pack();
        Rectangle bounds = wFileComp.getBounds();
        wFileSComp.setContent((Control)wFileComp);
        wFileSComp.setExpandHorizontal(true);
        wFileSComp.setExpandVertical(true);
        wFileSComp.setMinWidth(bounds.width);
        wFileSComp.setMinHeight(bounds.height);
        wFileTab.setControl((Control)wFileSComp);
    }

    private void addContentTab() {
        CTabItem wContentTab = new CTabItem(this.wTabFolder, 0);
        wContentTab.setFont(GuiResource.getInstance().getFontDefault());
        wContentTab.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ContentTab.TabTitle", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        ScrolledComposite wContentSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wContentSComp.setLayout((Layout)new FillLayout());
        Composite wContentComp = new Composite((Composite)wContentSComp, 0);
        PropsUi.setLook((Widget)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Label wlFiletype = new Label(wContentComp, 131072);
        wlFiletype.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Filetype.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFiletype);
        FormData fdlFiletype = new FormData();
        fdlFiletype.left = new FormAttachment(0, 0);
        fdlFiletype.top = new FormAttachment(0, 0);
        fdlFiletype.right = new FormAttachment(this.middle, -this.margin);
        wlFiletype.setLayoutData((Object)fdlFiletype);
        this.wFiletype = new CCombo(wContentComp, 2056);
        this.wFiletype.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Filetype.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFiletype);
        this.wFiletype.add("CSV");
        this.wFiletype.add("Fixed");
        this.wFiletype.select(0);
        this.wFiletype.addModifyListener(this.lsMod);
        FormData fdFiletype = new FormData();
        fdFiletype.left = new FormAttachment(this.middle, 0);
        fdFiletype.top = new FormAttachment(0, 0);
        fdFiletype.right = new FormAttachment(100, 0);
        this.wFiletype.setLayoutData((Object)fdFiletype);
        Label wlSeparator = new Label(wContentComp, 131072);
        wlSeparator.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Separator.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSeparator);
        FormData fdlSeparator = new FormData();
        fdlSeparator.left = new FormAttachment(0, 0);
        fdlSeparator.top = new FormAttachment((Control)this.wFiletype, this.margin);
        fdlSeparator.right = new FormAttachment(this.middle, -this.margin);
        wlSeparator.setLayoutData((Object)fdlSeparator);
        this.wbSeparator = new Button(wContentComp, 0x1000008);
        this.wbSeparator.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Delimiter.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wbSeparator);
        FormData fdbSeparator = new FormData();
        fdbSeparator.right = new FormAttachment(100, 0);
        fdbSeparator.top = new FormAttachment((Control)this.wFiletype, 0);
        this.wbSeparator.setLayoutData((Object)fdbSeparator);
        this.wSeparator = new TextVar(this.variables, wContentComp, 18436);
        PropsUi.setLook((Widget)this.wSeparator);
        this.wSeparator.addModifyListener(this.lsMod);
        FormData fdSeparator = new FormData();
        fdSeparator.top = new FormAttachment((Control)this.wFiletype, this.margin);
        fdSeparator.left = new FormAttachment(this.middle, 0);
        fdSeparator.right = new FormAttachment((Control)this.wbSeparator, -this.margin);
        this.wSeparator.setLayoutData((Object)fdSeparator);
        Label wlEnclosure = new Label(wContentComp, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Enclosure.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.top = new FormAttachment((Control)this.wSeparator, this.margin);
        fdlEnclosure.right = new FormAttachment(this.middle, -this.margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wEnclosure);
        this.wEnclosure.addModifyListener(this.lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.left = new FormAttachment(this.middle, 0);
        fdEnclosure.top = new FormAttachment((Control)this.wSeparator, this.margin);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        Label wlEnclBreaks = new Label(wContentComp, 131072);
        wlEnclBreaks.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.EnclBreaks.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEnclBreaks);
        FormData fdlEnclBreaks = new FormData();
        fdlEnclBreaks.left = new FormAttachment(0, 0);
        fdlEnclBreaks.top = new FormAttachment((Control)this.wEnclosure, this.margin);
        fdlEnclBreaks.right = new FormAttachment(this.middle, -this.margin);
        wlEnclBreaks.setLayoutData((Object)fdlEnclBreaks);
        Button wEnclBreaks = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)wEnclBreaks);
        FormData fdEnclBreaks = new FormData();
        fdEnclBreaks.left = new FormAttachment(this.middle, 0);
        fdEnclBreaks.top = new FormAttachment((Control)wlEnclBreaks, 0, 0x1000000);
        wEnclBreaks.setLayoutData((Object)fdEnclBreaks);
        wlEnclBreaks.setEnabled(false);
        wEnclBreaks.setEnabled(false);
        Label wlEscape = new Label(wContentComp, 131072);
        wlEscape.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Escape.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEscape);
        FormData fdlEscape = new FormData();
        fdlEscape.left = new FormAttachment(0, 0);
        fdlEscape.top = new FormAttachment((Control)wEnclBreaks, this.margin);
        fdlEscape.right = new FormAttachment(this.middle, -this.margin);
        wlEscape.setLayoutData((Object)fdlEscape);
        this.wEscape = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wEscape);
        this.wEscape.addModifyListener(this.lsMod);
        FormData fdEscape = new FormData();
        fdEscape.left = new FormAttachment(this.middle, 0);
        fdEscape.top = new FormAttachment((Control)wEnclBreaks, this.margin);
        fdEscape.right = new FormAttachment(100, 0);
        this.wEscape.setLayoutData((Object)fdEscape);
        Label wlHeader = new Label(wContentComp, 131072);
        wlHeader.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Header.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlHeader);
        FormData fdlHeader = new FormData();
        fdlHeader.left = new FormAttachment(0, 0);
        fdlHeader.top = new FormAttachment((Control)this.wEscape, this.margin);
        fdlHeader.right = new FormAttachment(this.middle, -this.margin);
        wlHeader.setLayoutData((Object)fdlHeader);
        this.wHeader = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wHeader);
        FormData fdHeader = new FormData();
        fdHeader.left = new FormAttachment(this.middle, 0);
        fdHeader.top = new FormAttachment((Control)wlHeader, 0, 0x1000000);
        this.wHeader.setLayoutData((Object)fdHeader);
        this.wlNrHeader = new Label(wContentComp, 131072);
        this.wlNrHeader.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NrHeader.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNrHeader);
        FormData fdlNrHeader = new FormData();
        fdlNrHeader.left = new FormAttachment((Control)this.wHeader, this.margin);
        fdlNrHeader.top = new FormAttachment((Control)wlHeader, 0, 0x1000000);
        this.wlNrHeader.setLayoutData((Object)fdlNrHeader);
        this.wNrHeader = new Text(wContentComp, 18436);
        this.wNrHeader.setTextLimit(3);
        PropsUi.setLook((Widget)this.wNrHeader);
        this.wNrHeader.addModifyListener(this.lsMod);
        FormData fdNrHeader = new FormData();
        fdNrHeader.left = new FormAttachment((Control)this.wlNrHeader, this.margin);
        fdNrHeader.top = new FormAttachment((Control)wlHeader, 0, 0x1000000);
        fdNrHeader.right = new FormAttachment(100, 0);
        this.wNrHeader.setLayoutData((Object)fdNrHeader);
        Label wlFooter = new Label(wContentComp, 131072);
        wlFooter.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Footer.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFooter);
        FormData fdlFooter = new FormData();
        fdlFooter.left = new FormAttachment(0, 0);
        fdlFooter.top = new FormAttachment((Control)this.wHeader, this.margin);
        fdlFooter.right = new FormAttachment(this.middle, -this.margin);
        wlFooter.setLayoutData((Object)fdlFooter);
        this.wFooter = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wFooter);
        FormData fdFooter = new FormData();
        fdFooter.left = new FormAttachment(this.middle, 0);
        fdFooter.top = new FormAttachment((Control)wlFooter, 0, 0x1000000);
        this.wFooter.setLayoutData((Object)fdFooter);
        this.wlNrFooter = new Label(wContentComp, 131072);
        this.wlNrFooter.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NrFooter.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNrFooter);
        FormData fdlNrFooter = new FormData();
        fdlNrFooter.left = new FormAttachment((Control)this.wFooter, this.margin);
        fdlNrFooter.top = new FormAttachment((Control)wlFooter, 0, 0x1000000);
        this.wlNrFooter.setLayoutData((Object)fdlNrFooter);
        this.wNrFooter = new Text(wContentComp, 18436);
        this.wNrFooter.setTextLimit(3);
        PropsUi.setLook((Widget)this.wNrFooter);
        this.wNrFooter.addModifyListener(this.lsMod);
        FormData fdNrFooter = new FormData();
        fdNrFooter.left = new FormAttachment((Control)this.wlNrFooter, this.margin);
        fdNrFooter.top = new FormAttachment((Control)wlFooter, 0, 0x1000000);
        fdNrFooter.right = new FormAttachment(100, 0);
        this.wNrFooter.setLayoutData((Object)fdNrFooter);
        Label wlWraps = new Label(wContentComp, 131072);
        wlWraps.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Wraps.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWraps);
        FormData fdlWraps = new FormData();
        fdlWraps.left = new FormAttachment(0, 0);
        fdlWraps.top = new FormAttachment((Control)this.wFooter, this.margin);
        fdlWraps.right = new FormAttachment(this.middle, -this.margin);
        wlWraps.setLayoutData((Object)fdlWraps);
        this.wWraps = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wWraps);
        FormData fdWraps = new FormData();
        fdWraps.left = new FormAttachment(this.middle, 0);
        fdWraps.top = new FormAttachment((Control)wlWraps, 0, 0x1000000);
        this.wWraps.setLayoutData((Object)fdWraps);
        this.wlNrWraps = new Label(wContentComp, 131072);
        this.wlNrWraps.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NrWraps.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNrWraps);
        FormData fdlNrWraps = new FormData();
        fdlNrWraps.left = new FormAttachment((Control)this.wWraps, this.margin);
        fdlNrWraps.top = new FormAttachment((Control)wlWraps, 0, 0x1000000);
        this.wlNrWraps.setLayoutData((Object)fdlNrWraps);
        this.wNrWraps = new Text(wContentComp, 18436);
        this.wNrWraps.setTextLimit(3);
        PropsUi.setLook((Widget)this.wNrWraps);
        this.wNrWraps.addModifyListener(this.lsMod);
        FormData fdNrWraps = new FormData();
        fdNrWraps.left = new FormAttachment((Control)this.wlNrWraps, this.margin);
        fdNrWraps.top = new FormAttachment((Control)wlWraps, 0, 0x1000000);
        fdNrWraps.right = new FormAttachment(100, 0);
        this.wNrWraps.setLayoutData((Object)fdNrWraps);
        Label wlLayoutPaged = new Label(wContentComp, 131072);
        wlLayoutPaged.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.LayoutPaged.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLayoutPaged);
        FormData fdlLayoutPaged = new FormData();
        fdlLayoutPaged.left = new FormAttachment(0, 0);
        fdlLayoutPaged.top = new FormAttachment((Control)this.wWraps, this.margin);
        fdlLayoutPaged.right = new FormAttachment(this.middle, -this.margin);
        wlLayoutPaged.setLayoutData((Object)fdlLayoutPaged);
        this.wLayoutPaged = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wLayoutPaged);
        FormData fdLayoutPaged = new FormData();
        fdLayoutPaged.left = new FormAttachment(this.middle, 0);
        fdLayoutPaged.top = new FormAttachment((Control)wlLayoutPaged, 0, 0x1000000);
        this.wLayoutPaged.setLayoutData((Object)fdLayoutPaged);
        this.wlNrLinesPerPage = new Label(wContentComp, 131072);
        this.wlNrLinesPerPage.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NrLinesPerPage.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNrLinesPerPage);
        FormData fdlNrLinesPerPage = new FormData();
        fdlNrLinesPerPage.left = new FormAttachment((Control)this.wLayoutPaged, this.margin);
        fdlNrLinesPerPage.top = new FormAttachment((Control)wlLayoutPaged, 0, 0x1000000);
        this.wlNrLinesPerPage.setLayoutData((Object)fdlNrLinesPerPage);
        this.wNrLinesPerPage = new Text(wContentComp, 18436);
        this.wNrLinesPerPage.setTextLimit(3);
        PropsUi.setLook((Widget)this.wNrLinesPerPage);
        this.wNrLinesPerPage.addModifyListener(this.lsMod);
        FormData fdNrLinesPerPage = new FormData();
        fdNrLinesPerPage.left = new FormAttachment((Control)this.wlNrLinesPerPage, this.margin);
        fdNrLinesPerPage.top = new FormAttachment((Control)wlLayoutPaged, 0, 0x1000000);
        fdNrLinesPerPage.right = new FormAttachment(100, 0);
        this.wNrLinesPerPage.setLayoutData((Object)fdNrLinesPerPage);
        this.wlNrLinesDocHeader = new Label(wContentComp, 131072);
        this.wlNrLinesDocHeader.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NrLinesDocHeader.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlNrLinesDocHeader);
        FormData fdlNrLinesDocHeader = new FormData();
        fdlNrLinesDocHeader.left = new FormAttachment((Control)this.wLayoutPaged, this.margin);
        fdlNrLinesDocHeader.top = new FormAttachment((Control)this.wNrLinesPerPage, this.margin);
        this.wlNrLinesDocHeader.setLayoutData((Object)fdlNrLinesDocHeader);
        this.wNrLinesDocHeader = new Text(wContentComp, 18436);
        this.wNrLinesDocHeader.setTextLimit(3);
        PropsUi.setLook((Widget)this.wNrLinesDocHeader);
        this.wNrLinesDocHeader.addModifyListener(this.lsMod);
        FormData fdNrLinesDocHeader = new FormData();
        fdNrLinesDocHeader.left = new FormAttachment((Control)this.wlNrLinesPerPage, this.margin);
        fdNrLinesDocHeader.top = new FormAttachment((Control)this.wNrLinesPerPage, this.margin);
        fdNrLinesDocHeader.right = new FormAttachment(100, 0);
        this.wNrLinesDocHeader.setLayoutData((Object)fdNrLinesDocHeader);
        Label wlCompression = new Label(wContentComp, 131072);
        wlCompression.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Compression.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCompression);
        FormData fdlCompression = new FormData();
        fdlCompression.left = new FormAttachment(0, 0);
        fdlCompression.top = new FormAttachment((Control)this.wNrLinesDocHeader, this.margin);
        fdlCompression.right = new FormAttachment(this.middle, -this.margin);
        wlCompression.setLayoutData((Object)fdlCompression);
        this.wCompression = new CCombo(wContentComp, 2056);
        this.wCompression.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Compression.Label", (String[])new String[0]));
        this.wCompression.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Compression.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCompression);
        this.wCompression.setItems(CompressionProviderFactory.getInstance().getCompressionProviderNames());
        this.wCompression.addModifyListener(this.lsMod);
        FormData fdCompression = new FormData();
        fdCompression.left = new FormAttachment(this.middle, 0);
        fdCompression.top = new FormAttachment((Control)this.wNrLinesDocHeader, this.margin);
        fdCompression.right = new FormAttachment(100, 0);
        this.wCompression.setLayoutData((Object)fdCompression);
        Label wlNoempty = new Label(wContentComp, 131072);
        wlNoempty.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NoEmpty.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNoempty);
        FormData fdlNoempty = new FormData();
        fdlNoempty.left = new FormAttachment(0, 0);
        fdlNoempty.top = new FormAttachment((Control)this.wCompression, this.margin);
        fdlNoempty.right = new FormAttachment(this.middle, -this.margin);
        wlNoempty.setLayoutData((Object)fdlNoempty);
        this.wNoempty = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wNoempty);
        this.wNoempty.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NoEmpty.Tooltip", (String[])new String[0]));
        FormData fdNoempty = new FormData();
        fdNoempty.left = new FormAttachment(this.middle, 0);
        fdNoempty.top = new FormAttachment((Control)wlNoempty, 0, 0x1000000);
        fdNoempty.right = new FormAttachment(100, 0);
        this.wNoempty.setLayoutData((Object)fdNoempty);
        Label wlInclFilename = new Label(wContentComp, 131072);
        wlInclFilename.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.InclFilename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclFilename);
        FormData fdlInclFilename = new FormData();
        fdlInclFilename.left = new FormAttachment(0, 0);
        fdlInclFilename.top = new FormAttachment((Control)this.wNoempty, this.margin);
        fdlInclFilename.right = new FormAttachment(this.middle, -this.margin);
        wlInclFilename.setLayoutData((Object)fdlInclFilename);
        this.wInclFilename = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wInclFilename);
        this.wInclFilename.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.InclFilename.Tooltip", (String[])new String[0]));
        FormData fdInclFilename = new FormData();
        fdInclFilename.left = new FormAttachment(this.middle, 0);
        fdInclFilename.top = new FormAttachment((Control)wlInclFilename, 0, 0x1000000);
        this.wInclFilename.setLayoutData((Object)fdInclFilename);
        this.wlInclFilenameField = new Label(wContentComp, 16384);
        this.wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.InclFilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclFilenameField);
        FormData fdlInclFilenameField = new FormData();
        fdlInclFilenameField.left = new FormAttachment((Control)this.wInclFilename, this.margin);
        fdlInclFilenameField.top = new FormAttachment((Control)wlInclFilename, 0, 0x1000000);
        this.wlInclFilenameField.setLayoutData((Object)fdlInclFilenameField);
        this.wInclFilenameField = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wInclFilenameField);
        this.wInclFilenameField.addModifyListener(this.lsMod);
        FormData fdInclFilenameField = new FormData();
        fdInclFilenameField.left = new FormAttachment((Control)this.wlInclFilenameField, this.margin);
        fdInclFilenameField.top = new FormAttachment((Control)wlInclFilename, 0, 0x1000000);
        fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)fdInclFilenameField);
        Label wlInclRownum = new Label(wContentComp, 131072);
        wlInclRownum.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.InclRownum.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownum);
        FormData fdlInclRownum = new FormData();
        fdlInclRownum.left = new FormAttachment(0, 0);
        fdlInclRownum.top = new FormAttachment((Control)this.wInclFilenameField, this.margin);
        fdlInclRownum.right = new FormAttachment(this.middle, -this.margin);
        wlInclRownum.setLayoutData((Object)fdlInclRownum);
        this.wInclRownum = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.InclRownum.Tooltip", (String[])new String[0]));
        FormData fdRownum = new FormData();
        fdRownum.left = new FormAttachment(this.middle, 0);
        fdRownum.top = new FormAttachment((Control)wlInclRownum, 0, 0x1000000);
        this.wInclRownum.setLayoutData((Object)fdRownum);
        this.wlInclRownumField = new Label(wContentComp, 131072);
        this.wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.InclRownumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlInclRownumField);
        FormData fdlInclRownumField = new FormData();
        fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, this.margin);
        fdlInclRownumField.top = new FormAttachment((Control)wlInclRownum, 0, 0x1000000);
        this.wlInclRownumField.setLayoutData((Object)fdlInclRownumField);
        this.wInclRownumField = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(this.lsMod);
        FormData fdInclRownumField = new FormData();
        fdInclRownumField.left = new FormAttachment((Control)this.wlInclRownumField, this.margin);
        fdInclRownumField.top = new FormAttachment((Control)wlInclRownum, 0, 0x1000000);
        fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)fdInclRownumField);
        this.wlRownumByFileField = new Label(wContentComp, 131072);
        this.wlRownumByFileField.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RownumByFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRownumByFileField);
        FormData fdlRownumByFile = new FormData();
        fdlRownumByFile.left = new FormAttachment((Control)this.wInclRownum, this.margin);
        fdlRownumByFile.top = new FormAttachment((Control)this.wInclRownumField, this.margin);
        this.wlRownumByFileField.setLayoutData((Object)fdlRownumByFile);
        this.wRownumByFile = new Button(wContentComp, 32);
        PropsUi.setLook((Widget)this.wRownumByFile);
        this.wRownumByFile.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RownumByFile.Tooltip", (String[])new String[0]));
        FormData fdRownumByFile = new FormData();
        fdRownumByFile.left = new FormAttachment((Control)this.wlRownumByFileField, this.margin);
        fdRownumByFile.top = new FormAttachment((Control)this.wlRownumByFileField, 0, 0x1000000);
        this.wRownumByFile.setLayoutData((Object)fdRownumByFile);
        Label wlFormat = new Label(wContentComp, 131072);
        wlFormat.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Format.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFormat);
        FormData fdlFormat = new FormData();
        fdlFormat.left = new FormAttachment(0, 0);
        fdlFormat.top = new FormAttachment((Control)this.wRownumByFile, this.margin * 2);
        fdlFormat.right = new FormAttachment(this.middle, -this.margin);
        wlFormat.setLayoutData((Object)fdlFormat);
        this.wFormat = new CCombo(wContentComp, 2056);
        this.wFormat.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Format.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFormat);
        this.wFormat.add("DOS");
        this.wFormat.add("Unix");
        this.wFormat.add("mixed");
        this.wFormat.select(0);
        this.wFormat.addModifyListener(this.lsMod);
        FormData fdFormat = new FormData();
        fdFormat.left = new FormAttachment(this.middle, 0);
        fdFormat.top = new FormAttachment((Control)this.wRownumByFile, this.margin * 2);
        fdFormat.right = new FormAttachment(100, 0);
        this.wFormat.setLayoutData((Object)fdFormat);
        Label wlEncoding = new Label(wContentComp, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Encoding.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wFormat, this.margin);
        fdlEncoding.right = new FormAttachment(this.middle, -this.margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new CCombo(wContentComp, 2056);
        this.wEncoding.setEditable(true);
        PropsUi.setLook((Widget)this.wEncoding);
        this.wEncoding.addModifyListener(this.lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(this.middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wFormat, this.margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)TextFileInputDialog.this.shell.getDisplay(), 1);
                TextFileInputDialog.this.shell.setCursor(busy);
                TextFileInputDialog.this.setEncodings();
                TextFileInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlLength = new Label(wContentComp, 131072);
        wlLength.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Length.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLength);
        FormData fdlLength = new FormData();
        fdlLength.left = new FormAttachment(0, 0);
        fdlLength.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdlLength.right = new FormAttachment(this.middle, -this.margin);
        wlLength.setLayoutData((Object)fdlLength);
        this.wLength = new CCombo(wContentComp, 2056);
        this.wLength.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Length.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wLength);
        this.wLength.add("Characters");
        this.wLength.add("Bytes");
        this.wLength.select(0);
        this.wLength.addModifyListener(this.lsMod);
        FormData fdLength = new FormData();
        fdLength.left = new FormAttachment(this.middle, 0);
        fdLength.top = new FormAttachment((Control)this.wEncoding, this.margin);
        fdLength.right = new FormAttachment(100, 0);
        this.wLength.setLayoutData((Object)fdLength);
        Label wlLimit = new Label(wContentComp, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)this.wLength, this.margin);
        fdlLimit.right = new FormAttachment(this.middle, -this.margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text(wContentComp, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(this.lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(this.middle, 0);
        fdLimit.top = new FormAttachment((Control)this.wLength, this.margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlDateLenient = new Label(wContentComp, 131072);
        wlDateLenient.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.DateLenient.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDateLenient);
        FormData fdlDateLenient = new FormData();
        fdlDateLenient.left = new FormAttachment(0, 0);
        fdlDateLenient.top = new FormAttachment((Control)this.wLimit, this.margin);
        fdlDateLenient.right = new FormAttachment(this.middle, -this.margin);
        wlDateLenient.setLayoutData((Object)fdlDateLenient);
        this.wDateLenient = new Button(wContentComp, 32);
        this.wDateLenient.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.DateLenient.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDateLenient);
        FormData fdDateLenient = new FormData();
        fdDateLenient.left = new FormAttachment(this.middle, 0);
        fdDateLenient.top = new FormAttachment((Control)wlDateLenient, 0, 0x1000000);
        this.wDateLenient.setLayoutData((Object)fdDateLenient);
        Label wlDateLocale = new Label(wContentComp, 131072);
        wlDateLocale.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.DateLocale.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDateLocale);
        FormData fdlDateLocale = new FormData();
        fdlDateLocale.left = new FormAttachment(0, 0);
        fdlDateLocale.top = new FormAttachment((Control)this.wDateLenient, this.margin);
        fdlDateLocale.right = new FormAttachment(this.middle, -this.margin);
        wlDateLocale.setLayoutData((Object)fdlDateLocale);
        this.wDateLocale = new CCombo(wContentComp, 18436);
        this.wDateLocale.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.DateLocale.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wDateLocale);
        this.wDateLocale.addModifyListener(this.lsMod);
        FormData fdDateLocale = new FormData();
        fdDateLocale.left = new FormAttachment(this.middle, 0);
        fdDateLocale.top = new FormAttachment((Control)this.wDateLenient, this.margin);
        fdDateLocale.right = new FormAttachment(100, 0);
        this.wDateLocale.setLayoutData((Object)fdDateLocale);
        this.wDateLocale.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)TextFileInputDialog.this.shell.getDisplay(), 1);
                TextFileInputDialog.this.shell.setCursor(busy);
                TextFileInputDialog.this.setLocales();
                TextFileInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Group wAddFileResult = new Group(wContentComp, 32);
        PropsUi.setLook((Widget)wAddFileResult);
        wAddFileResult.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.wAddFileResult.Label", (String[])new String[0]));
        FormLayout addFileResultgroupLayout = new FormLayout();
        addFileResultgroupLayout.marginWidth = 10;
        addFileResultgroupLayout.marginHeight = 10;
        wAddFileResult.setLayout((Layout)addFileResultgroupLayout);
        Label wlAddResult = new Label((Composite)wAddFileResult, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wDateLocale, this.margin);
        fdlAddResult.right = new FormAttachment(this.middle, -this.margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wAddFileResult, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(this.middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        FormData fdAddFileResult = new FormData();
        fdAddFileResult.left = new FormAttachment(0, this.margin);
        fdAddFileResult.top = new FormAttachment((Control)this.wDateLocale, this.margin);
        fdAddFileResult.right = new FormAttachment(100, -this.margin);
        wAddFileResult.setLayoutData((Object)fdAddFileResult);
        wContentComp.pack();
        Rectangle bounds = wContentComp.getBounds();
        wContentSComp.setContent((Control)wContentComp);
        wContentSComp.setExpandHorizontal(true);
        wContentSComp.setExpandVertical(true);
        wContentSComp.setMinWidth(bounds.width);
        wContentSComp.setMinHeight(bounds.height);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentTab.setControl((Control)wContentSComp);
    }

    protected void setLocales() {
        Locale[] locale = Locale.getAvailableLocales();
        String[] dateLocale = new String[locale.length];
        for (int i = 0; i < locale.length; ++i) {
            dateLocale[i] = locale[i].toString();
        }
        if (dateLocale != null) {
            this.wDateLocale.setItems(dateLocale);
        }
    }

    private void addErrorTab() {
        CTabItem wErrorTab = new CTabItem(this.wTabFolder, 0);
        wErrorTab.setFont(GuiResource.getInstance().getFontDefault());
        wErrorTab.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorTab.TabTitle", (String[])new String[0]));
        ScrolledComposite wErrorSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wErrorSComp.setLayout((Layout)new FillLayout());
        FormLayout errorLayout = new FormLayout();
        errorLayout.marginWidth = 3;
        errorLayout.marginHeight = 3;
        Composite wErrorComp = new Composite((Composite)wErrorSComp, 0);
        PropsUi.setLook((Widget)wErrorComp);
        wErrorComp.setLayout((Layout)errorLayout);
        Label wlErrorIgnored = new Label(wErrorComp, 131072);
        wlErrorIgnored.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorIgnored.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlErrorIgnored);
        FormData fdlErrorIgnored = new FormData();
        fdlErrorIgnored.left = new FormAttachment(0, 0);
        fdlErrorIgnored.top = new FormAttachment(0, this.margin);
        fdlErrorIgnored.right = new FormAttachment(this.middle, -this.margin);
        wlErrorIgnored.setLayoutData((Object)fdlErrorIgnored);
        this.wErrorIgnored = new Button(wErrorComp, 32);
        PropsUi.setLook((Widget)this.wErrorIgnored);
        this.wErrorIgnored.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorIgnored.Tooltip", (String[])new String[0]));
        FormData fdErrorIgnored = new FormData();
        fdErrorIgnored.left = new FormAttachment(this.middle, 0);
        fdErrorIgnored.top = new FormAttachment((Control)wlErrorIgnored, 0, 0x1000000);
        this.wErrorIgnored.setLayoutData((Object)fdErrorIgnored);
        Label wlSkipBadFiles = new Label(wErrorComp, 131072);
        wlSkipBadFiles.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.SkipBadFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSkipBadFiles);
        FormData fdlSkipBadFiles = new FormData();
        fdlSkipBadFiles.left = new FormAttachment(0, 0);
        fdlSkipBadFiles.top = new FormAttachment((Control)this.wErrorIgnored, this.margin);
        fdlSkipBadFiles.right = new FormAttachment(this.middle, -this.margin);
        wlSkipBadFiles.setLayoutData((Object)fdlSkipBadFiles);
        this.wSkipBadFiles = new Button(wErrorComp, 32);
        PropsUi.setLook((Widget)this.wSkipBadFiles);
        this.wSkipBadFiles.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.SkipBadFiles.Tooltip", (String[])new String[0]));
        FormData fdSkipBadFiles = new FormData();
        fdSkipBadFiles.left = new FormAttachment(this.middle, 0);
        fdSkipBadFiles.top = new FormAttachment((Control)wlSkipBadFiles, 0, 0x1000000);
        this.wSkipBadFiles.setLayoutData((Object)fdSkipBadFiles);
        Label wlBadFileField = new Label(wErrorComp, 131072);
        wlBadFileField.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.BadFileField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBadFileField);
        FormData fdlBadFileField = new FormData();
        fdlBadFileField.left = new FormAttachment(0, 0);
        fdlBadFileField.top = new FormAttachment((Control)this.wSkipBadFiles, this.margin);
        fdlBadFileField.right = new FormAttachment(this.middle, -this.margin);
        wlBadFileField.setLayoutData((Object)fdlBadFileField);
        this.wBadFileField = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wBadFileField);
        this.wBadFileField.addModifyListener(this.lsMod);
        FormData fdBadFileField = new FormData();
        fdBadFileField.left = new FormAttachment(this.middle, 0);
        fdBadFileField.top = new FormAttachment((Control)this.wSkipBadFiles, this.margin);
        fdBadFileField.right = new FormAttachment(100, 0);
        this.wBadFileField.setLayoutData((Object)fdBadFileField);
        Label wlBadFileMessageField = new Label(wErrorComp, 131072);
        wlBadFileMessageField.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.BadFileMessageField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBadFileMessageField);
        FormData fdlBadFileMessageField = new FormData();
        fdlBadFileMessageField.left = new FormAttachment(0, 0);
        fdlBadFileMessageField.top = new FormAttachment((Control)this.wBadFileField, this.margin);
        fdlBadFileMessageField.right = new FormAttachment(this.middle, -this.margin);
        wlBadFileMessageField.setLayoutData((Object)fdlBadFileMessageField);
        this.wBadFileMessageField = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wBadFileMessageField);
        this.wBadFileMessageField.addModifyListener(this.lsMod);
        FormData fdBadFileMessageField = new FormData();
        fdBadFileMessageField.left = new FormAttachment(this.middle, 0);
        fdBadFileMessageField.top = new FormAttachment((Control)this.wBadFileField, this.margin);
        fdBadFileMessageField.right = new FormAttachment(100, 0);
        this.wBadFileMessageField.setLayoutData((Object)fdBadFileMessageField);
        this.wlSkipErrorLines = new Label(wErrorComp, 131072);
        this.wlSkipErrorLines.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.SkipErrorLines.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSkipErrorLines);
        FormData fdlSkipErrorLines = new FormData();
        fdlSkipErrorLines.left = new FormAttachment(0, 0);
        fdlSkipErrorLines.top = new FormAttachment((Control)this.wBadFileMessageField, this.margin);
        fdlSkipErrorLines.right = new FormAttachment(this.middle, -this.margin);
        this.wlSkipErrorLines.setLayoutData((Object)fdlSkipErrorLines);
        this.wSkipErrorLines = new Button(wErrorComp, 32);
        PropsUi.setLook((Widget)this.wSkipErrorLines);
        this.wSkipErrorLines.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.SkipErrorLines.Tooltip", (String[])new String[0]));
        FormData fdSkipErrorLines = new FormData();
        fdSkipErrorLines.left = new FormAttachment(this.middle, 0);
        fdSkipErrorLines.top = new FormAttachment((Control)this.wlSkipErrorLines, 0, 0x1000000);
        this.wSkipErrorLines.setLayoutData((Object)fdSkipErrorLines);
        this.wlErrorCount = new Label(wErrorComp, 131072);
        this.wlErrorCount.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorCount.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorCount);
        FormData fdlErrorCount = new FormData();
        fdlErrorCount.left = new FormAttachment(0, 0);
        fdlErrorCount.top = new FormAttachment((Control)this.wSkipErrorLines, this.margin);
        fdlErrorCount.right = new FormAttachment(this.middle, -this.margin);
        this.wlErrorCount.setLayoutData((Object)fdlErrorCount);
        this.wErrorCount = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wErrorCount);
        this.wErrorCount.addModifyListener(this.lsMod);
        FormData fdErrorCount = new FormData();
        fdErrorCount.left = new FormAttachment(this.middle, 0);
        fdErrorCount.top = new FormAttachment((Control)this.wSkipErrorLines, this.margin);
        fdErrorCount.right = new FormAttachment(100, 0);
        this.wErrorCount.setLayoutData((Object)fdErrorCount);
        this.wlErrorFields = new Label(wErrorComp, 131072);
        this.wlErrorFields.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorFields);
        FormData fdlErrorFields = new FormData();
        fdlErrorFields.left = new FormAttachment(0, 0);
        fdlErrorFields.top = new FormAttachment((Control)this.wErrorCount, this.margin);
        fdlErrorFields.right = new FormAttachment(this.middle, -this.margin);
        this.wlErrorFields.setLayoutData((Object)fdlErrorFields);
        this.wErrorFields = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wErrorFields);
        this.wErrorFields.addModifyListener(this.lsMod);
        FormData fdErrorFields = new FormData();
        fdErrorFields.left = new FormAttachment(this.middle, 0);
        fdErrorFields.top = new FormAttachment((Control)this.wErrorCount, this.margin);
        fdErrorFields.right = new FormAttachment(100, 0);
        this.wErrorFields.setLayoutData((Object)fdErrorFields);
        this.wlErrorText = new Label(wErrorComp, 131072);
        this.wlErrorText.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorText.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorText);
        FormData fdlErrorText = new FormData();
        fdlErrorText.left = new FormAttachment(0, 0);
        fdlErrorText.top = new FormAttachment((Control)this.wErrorFields, this.margin);
        fdlErrorText.right = new FormAttachment(this.middle, -this.margin);
        this.wlErrorText.setLayoutData((Object)fdlErrorText);
        this.wErrorText = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wErrorText);
        this.wErrorText.addModifyListener(this.lsMod);
        FormData fdErrorText = new FormData();
        fdErrorText.left = new FormAttachment(this.middle, 0);
        fdErrorText.top = new FormAttachment((Control)this.wErrorFields, this.margin);
        fdErrorText.right = new FormAttachment(100, 0);
        this.wErrorText.setLayoutData((Object)fdErrorText);
        Text previous = this.wErrorText;
        this.wlWarnDestDir = new Label(wErrorComp, 131072);
        this.wlWarnDestDir.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.WarnDestDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlWarnDestDir);
        FormData fdlWarnDestDir = new FormData();
        fdlWarnDestDir.left = new FormAttachment(0, 0);
        fdlWarnDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        fdlWarnDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlWarnDestDir.setLayoutData((Object)fdlWarnDestDir);
        this.wbbWarnDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbWarnDestDir);
        this.wbbWarnDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbWarnDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForDir", (String[])new String[0]));
        FormData fdbBadDestDir = new FormData();
        fdbBadDestDir.right = new FormAttachment(100, 0);
        fdbBadDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wbbWarnDestDir.setLayoutData((Object)fdbBadDestDir);
        this.wWarnExt = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wWarnExt);
        this.wWarnExt.addModifyListener(this.lsMod);
        FormData fdWarnDestExt = new FormData();
        fdWarnDestExt.left = new FormAttachment((Control)this.wbbWarnDestDir, -150);
        fdWarnDestExt.right = new FormAttachment((Control)this.wbbWarnDestDir, -this.margin);
        fdWarnDestExt.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wWarnExt.setLayoutData((Object)fdWarnDestExt);
        this.wlWarnExt = new Label(wErrorComp, 131072);
        this.wlWarnExt.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlWarnExt);
        FormData fdlWarnDestExt = new FormData();
        fdlWarnDestExt.top = new FormAttachment((Control)previous, this.margin * 4);
        fdlWarnDestExt.right = new FormAttachment((Control)this.wWarnExt, -this.margin);
        this.wlWarnExt.setLayoutData((Object)fdlWarnDestExt);
        this.wWarnDestDir = new TextVar(this.variables, wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wWarnDestDir);
        this.wWarnDestDir.addModifyListener(this.lsMod);
        FormData fdBadDestDir = new FormData();
        fdBadDestDir.left = new FormAttachment(this.middle, 0);
        fdBadDestDir.right = new FormAttachment((Control)this.wlWarnExt, -this.margin);
        fdBadDestDir.top = new FormAttachment((Control)previous, this.margin * 4);
        this.wWarnDestDir.setLayoutData((Object)fdBadDestDir);
        this.wbbWarnDestDir.addSelectionListener((SelectionListener)DirectoryDialogButtonListenerFactory.getSelectionAdapter(this.shell, this.wWarnDestDir));
        this.wWarnDestDir.addModifyListener(TextFileInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wWarnDestDir));
        previous = this.wWarnDestDir;
        this.wlErrorDestDir = new Label(wErrorComp, 131072);
        this.wlErrorDestDir.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ErrorDestDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorDestDir);
        FormData fdlErrorDestDir = new FormData();
        fdlErrorDestDir.left = new FormAttachment(0, 0);
        fdlErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlErrorDestDir.setLayoutData((Object)fdlErrorDestDir);
        this.wbbErrorDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbErrorDestDir);
        this.wbbErrorDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbErrorDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForDir", (String[])new String[0]));
        FormData fdbErrorDestDir = new FormData();
        fdbErrorDestDir.right = new FormAttachment(100, 0);
        fdbErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbbErrorDestDir.setLayoutData((Object)fdbErrorDestDir);
        this.wErrorExt = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wErrorExt);
        this.wErrorExt.addModifyListener(this.lsMod);
        FormData fdErrorDestExt = new FormData();
        fdErrorDestExt.left = new FormAttachment((Control)this.wWarnExt, 0, 16384);
        fdErrorDestExt.right = new FormAttachment((Control)this.wWarnExt, 0, 131072);
        fdErrorDestExt.top = new FormAttachment((Control)previous, this.margin);
        this.wErrorExt.setLayoutData((Object)fdErrorDestExt);
        this.wlErrorExt = new Label(wErrorComp, 131072);
        this.wlErrorExt.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorExt);
        FormData fdlErrorDestExt = new FormData();
        fdlErrorDestExt.top = new FormAttachment((Control)previous, this.margin);
        fdlErrorDestExt.right = new FormAttachment((Control)this.wErrorExt, -this.margin);
        this.wlErrorExt.setLayoutData((Object)fdlErrorDestExt);
        this.wErrorDestDir = new TextVar(this.variables, wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wErrorDestDir);
        this.wErrorDestDir.addModifyListener(this.lsMod);
        FormData fdErrorDestDir = new FormData();
        fdErrorDestDir.left = new FormAttachment(this.middle, 0);
        fdErrorDestDir.right = new FormAttachment((Control)this.wlErrorExt, -this.margin);
        fdErrorDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wErrorDestDir.setLayoutData((Object)fdErrorDestDir);
        this.wbbErrorDestDir.addSelectionListener((SelectionListener)DirectoryDialogButtonListenerFactory.getSelectionAdapter(this.shell, this.wErrorDestDir));
        this.wErrorDestDir.addModifyListener(TextFileInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wErrorDestDir));
        previous = this.wErrorDestDir;
        this.wlLineNrDestDir = new Label(wErrorComp, 131072);
        this.wlLineNrDestDir.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.LineNrDestDir.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLineNrDestDir);
        FormData fdlLineNrDestDir = new FormData();
        fdlLineNrDestDir.left = new FormAttachment(0, 0);
        fdlLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        fdlLineNrDestDir.right = new FormAttachment(this.middle, -this.margin);
        this.wlLineNrDestDir.setLayoutData((Object)fdlLineNrDestDir);
        this.wbbLineNrDestDir = new Button(wErrorComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbLineNrDestDir);
        this.wbbLineNrDestDir.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbLineNrDestDir.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Browse", (String[])new String[0]));
        FormData fdbLineNrDestDir = new FormData();
        fdbLineNrDestDir.right = new FormAttachment(100, 0);
        fdbLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wbbLineNrDestDir.setLayoutData((Object)fdbLineNrDestDir);
        this.wLineNrExt = new Text(wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wLineNrExt);
        this.wLineNrExt.addModifyListener(this.lsMod);
        FormData fdLineNrDestExt = new FormData();
        fdLineNrDestExt.left = new FormAttachment((Control)this.wErrorExt, 0, 16384);
        fdLineNrDestExt.right = new FormAttachment((Control)this.wErrorExt, 0, 131072);
        fdLineNrDestExt.top = new FormAttachment((Control)previous, this.margin);
        this.wLineNrExt.setLayoutData((Object)fdLineNrDestExt);
        this.wlLineNrExt = new Label(wErrorComp, 131072);
        this.wlLineNrExt.setText(BaseMessages.getString(PKG, (String)"System.Label.Extension", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlLineNrExt);
        FormData fdlLineNrDestExt = new FormData();
        fdlLineNrDestExt.top = new FormAttachment((Control)previous, this.margin);
        fdlLineNrDestExt.right = new FormAttachment((Control)this.wLineNrExt, -this.margin);
        this.wlLineNrExt.setLayoutData((Object)fdlLineNrDestExt);
        this.wLineNrDestDir = new TextVar(this.variables, wErrorComp, 18436);
        PropsUi.setLook((Widget)this.wLineNrDestDir);
        this.wLineNrDestDir.addModifyListener(this.lsMod);
        FormData fdLineNrDestDir = new FormData();
        fdLineNrDestDir.left = new FormAttachment(this.middle, 0);
        fdLineNrDestDir.right = new FormAttachment((Control)this.wlLineNrExt, -this.margin);
        fdLineNrDestDir.top = new FormAttachment((Control)previous, this.margin);
        this.wLineNrDestDir.setLayoutData((Object)fdLineNrDestDir);
        this.wbbLineNrDestDir.addSelectionListener((SelectionListener)DirectoryDialogButtonListenerFactory.getSelectionAdapter(this.shell, this.wLineNrDestDir));
        this.wLineNrDestDir.addModifyListener(TextFileInputDialog.getModifyListenerTooltipText((IVariables)this.variables, (TextVar)this.wLineNrDestDir));
        FormData fdErrorComp = new FormData();
        fdErrorComp.left = new FormAttachment(0, 0);
        fdErrorComp.top = new FormAttachment(0, 0);
        fdErrorComp.right = new FormAttachment(100, 0);
        fdErrorComp.bottom = new FormAttachment(100, 0);
        wErrorComp.setLayoutData((Object)fdErrorComp);
        wErrorComp.pack();
        Rectangle bounds = wErrorComp.getBounds();
        wErrorSComp.setContent((Control)wErrorComp);
        wErrorSComp.setExpandHorizontal(true);
        wErrorSComp.setExpandVertical(true);
        wErrorSComp.setMinWidth(bounds.width);
        wErrorSComp.setMinHeight(bounds.height);
        wErrorTab.setControl((Control)wErrorSComp);
    }

    private void addFiltersTabs() {
        CTabItem wFilterTab = new CTabItem(this.wTabFolder, 0);
        wFilterTab.setFont(GuiResource.getInstance().getFontDefault());
        wFilterTab.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilterTab.TabTitle", (String[])new String[0]));
        FormLayout filterLayout = new FormLayout();
        filterLayout.marginWidth = PropsUi.getFormMargin();
        filterLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFilterComp = new Composite((Composite)this.wTabFolder, 0);
        wFilterComp.setLayout((Layout)filterLayout);
        PropsUi.setLook((Widget)wFilterComp);
        int FilterRows = this.input.getFilter().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilterStringColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilterPositionColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.StopOnFilterColumn.Column", (String[])new String[0]), 2, YES_NO_COMBO), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilterPositiveColumn.Column", (String[])new String[0]), 2, YES_NO_COMBO)};
        colinf[2].setToolTip(BaseMessages.getString(PKG, (String)"TextFileInputDialog.StopOnFilterColumn.Tooltip", (String[])new String[0]));
        colinf[3].setToolTip(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FilterPositiveColumn.Tooltip", (String[])new String[0]));
        this.wFilter = new TableView(this.variables, wFilterComp, 65538, colinf, FilterRows, this.lsMod, this.props);
        FormData fdFilter = new FormData();
        fdFilter.left = new FormAttachment(0, 0);
        fdFilter.top = new FormAttachment(0, 0);
        fdFilter.right = new FormAttachment(100, 0);
        fdFilter.bottom = new FormAttachment(100, 0);
        this.wFilter.setLayoutData((Object)fdFilter);
        FormData fdFilterComp = new FormData();
        fdFilterComp.left = new FormAttachment(0, 0);
        fdFilterComp.top = new FormAttachment(0, 0);
        fdFilterComp.right = new FormAttachment(100, 0);
        fdFilterComp.bottom = new FormAttachment(100, 0);
        wFilterComp.setLayoutData((Object)fdFilterComp);
        wFilterComp.layout();
        wFilterTab.setControl((Control)wFilterComp);
    }

    private void addFieldsTabs() {
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFileInputDialog.this.fillFieldsLayoutFromSchema();
                TextFileInputDialog.this.input.setChanged();
            }
        };
        CTabItem wFieldsTab = new CTabItem(this.wTabFolder, 0);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = PropsUi.getFormMargin();
        fieldsLayout.marginHeight = PropsUi.getFormMargin();
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        PropsUi.setLook((Widget)wFieldsComp);
        this.wSchemaDefinition = new MetaSelectionLine(this.variables, this.metadataProvider, SchemaDefinition.class, wFieldsComp, 0, BaseMessages.getString(PKG, (String)"TextFileInputDialog.SchemaDefinition.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TextFileInputDialog.SchemaDefinition.Tooltip", (String[])new String[0]));
        PropsUi.setLook(this.wSchemaDefinition);
        FormData fdSchemaDefinition = new FormData();
        fdSchemaDefinition.left = new FormAttachment(0, 0);
        fdSchemaDefinition.top = new FormAttachment(0, this.margin);
        fdSchemaDefinition.right = new FormAttachment(100, 0);
        this.wSchemaDefinition.setLayoutData((Object)fdSchemaDefinition);
        try {
            this.wSchemaDefinition.fillItems();
        }
        catch (Exception e) {
            this.log.logError("Error getting schema definition items", (Throwable)e);
        }
        this.wSchemaDefinition.addSelectionListener((SelectionListener)lsSelection);
        Group wManualSchemaDefinition = new Group(wFieldsComp, 32);
        PropsUi.setLook((Widget)wManualSchemaDefinition);
        wManualSchemaDefinition.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ManualSchemaDefinition.Label", (String[])new String[0]));
        FormLayout manualSchemaDefinitionLayout = new FormLayout();
        manualSchemaDefinitionLayout.marginWidth = 10;
        manualSchemaDefinitionLayout.marginHeight = 10;
        wManualSchemaDefinition.setLayout((Layout)manualSchemaDefinitionLayout);
        this.wGet = new Button((Composite)wManualSchemaDefinition, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.left = new FormAttachment(50, 0);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.wMinWidth = new Button((Composite)wManualSchemaDefinition, 8);
        this.wMinWidth.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.MinWidth.Button", (String[])new String[0]));
        this.wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.MinWidth.Tooltip", (String[])new String[0]));
        this.wMinWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFileInputDialog.this.input.setChanged();
            }
        });
        this.setButtonPositions(new Button[]{this.wGet, this.wMinWidth}, this.margin, null);
        int FieldsRows = this.input.inputFields.length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.TypeColumn.Column", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.FormatColumn.Column", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.PositionColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.LengthColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.CurrencyColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.DecimalColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.GroupColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NullIfColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.IfNullColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.TrimTypeColumn.Column", (String[])new String[0]), 2, ValueMetaString.trimTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RepeatColumn.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true)};
        colinf[12].setToolTip(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RepeatColumn.Tooltip", (String[])new String[0]));
        this.wFields = new TableView(this.variables, (Composite)wManualSchemaDefinition, 65538, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -this.margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdManualSchemaDefinitionComp = new FormData();
        fdManualSchemaDefinitionComp.left = new FormAttachment(0, 0);
        fdManualSchemaDefinitionComp.top = new FormAttachment(this.wSchemaDefinition, 0);
        fdManualSchemaDefinitionComp.right = new FormAttachment(100, 0);
        fdManualSchemaDefinitionComp.bottom = new FormAttachment(100, 0);
        wManualSchemaDefinition.setLayoutData((Object)fdManualSchemaDefinitionComp);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
    }

    private void fillFieldsLayoutFromSchema() {
        if (!this.wSchemaDefinition.isDisposed()) {
            String schemaName = this.wSchemaDefinition.getText();
            MessageBox mb = new MessageBox(this.shell, 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Load.SchemaDefinition.Message", (String[])new String[]{schemaName}));
            mb.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Load.SchemaDefinition.Title", (String[])new String[0]));
            int answer = mb.open();
            if (answer == 64 && !Utils.isEmpty((CharSequence)schemaName)) {
                try {
                    String[] fieldNames;
                    IRowMeta r;
                    SchemaDefinition schemaDefinition = new SchemaDefinitionUtil().loadSchemaDefinition(this.metadataProvider, schemaName);
                    if (schemaDefinition != null && (r = schemaDefinition.getRowMeta()) != null && (fieldNames = r.getFieldNames()) != null) {
                        this.wFields.clearAll();
                        for (int i = 0; i < fieldNames.length; ++i) {
                            IValueMeta valueMeta = r.getValueMeta(i);
                            TableItem item = this.getTableItem(valueMeta.getName(), true);
                            item.setText(1, valueMeta.getName());
                            item.setText(2, ValueMetaFactory.getValueMetaName((int)valueMeta.getType()));
                            item.setText(3, Const.NVL((String)valueMeta.getConversionMask(), (String)""));
                            item.setText(5, valueMeta.getLength() >= 0 ? Integer.toString(valueMeta.getLength()) : "");
                            item.setText(6, valueMeta.getPrecision() >= 0 ? Integer.toString(valueMeta.getPrecision()) : "");
                            item.setText(7, Const.NVL((String)valueMeta.getCurrencySymbol(), (String)""));
                            item.setText(8, Const.NVL((String)valueMeta.getDecimalSymbol(), (String)""));
                            item.setText(9, Const.NVL((String)valueMeta.getGroupingSymbol(), (String)""));
                            item.setText(12, Const.NVL((String)ValueMetaString.getTrimTypeDesc((int)valueMeta.getTrimType()), (String)""));
                        }
                    }
                }
                catch (HopPluginException | HopTransformException throwable) {
                    // empty catch block
                }
                this.wFields.removeEmptyRows();
                this.wFields.setRowNums();
                this.wFields.optWidth(true);
            }
        }
    }

    public void setFlags() {
        boolean accept = this.wAccFilenames.getSelection();
        this.wlPassThruFields.setEnabled(accept);
        this.wPassThruFields.setEnabled(accept);
        if (!this.wAccFilenames.getSelection()) {
            this.wPassThruFields.setSelection(false);
        }
        this.wlAccField.setEnabled(accept);
        this.wAccField.setEnabled(accept);
        this.wlAccTransform.setEnabled(accept);
        this.wAccTransform.setEnabled(accept);
        this.wlFilename.setEnabled(!accept);
        this.wbbFilename.setEnabled(!accept);
        this.wbdFilename.setEnabled(!accept);
        this.wbeFilename.setEnabled(!accept);
        this.wbaFilename.setEnabled(!accept);
        this.wFilename.setEnabled(!accept);
        this.wlFilenameList.setEnabled(!accept);
        this.wFilenameList.setEnabled(!accept);
        this.wlFilemask.setEnabled(!accept);
        this.wFilemask.setEnabled(!accept);
        this.wbShowFiles.setEnabled(!accept);
        this.wFirst.setEnabled(!accept);
        this.wFirstHeader.setEnabled(!accept);
        this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wlInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wlRownumByFileField.setEnabled(this.wInclRownum.getSelection());
        this.wRownumByFile.setEnabled(this.wInclRownum.getSelection());
        this.wlSkipErrorLines.setEnabled(this.wErrorIgnored.getSelection());
        this.wSkipBadFiles.setEnabled(this.wErrorIgnored.getSelection());
        this.wBadFileField.setEnabled(this.wErrorIgnored.getSelection() && this.wSkipBadFiles.getSelection());
        this.wBadFileMessageField.setEnabled(this.wErrorIgnored.getSelection() && this.wSkipBadFiles.getSelection());
        this.wSkipErrorLines.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorCount.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorCount.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorFields.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorFields.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorText.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorText.setEnabled(this.wErrorIgnored.getSelection());
        this.wlWarnDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wWarnDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlWarnExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wWarnExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbWarnDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlErrorExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wErrorExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbErrorDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlLineNrExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wLineNrExt.setEnabled(this.wErrorIgnored.getSelection());
        this.wbbLineNrDestDir.setEnabled(this.wErrorIgnored.getSelection());
        this.wlNrHeader.setEnabled(this.wHeader.getSelection());
        this.wNrHeader.setEnabled(this.wHeader.getSelection());
        this.wlNrFooter.setEnabled(this.wFooter.getSelection());
        this.wNrFooter.setEnabled(this.wFooter.getSelection());
        this.wlNrWraps.setEnabled(this.wWraps.getSelection());
        this.wNrWraps.setEnabled(this.wWraps.getSelection());
        this.wlNrLinesPerPage.setEnabled(this.wLayoutPaged.getSelection());
        this.wNrLinesPerPage.setEnabled(this.wLayoutPaged.getSelection());
        this.wlNrLinesDocHeader.setEnabled(this.wLayoutPaged.getSelection());
        this.wNrLinesDocHeader.setEnabled(this.wLayoutPaged.getSelection());
    }

    public void getData(TextFileInputMeta meta) {
        this.getData(meta, true, true, null);
    }

    public void getData(TextFileInputMeta meta, boolean copyTransformName, boolean reloadAllFields, List<String> newFieldNames) {
        int i;
        if (copyTransformName) {
            this.wTransformName.setText(this.transformName);
        }
        this.wAccFilenames.setSelection(meta.inputFiles.acceptingFilenames);
        this.wPassThruFields.setSelection(meta.inputFiles.passingThruFields);
        if (meta.inputFiles.acceptingField != null) {
            this.wAccField.setText(meta.inputFiles.acceptingField);
        }
        if (meta.getAcceptingTransform() != null) {
            this.wAccTransform.setText(meta.getAcceptingTransform().getName());
        }
        this.wSchemaDefinition.setText(Const.NVL((String)meta.getSchemaDefinition(), (String)""));
        if (meta.getFileName() != null) {
            this.wFilenameList.removeAll();
            for (i = 0; i < meta.getFileName().length; ++i) {
                this.wFilenameList.add(new String[]{meta.getFileName()[i], meta.inputFiles.fileMask[i], meta.inputFiles.excludeFileMask[i], meta.getRequiredFilesDesc(meta.inputFiles.fileRequired[i]), meta.getRequiredFilesDesc(meta.inputFiles.includeSubFolders[i])});
            }
            this.wFilenameList.removeEmptyRows();
            this.wFilenameList.setRowNums();
            this.wFilenameList.optWidth(true);
        }
        if (meta.content.fileType != null) {
            this.wFiletype.setText(meta.content.fileType);
        }
        if (meta.content.separator != null) {
            this.wSeparator.setText(meta.content.separator);
        }
        if (meta.content.enclosure != null) {
            this.wEnclosure.setText(meta.content.enclosure);
        }
        if (meta.content.escapeCharacter != null) {
            this.wEscape.setText(meta.content.escapeCharacter);
        }
        this.wHeader.setSelection(meta.content.header);
        this.wNrHeader.setText("" + meta.content.nrHeaderLines);
        this.wFooter.setSelection(meta.content.footer);
        this.wNrFooter.setText("" + meta.content.nrFooterLines);
        this.wWraps.setSelection(meta.content.lineWrapped);
        this.wNrWraps.setText("" + meta.content.nrWraps);
        this.wLayoutPaged.setSelection(meta.content.layoutPaged);
        this.wNrLinesPerPage.setText("" + meta.content.nrLinesPerPage);
        this.wNrLinesDocHeader.setText("" + meta.content.nrLinesDocHeader);
        if (meta.content.fileCompression != null) {
            this.wCompression.setText(meta.content.fileCompression);
        }
        this.wNoempty.setSelection(meta.content.noEmptyLines);
        this.wInclFilename.setSelection(meta.content.includeFilename);
        this.wInclRownum.setSelection(meta.content.includeRowNumber);
        this.wRownumByFile.setSelection(meta.content.rowNumberByFile);
        this.wDateLenient.setSelection(meta.content.dateFormatLenient);
        this.wAddResult.setSelection(meta.inputFiles.isaddresult);
        if (meta.content.filenameField != null) {
            this.wInclFilenameField.setText(meta.content.filenameField);
        }
        if (meta.content.rowNumberField != null) {
            this.wInclRownumField.setText(meta.content.rowNumberField);
        }
        if (meta.content.fileFormat != null) {
            this.wFormat.setText(meta.content.fileFormat);
        }
        if (meta.content.length != null) {
            this.wLength.setText(meta.content.length);
        }
        this.wLimit.setText("" + meta.content.rowLimit);
        this.logDebug("getting fields info...");
        this.getFieldsData(meta, false, reloadAllFields, newFieldNames);
        if (meta.getEncoding() != null) {
            this.wEncoding.setText(meta.getEncoding());
        }
        this.wErrorIgnored.setSelection(meta.errorHandling.errorIgnored);
        this.wSkipBadFiles.setSelection(meta.errorHandling.skipBadFiles);
        this.wSkipErrorLines.setSelection(meta.isErrorLineSkipped());
        if (meta.errorHandling.fileErrorField != null) {
            this.wBadFileField.setText(meta.errorHandling.fileErrorField);
        }
        if (meta.errorHandling.fileErrorMessageField != null) {
            this.wBadFileMessageField.setText(meta.errorHandling.fileErrorMessageField);
        }
        if (meta.getErrorCountField() != null) {
            this.wErrorCount.setText(meta.getErrorCountField());
        }
        if (meta.getErrorFieldsField() != null) {
            this.wErrorFields.setText(meta.getErrorFieldsField());
        }
        if (meta.getErrorTextField() != null) {
            this.wErrorText.setText(meta.getErrorTextField());
        }
        if (meta.errorHandling.warningFilesDestinationDirectory != null) {
            this.wWarnDestDir.setText(meta.errorHandling.warningFilesDestinationDirectory);
        }
        if (meta.errorHandling.warningFilesExtension != null) {
            this.wWarnExt.setText(meta.errorHandling.warningFilesExtension);
        }
        if (meta.errorHandling.errorFilesDestinationDirectory != null) {
            this.wErrorDestDir.setText(meta.errorHandling.errorFilesDestinationDirectory);
        }
        if (meta.errorHandling.errorFilesExtension != null) {
            this.wErrorExt.setText(meta.errorHandling.errorFilesExtension);
        }
        if (meta.errorHandling.lineNumberFilesDestinationDirectory != null) {
            this.wLineNrDestDir.setText(meta.errorHandling.lineNumberFilesDestinationDirectory);
        }
        if (meta.errorHandling.lineNumberFilesExtension != null) {
            this.wLineNrExt.setText(meta.errorHandling.lineNumberFilesExtension);
        }
        for (i = 0; i < meta.getFilter().length; ++i) {
            TableItem item = this.wFilter.table.getItem(i);
            TextFileFilter filter = meta.getFilter()[i];
            if (filter.getFilterString() != null) {
                item.setText(1, filter.getFilterString());
            }
            if (filter.getFilterPosition() >= 0) {
                item.setText(2, "" + filter.getFilterPosition());
            }
            item.setText(3, filter.isFilterLastLine() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
            item.setText(4, filter.isFilterPositive() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
        }
        this.wDateLocale.setText(meta.content.dateFormatLocale.toString());
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wFilter.removeEmptyRows();
        this.wFilter.setRowNums();
        this.wFilter.optWidth(true);
        if (meta.additionalOutputFields.shortFilenameField != null) {
            this.wShortFileFieldName.setText(meta.additionalOutputFields.shortFilenameField);
        }
        if (meta.additionalOutputFields.pathField != null) {
            this.wPathFieldName.setText(meta.additionalOutputFields.pathField);
        }
        if (meta.additionalOutputFields.hiddenField != null) {
            this.wIsHiddenName.setText(meta.additionalOutputFields.hiddenField);
        }
        if (meta.additionalOutputFields.lastModificationField != null) {
            this.wLastModificationTimeName.setText(meta.additionalOutputFields.lastModificationField);
        }
        if (meta.additionalOutputFields.uriField != null) {
            this.wUriName.setText(meta.additionalOutputFields.uriField);
        }
        if (meta.additionalOutputFields.rootUriField != null) {
            this.wRootUriName.setText(meta.additionalOutputFields.rootUriField);
        }
        if (meta.additionalOutputFields.extensionField != null) {
            this.wExtensionFieldName.setText(meta.additionalOutputFields.extensionField);
        }
        if (meta.additionalOutputFields.sizeField != null) {
            this.wSizeFieldName.setText(meta.additionalOutputFields.sizeField);
        }
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void getFieldsData(TextFileInputMeta in, boolean insertAtTop, boolean reloadAllFields, List<String> newFieldNames) {
        ArrayList lowerCaseNewFieldNames = newFieldNames == null ? new ArrayList() : newFieldNames;
        for (int i = 0; i < in.inputFields.length; ++i) {
            String rep;
            BaseFileField field = in.inputFields[i];
            TableItem item = insertAtTop ? new TableItem(this.wFields.table, 0, i) : this.getTableItem(field.getName(), true);
            if (!reloadAllFields && !lowerCaseNewFieldNames.contains(field.getName().toLowerCase())) continue;
            item.setText(1, Const.NVL((String)field.getName(), (String)""));
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String position = "" + field.getPosition();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String def = field.getNullString();
            String ifNull = field.getIfNullValue();
            String trim = field.getTrimTypeDesc();
            String string = rep = field.isRepeated() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
            if (type != null) {
                item.setText(2, type);
            }
            if (format != null) {
                item.setText(3, format);
            }
            if (position != null && !"-1".equals(position)) {
                item.setText(4, position);
            }
            if (length != null && !"-1".equals(length)) {
                item.setText(5, length);
            }
            if (prec != null && !"-1".equals(prec)) {
                item.setText(6, prec);
            }
            if (curr != null) {
                item.setText(7, curr);
            }
            if (decim != null) {
                item.setText(8, decim);
            }
            if (group != null) {
                item.setText(9, group);
            }
            if (def != null) {
                item.setText(10, def);
            }
            if (ifNull != null) {
                item.setText(11, ifNull);
            }
            if (trim != null) {
                item.setText(12, trim);
            }
            if (rep == null) continue;
            item.setText(13, rep);
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input, false);
        this.dispose();
    }

    private void getInfo(TextFileInputMeta meta, boolean preview) {
        int i;
        this.transformName = this.wTransformName.getText();
        meta.inputFiles.acceptingFilenames = this.wAccFilenames.getSelection();
        meta.inputFiles.passingThruFields = this.wPassThruFields.getSelection();
        meta.inputFiles.acceptingField = this.wAccField.getText();
        meta.inputFiles.acceptingTransformName = this.wAccTransform.getText();
        meta.setAcceptingTransform(this.pipelineMeta.findTransform(this.wAccTransform.getText()));
        meta.content.fileType = this.wFiletype.getText();
        meta.content.fileFormat = preview ? "mixed" : this.wFormat.getText();
        meta.content.separator = this.wSeparator.getText();
        meta.content.enclosure = this.wEnclosure.getText();
        meta.content.escapeCharacter = this.wEscape.getText();
        meta.content.rowLimit = Const.toLong((String)this.wLimit.getText(), (long)0L);
        meta.content.filenameField = this.wInclFilenameField.getText();
        meta.content.rowNumberField = this.wInclRownumField.getText();
        meta.inputFiles.isaddresult = this.wAddResult.getSelection();
        meta.content.includeFilename = this.wInclFilename.getSelection();
        meta.content.includeRowNumber = this.wInclRownum.getSelection();
        meta.content.rowNumberByFile = this.wRownumByFile.getSelection();
        meta.content.header = this.wHeader.getSelection();
        meta.content.nrHeaderLines = Const.toInt((String)this.wNrHeader.getText(), (int)1);
        meta.content.footer = this.wFooter.getSelection();
        meta.content.nrFooterLines = Const.toInt((String)this.wNrFooter.getText(), (int)1);
        meta.content.lineWrapped = this.wWraps.getSelection();
        meta.content.nrWraps = Const.toInt((String)this.wNrWraps.getText(), (int)1);
        meta.content.layoutPaged = this.wLayoutPaged.getSelection();
        meta.content.nrLinesPerPage = Const.toInt((String)this.wNrLinesPerPage.getText(), (int)80);
        meta.content.nrLinesDocHeader = Const.toInt((String)this.wNrLinesDocHeader.getText(), (int)0);
        meta.content.fileCompression = this.wCompression.getText();
        meta.content.dateFormatLenient = this.wDateLenient.getSelection();
        meta.content.noEmptyLines = this.wNoempty.getSelection();
        meta.content.encoding = this.wEncoding.getText();
        meta.content.length = this.wLength.getText();
        int nrfiles = this.wFilenameList.getItemCount();
        int nrFields = this.wFields.nrNonEmpty();
        int nrfilters = this.wFilter.nrNonEmpty();
        meta.allocate(nrfiles, nrFields, nrfilters);
        meta.setFileName(this.wFilenameList.getItems(0));
        meta.setSchemaDefinition(this.wSchemaDefinition.getText());
        meta.inputFiles.fileMask = this.wFilenameList.getItems(1);
        meta.inputFiles.excludeFileMask = this.wFilenameList.getItems(2);
        meta.inputFiles_fileRequired(this.wFilenameList.getItems(3));
        meta.inputFiles_includeSubFolders(this.wFilenameList.getItems(4));
        for (i = 0; i < nrFields; ++i) {
            BaseFileField field = new BaseFileField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setType(ValueMetaFactory.getIdForValueMeta((String)item.getText(2)));
            field.setFormat(item.getText(3));
            field.setPosition(Const.toInt((String)item.getText(4), (int)-1));
            field.setLength(Const.toInt((String)item.getText(5), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(6), (int)-1));
            field.setCurrencySymbol(item.getText(7));
            field.setDecimalSymbol(item.getText(8));
            field.setGroupSymbol(item.getText(9));
            field.setNullString(item.getText(10));
            field.setIfNullValue(item.getText(11));
            field.setTrimType(ValueMetaString.getTrimTypeByDesc((String)item.getText(12)));
            field.setRepeated(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(13)));
            meta.inputFields[i] = field;
        }
        for (i = 0; i < nrfilters; ++i) {
            TextFileFilter filter;
            TableItem item = this.wFilter.getNonEmpty(i);
            meta.getFilter()[i] = filter = new TextFileFilter();
            filter.setFilterString(item.getText(1));
            filter.setFilterPosition(Const.toInt((String)item.getText(2), (int)-1));
            filter.setFilterLastLine(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(3)));
            filter.setFilterPositive(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(4)));
        }
        meta.errorHandling.errorIgnored = this.wErrorIgnored.getSelection();
        meta.errorHandling.skipBadFiles = this.wSkipBadFiles.getSelection();
        meta.errorHandling.fileErrorField = this.wBadFileField.getText();
        meta.errorHandling.fileErrorMessageField = this.wBadFileMessageField.getText();
        meta.setErrorLineSkipped(this.wSkipErrorLines.getSelection());
        meta.setErrorCountField(this.wErrorCount.getText());
        meta.setErrorFieldsField(this.wErrorFields.getText());
        meta.setErrorTextField(this.wErrorText.getText());
        meta.errorHandling.warningFilesDestinationDirectory = this.wWarnDestDir.getText();
        meta.errorHandling.warningFilesExtension = this.wWarnExt.getText();
        meta.errorHandling.errorFilesDestinationDirectory = this.wErrorDestDir.getText();
        meta.errorHandling.errorFilesExtension = this.wErrorExt.getText();
        meta.errorHandling.lineNumberFilesDestinationDirectory = this.wLineNrDestDir.getText();
        meta.errorHandling.lineNumberFilesExtension = this.wLineNrExt.getText();
        Locale locale = EnvUtil.createLocale((String)this.wDateLocale.getText());
        meta.content.dateFormatLocale = !locale.equals(Locale.getDefault()) ? locale : Locale.getDefault();
        meta.additionalOutputFields.shortFilenameField = this.wShortFileFieldName.getText();
        meta.additionalOutputFields.pathField = this.wPathFieldName.getText();
        meta.additionalOutputFields.hiddenField = this.wIsHiddenName.getText();
        meta.additionalOutputFields.lastModificationField = this.wLastModificationTimeName.getText();
        meta.additionalOutputFields.uriField = this.wUriName.getText();
        meta.additionalOutputFields.rootUriField = this.wRootUriName.getText();
        meta.additionalOutputFields.extensionField = this.wExtensionFieldName.getText();
        meta.additionalOutputFields.sizeField = this.wSizeFieldName.getText();
    }

    private void get() {
        if (this.wFiletype.getText().equalsIgnoreCase("CSV")) {
            this.getFields();
        }
    }

    public String loadFieldsImpl(TextFileInputMeta meta, int samples) {
        return this.loadFieldsImpl(meta, samples);
    }

    public String massageFieldName(String fieldName) {
        String massagedFieldName = fieldName;
        massagedFieldName = Const.replace((String)massagedFieldName, (String)" ", (String)"_");
        massagedFieldName = Const.replace((String)massagedFieldName, (String)"-", (String)"_");
        return massagedFieldName;
    }

    public String[] getFieldNames(TextFileInputMeta meta) {
        return this.getFieldNames(meta);
    }

    public static int guessPrecision(double d) {
        int precision;
        long frac = Math.round((d - Math.floor(d)) * 1.0E10);
        for (precision = 10; precision >= 0 && frac % 10L == 0L; --precision) {
            frac /= 10L;
        }
        return ++precision;
    }

    public static int guessIntLength(double d) {
        double flr = Math.floor(d);
        int len = 1;
        while (flr > 9.0) {
            flr /= 10.0;
            flr = Math.floor(flr);
            ++len;
        }
        return len;
    }

    private void preview() {
        TextFileInputMeta oneMeta = new TextFileInputMeta();
        this.getInfo(oneMeta, true);
        if (oneMeta.inputFiles.acceptingFilenames) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Dialog.SpecifyASampleFile.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Dialog.SpecifyASampleFile.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"TextFileInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TextFileInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    private void first(boolean skipHeaders) {
        TextFileInputMeta info = new TextFileInputMeta();
        this.getInfo(info, true);
        try {
            if (info.getFileInputList(this.variables).nrOfFiles() > 0) {
                String lineText;
                String shellText = BaseMessages.getString(PKG, (String)"TextFileInputDialog.LinesToView.DialogTitle", (String[])new String[0]);
                EnterNumberDialog end = new EnterNumberDialog(this.shell, 100, shellText, lineText = BaseMessages.getString(PKG, (String)"TextFileInputDialog.LinesToView.DialogMessage", (String[])new String[0]));
                int nrLines = end.open();
                if (nrLines >= 0) {
                    List<String> linesList = this.getFirst(nrLines, skipHeaders);
                    if (linesList != null && linesList.size() > 0) {
                        Object firstlines = "";
                        for (String aLinesList : linesList) {
                            firstlines = (String)firstlines + aLinesList + Const.CR;
                        }
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"TextFileInputDialog.ContentOfFirstFile.DialogTitle", (String[])new String[0]), nrLines == 0 ? BaseMessages.getString(PKG, (String)"TextFileInputDialog.ContentOfFirstFile.AllLines.DialogMessage", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"TextFileInputDialog.ContentOfFirstFile.NLines.DialogMessage", (String[])new String[]{"" + nrLines}), (String)firstlines, true);
                        etd.setReadOnly();
                        etd.open();
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"TextFileInputDialog.UnableToReadLines.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.UnableToReadLines.DialogTitle", (String[])new String[0]));
                        mb.open();
                    }
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"TextFileInputDialog.NoValidFile.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (HopException e) {
            this.displayErrorDialog(e, "TextFileInputDialog.ErrorGettingData.DialogMessage");
        }
    }

    private void displayErrorDialog(HopException e, String messageKey) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)messageKey, (String[])new String[0]), (Exception)((Object)e));
    }

    private List<String> getFirst(int nrlines, boolean skipHeaders) throws HopException {
        TextFileInputMeta meta = new TextFileInputMeta();
        this.getInfo(meta, true);
        FileInputList textFileList = meta.getFileInputList(this.variables);
        CompressionInputStream f = null;
        StringBuilder lineStringBuilder = new StringBuilder(256);
        int fileFormatType = meta.getFileFormatTypeNr();
        ArrayList<String> retval = new ArrayList<String>();
        if (textFileList.nrOfFiles() > 0) {
            FileObject file = textFileList.getFile(0);
            try {
                InputStream fi = HopVfs.getInputStream((FileObject)file);
                ICompressionProvider provider = CompressionProviderFactory.getInstance().createCompressionProviderInstance(meta.content.fileCompression);
                f = provider.createInputStream(fi);
                InputStreamReader reader = meta.getEncoding() != null && meta.getEncoding().length() > 0 ? new InputStreamReader((InputStream)f, meta.getEncoding()) : new InputStreamReader((InputStream)f);
                EncodingType encodingType = EncodingType.guessEncodingType((String)reader.getEncoding());
                int linenr = 0;
                int maxnr = nrlines + (meta.content.header ? meta.content.nrHeaderLines : 0);
                if (skipHeaders) {
                    int skipped;
                    String line;
                    if (meta.content.layoutPaged && meta.content.nrLinesDocHeader > 0) {
                        line = TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)lineStringBuilder);
                        for (skipped = 0; line != null && skipped < meta.content.nrLinesDocHeader - 1; ++skipped) {
                            line = TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)lineStringBuilder);
                        }
                    }
                    if (meta.content.header && meta.content.nrHeaderLines > 0) {
                        line = TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)lineStringBuilder);
                        for (skipped = 0; line != null && skipped < meta.content.nrHeaderLines - 1; ++skipped) {
                            line = TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)lineStringBuilder);
                        }
                    }
                }
                String line = TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)lineStringBuilder);
                while (line != null && (linenr < maxnr || nrlines == 0)) {
                    retval.add(line);
                    ++linenr;
                    line = TextFileLineUtil.getLine((ILogChannel)this.log, (InputStreamReader)reader, (EncodingType)encodingType, (int)fileFormatType, (StringBuilder)lineStringBuilder);
                }
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"TextFileInputDialog.Exception.ErrorGettingFirstLines", (String[])new String[]{"" + nrlines, file.getName().getURI()}), (Throwable)e);
            }
            finally {
                try {
                    if (f != null) {
                        f.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return retval;
    }

    private Vector<ITextFileInputField> getFields(TextFileInputMeta info, List<String> rows) {
        Vector<ITextFileInputField> fields = new Vector<ITextFileInputField>();
        int maxsize = 0;
        for (String row : rows) {
            int len = row.length();
            if (len <= maxsize) continue;
            maxsize = len;
        }
        int prevEnd = 0;
        int dummynr = 1;
        for (int i = 0; i < info.inputFields.length; ++i) {
            BaseFileField field;
            BaseFileField f = info.inputFields[i];
            if (f.getPosition() != prevEnd) {
                field = new BaseFileField("Dummy" + dummynr, prevEnd, f.getPosition() - prevEnd);
                field.setIgnored(true);
                fields.add((ITextFileInputField)field);
                ++dummynr;
            }
            field = new BaseFileField(f.getName(), f.getPosition(), f.getLength());
            field.setType(f.getType());
            field.setIgnored(false);
            field.setFormat(f.getFormat());
            field.setPrecision(f.getPrecision());
            field.setTrimType(f.getTrimType());
            field.setDecimalSymbol(f.getDecimalSymbol());
            field.setGroupSymbol(f.getGroupSymbol());
            field.setCurrencySymbol(f.getCurrencySymbol());
            field.setRepeated(f.isRepeated());
            field.setNullString(f.getNullString());
            fields.add((ITextFileInputField)field);
            prevEnd = field.getPosition() + field.getLength();
        }
        if (info.inputFields.length == 0) {
            BaseFileField field = new BaseFileField("Field1", 0, maxsize);
            fields.add((ITextFileInputField)field);
        } else {
            int len;
            BaseFileField f = info.inputFields[info.inputFields.length - 1];
            int pos = f.getPosition();
            if (pos + (len = f.getLength()) < maxsize) {
                BaseFileField field = new BaseFileField("Dummy" + dummynr, pos + len, maxsize - pos - len);
                field.setIgnored(true);
                fields.add((ITextFileInputField)field);
            }
        }
        Collections.sort(fields);
        return fields;
    }

    public void setMinimalWidth() {
        int i;
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(5, "");
            item.setText(6, "");
            item.setText(12, ValueMetaString.getTrimTypeDesc((int)3));
            int type = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(3, "");
                    continue block6;
                }
                case 5: {
                    item.setText(3, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(3, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        for (i = 0; i < this.input.inputFields.length; ++i) {
            this.input.inputFields[i].setTrimType(3);
        }
        this.wFields.optWidth(true);
    }

    public void setMinimalWidth(TableView wFields) {
        this.wFields = wFields;
        this.setMinimalWidth();
    }

    private void addAdditionalFieldsTab() {
        CTabItem wAdditionalFieldsTab = new CTabItem(this.wTabFolder, 0);
        wAdditionalFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wAdditionalFieldsTab.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.AdditionalFieldsTab.TabTitle", (String[])new String[0]));
        Composite wAdditionalFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wAdditionalFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 3;
        fieldsLayout.marginHeight = 3;
        wAdditionalFieldsComp.setLayout((Layout)fieldsLayout);
        Label wlShortFileFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlShortFileFieldName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ShortFileFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlShortFileFieldName);
        FormData fdlShortFileFieldName = new FormData();
        fdlShortFileFieldName.left = new FormAttachment(0, 0);
        fdlShortFileFieldName.top = new FormAttachment(this.margin, this.margin);
        fdlShortFileFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlShortFileFieldName.setLayoutData((Object)fdlShortFileFieldName);
        this.wShortFileFieldName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wShortFileFieldName);
        this.wShortFileFieldName.addModifyListener(this.lsMod);
        FormData fdShortFileFieldName = new FormData();
        fdShortFileFieldName.left = new FormAttachment(this.middle, 0);
        fdShortFileFieldName.right = new FormAttachment(100, -this.margin);
        fdShortFileFieldName.top = new FormAttachment(this.margin, this.margin);
        this.wShortFileFieldName.setLayoutData((Object)fdShortFileFieldName);
        Label wlExtensionFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlExtensionFieldName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.ExtensionFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExtensionFieldName);
        FormData fdlExtensionFieldName = new FormData();
        fdlExtensionFieldName.left = new FormAttachment(0, 0);
        fdlExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        fdlExtensionFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlExtensionFieldName.setLayoutData((Object)fdlExtensionFieldName);
        this.wExtensionFieldName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wExtensionFieldName);
        this.wExtensionFieldName.addModifyListener(this.lsMod);
        FormData fdExtensionFieldName = new FormData();
        fdExtensionFieldName.left = new FormAttachment(this.middle, 0);
        fdExtensionFieldName.right = new FormAttachment(100, -this.margin);
        fdExtensionFieldName.top = new FormAttachment((Control)this.wShortFileFieldName, this.margin);
        this.wExtensionFieldName.setLayoutData((Object)fdExtensionFieldName);
        Label wlPathFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlPathFieldName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.PathFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPathFieldName);
        FormData fdlPathFieldName = new FormData();
        fdlPathFieldName.left = new FormAttachment(0, 0);
        fdlPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        fdlPathFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlPathFieldName.setLayoutData((Object)fdlPathFieldName);
        this.wPathFieldName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wPathFieldName);
        this.wPathFieldName.addModifyListener(this.lsMod);
        FormData fdPathFieldName = new FormData();
        fdPathFieldName.left = new FormAttachment(this.middle, 0);
        fdPathFieldName.right = new FormAttachment(100, -this.margin);
        fdPathFieldName.top = new FormAttachment((Control)this.wExtensionFieldName, this.margin);
        this.wPathFieldName.setLayoutData((Object)fdPathFieldName);
        Label wlSizeFieldName = new Label(wAdditionalFieldsComp, 131072);
        wlSizeFieldName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.SizeFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSizeFieldName);
        FormData fdlSizeFieldName = new FormData();
        fdlSizeFieldName.left = new FormAttachment(0, 0);
        fdlSizeFieldName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        fdlSizeFieldName.right = new FormAttachment(this.middle, -this.margin);
        wlSizeFieldName.setLayoutData((Object)fdlSizeFieldName);
        this.wSizeFieldName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wSizeFieldName);
        this.wSizeFieldName.addModifyListener(this.lsMod);
        FormData fdSizeFieldName = new FormData();
        fdSizeFieldName.left = new FormAttachment(this.middle, 0);
        fdSizeFieldName.right = new FormAttachment(100, -this.margin);
        fdSizeFieldName.top = new FormAttachment((Control)this.wPathFieldName, this.margin);
        this.wSizeFieldName.setLayoutData((Object)fdSizeFieldName);
        Label wlIsHiddenName = new Label(wAdditionalFieldsComp, 131072);
        wlIsHiddenName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.IsHiddenName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIsHiddenName);
        FormData fdlIsHiddenName = new FormData();
        fdlIsHiddenName.left = new FormAttachment(0, 0);
        fdlIsHiddenName.top = new FormAttachment((Control)this.wSizeFieldName, this.margin);
        fdlIsHiddenName.right = new FormAttachment(this.middle, -this.margin);
        wlIsHiddenName.setLayoutData((Object)fdlIsHiddenName);
        this.wIsHiddenName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wIsHiddenName);
        this.wIsHiddenName.addModifyListener(this.lsMod);
        FormData fdIsHiddenName = new FormData();
        fdIsHiddenName.left = new FormAttachment(this.middle, 0);
        fdIsHiddenName.right = new FormAttachment(100, -this.margin);
        fdIsHiddenName.top = new FormAttachment((Control)this.wSizeFieldName, this.margin);
        this.wIsHiddenName.setLayoutData((Object)fdIsHiddenName);
        Label wlLastModificationTimeName = new Label(wAdditionalFieldsComp, 131072);
        wlLastModificationTimeName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.LastModificationTimeName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLastModificationTimeName);
        FormData fdlLastModificationTimeName = new FormData();
        fdlLastModificationTimeName.left = new FormAttachment(0, 0);
        fdlLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        fdlLastModificationTimeName.right = new FormAttachment(this.middle, -this.margin);
        wlLastModificationTimeName.setLayoutData((Object)fdlLastModificationTimeName);
        this.wLastModificationTimeName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wLastModificationTimeName);
        this.wLastModificationTimeName.addModifyListener(this.lsMod);
        FormData fdLastModificationTimeName = new FormData();
        fdLastModificationTimeName.left = new FormAttachment(this.middle, 0);
        fdLastModificationTimeName.right = new FormAttachment(100, -this.margin);
        fdLastModificationTimeName.top = new FormAttachment((Control)this.wIsHiddenName, this.margin);
        this.wLastModificationTimeName.setLayoutData((Object)fdLastModificationTimeName);
        Label wlUriName = new Label(wAdditionalFieldsComp, 131072);
        wlUriName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.UriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUriName);
        FormData fdlUriName = new FormData();
        fdlUriName.left = new FormAttachment(0, 0);
        fdlUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        fdlUriName.right = new FormAttachment(this.middle, -this.margin);
        wlUriName.setLayoutData((Object)fdlUriName);
        this.wUriName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wUriName);
        this.wUriName.addModifyListener(this.lsMod);
        FormData fdUriName = new FormData();
        fdUriName.left = new FormAttachment(this.middle, 0);
        fdUriName.right = new FormAttachment(100, -this.margin);
        fdUriName.top = new FormAttachment((Control)this.wLastModificationTimeName, this.margin);
        this.wUriName.setLayoutData((Object)fdUriName);
        Label wlRootUriName = new Label(wAdditionalFieldsComp, 131072);
        wlRootUriName.setText(BaseMessages.getString(PKG, (String)"TextFileInputDialog.RootUriName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRootUriName);
        FormData fdlRootUriName = new FormData();
        fdlRootUriName.left = new FormAttachment(0, 0);
        fdlRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        fdlRootUriName.right = new FormAttachment(this.middle, -this.margin);
        wlRootUriName.setLayoutData((Object)fdlRootUriName);
        this.wRootUriName = new TextVar(this.variables, wAdditionalFieldsComp, 18436);
        PropsUi.setLook((Widget)this.wRootUriName);
        this.wRootUriName.addModifyListener(this.lsMod);
        FormData fdRootUriName = new FormData();
        fdRootUriName.left = new FormAttachment(this.middle, 0);
        fdRootUriName.right = new FormAttachment(100, -this.margin);
        fdRootUriName.top = new FormAttachment((Control)this.wUriName, this.margin);
        this.wRootUriName.setLayoutData((Object)fdRootUriName);
        FormData fdAdditionalFieldsComp = new FormData();
        fdAdditionalFieldsComp.left = new FormAttachment(0, 0);
        fdAdditionalFieldsComp.top = new FormAttachment(0, 0);
        fdAdditionalFieldsComp.right = new FormAttachment(100, 0);
        fdAdditionalFieldsComp.bottom = new FormAttachment(100, 0);
        wAdditionalFieldsComp.setLayoutData((Object)fdAdditionalFieldsComp);
        wAdditionalFieldsComp.layout();
        wAdditionalFieldsTab.setControl((Control)wAdditionalFieldsComp);
    }

    public TableView getFieldsTable() {
        return this.wFields;
    }

    public Shell getShell() {
        return this.shell;
    }

    public TextFileInputMeta getNewMetaInstance() {
        return new TextFileInputMeta();
    }

    public void populateMeta(TextFileInputMeta inputMeta) {
        this.getInfo(inputMeta, false);
    }

    public ICsvInputAwareImportProgressDialog getCsvImportProgressDialog(ICsvInputAwareMeta meta, int samples, InputStreamReader reader) {
        return new TextFileCSVImportProgressDialog(this.getShell(), this.variables, (TextFileInputMeta)meta, this.pipelineMeta, reader, samples, true);
    }

    public LogChannel getLogChannel() {
        return this.log;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    public InputStream getInputStream(ICsvInputAwareMeta meta) {
        CompressionInputStream inputStream = null;
        try {
            FileObject fileObject = meta.getHeaderFileObject(this.variables);
            InputStream fileInputStream = HopVfs.getInputStream((FileObject)fileObject);
            ICompressionProvider provider = CompressionProviderFactory.getInstance().createCompressionProviderInstance(((TextFileInputMeta)meta).content.fileCompression);
            inputStream = provider.createInputStream(fileInputStream);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString((String)"FileInputDialog.ErrorGettingFileDesc.DialogMessage"), e);
        }
        return inputStream;
    }
}

