/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.stub.metrics.ConnectionErrorCountInterceptor;
import com.google.cloud.bigtable.stats.StatsRecorderWrapperForConnection;
import com.google.cloud.bigtable.stats.StatsWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.grpc.ClientInterceptor;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@InternalApi(value="For internal use only")
public class ErrorCountPerConnectionMetricTracker
implements Runnable {
    private static final Integer PER_CONNECTION_ERROR_COUNT_PERIOD_SECONDS = 60;
    private final Set<ConnectionErrorCountInterceptor> connectionErrorCountInterceptors;
    private final Object interceptorsLock = new Object();
    private StatsRecorderWrapperForConnection statsRecorderWrapperForConnection;

    @VisibleForTesting
    void setStatsRecorderWrapperForConnection(StatsRecorderWrapperForConnection statsRecorderWrapperForConnection) {
        this.statsRecorderWrapperForConnection = statsRecorderWrapperForConnection;
    }

    public ErrorCountPerConnectionMetricTracker(ImmutableMap<String, String> builtinAttributes) {
        this.connectionErrorCountInterceptors = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
        this.statsRecorderWrapperForConnection = StatsWrapper.createRecorderForConnection(builtinAttributes);
    }

    public void startConnectionErrorCountTracker(ScheduledExecutorService scheduler) {
        scheduler.scheduleAtFixedRate(this, 0L, PER_CONNECTION_ERROR_COUNT_PERIOD_SECONDS.intValue(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInterceptor getInterceptor() {
        ConnectionErrorCountInterceptor connectionErrorCountInterceptor = new ConnectionErrorCountInterceptor();
        Object object = this.interceptorsLock;
        synchronized (object) {
            this.connectionErrorCountInterceptors.add(connectionErrorCountInterceptor);
        }
        return connectionErrorCountInterceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.interceptorsLock;
        synchronized (object) {
            for (ConnectionErrorCountInterceptor interceptor : this.connectionErrorCountInterceptors) {
                long errors = interceptor.getAndResetNumOfErrors();
                long successes = interceptor.getAndResetNumOfSuccesses();
                if (errors <= 0L && successes <= 0L) continue;
                this.statsRecorderWrapperForConnection.putAndRecordPerConnectionErrorCount(errors);
            }
        }
    }
}

