/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.construction.BeamUrns;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DisplayDataTranslation {
    public static final @UnknownKeyFor @NonNull @Initialized String LABELLED = "beam:display_data:labelled:v1";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized DisplayData.Item, @UnknownKeyFor @NonNull @Initialized ByteString>> WELL_KNOWN_URN_TRANSLATORS;

    public static @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized RunnerApi.DisplayData> toProto(@UnknownKeyFor @NonNull @Initialized DisplayData displayData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DisplayData.Item item : displayData.items()) {
            String urn;
            Function<DisplayData.Item, ByteString> translator = WELL_KNOWN_URN_TRANSLATORS.get(item.getKey());
            if (translator != null) {
                urn = item.getKey();
            } else {
                urn = LABELLED;
                translator = DisplayDataTranslation::translate;
            }
            builder.add((Object)RunnerApi.DisplayData.newBuilder().setUrn(urn).setPayload(translator.apply(item)).build());
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized ByteString translate(@UnknownKeyFor @NonNull @Initialized DisplayData.Item item) {
        Object valueObj;
        String label = item.getLabel() == null ? item.getKey() : item.getLabel();
        String namespace = item.getNamespace() == null ? "" : item.getNamespace().getName();
        RunnerApi.LabelledPayload.Builder builder = RunnerApi.LabelledPayload.newBuilder().setKey(item.getKey()).setLabel(label).setNamespace(namespace);
        Object object = valueObj = item.getValue() == null ? item.getShortValue() : item.getValue();
        if (valueObj instanceof Boolean) {
            builder.setBoolValue((Boolean)valueObj);
        } else if (valueObj instanceof Integer || valueObj instanceof Long) {
            builder.setIntValue((Long)valueObj);
        } else if (valueObj instanceof Number) {
            builder.setDoubleValue(((Number)valueObj).doubleValue());
        } else {
            builder.setStringValue(String.valueOf(valueObj));
        }
        return builder.build().toByteString();
    }

    static {
        Preconditions.checkState((boolean)LABELLED.equals(BeamUrns.getUrn(RunnerApi.StandardDisplayData.DisplayData.LABELLED)));
        WELL_KNOWN_URN_TRANSLATORS = ImmutableMap.of((Object)LABELLED, DisplayDataTranslation::translate);
    }
}

