/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts;

import java.util.Collection;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.ServerCall;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal.AltsInternalContext;
import org.apache.beam.vendor.grpc.v1p60p1.io.grpc.alts.internal.AltsProtocolNegotiator;

public final class AuthorizationUtil {
    private AuthorizationUtil() {
    }

    public static Status clientAuthorizationCheck(ServerCall<?, ?> call, Collection<String> expectedServiceAccounts) {
        AltsInternalContext altsContext = (AltsInternalContext)call.getAttributes().get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        if (altsContext == null) {
            return Status.PERMISSION_DENIED.withDescription("Peer ALTS AuthContext not found");
        }
        if (expectedServiceAccounts.contains(altsContext.getPeerServiceAccount())) {
            return Status.OK;
        }
        return Status.PERMISSION_DENIED.withDescription("Client " + altsContext.getPeerServiceAccount() + " is not authorized");
    }
}

