/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.DecodeMode;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.GrpcStruct;
import com.google.cloud.spanner.GrpcValueIterator;
import com.google.cloud.spanner.ProtobufResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Value;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

@VisibleForTesting
class GrpcResultSet
extends AbstractResultSet<List<Object>>
implements ProtobufResultSet {
    private final GrpcValueIterator iterator;
    private final AbstractResultSet.Listener listener;
    private final DecodeMode decodeMode;
    private ResultSetMetadata metadata;
    private GrpcStruct currRow;
    private SpannerException error;
    private ResultSetStats statistics;
    private boolean closed;

    GrpcResultSet(AbstractResultSet.CloseableIterator<PartialResultSet> iterator, AbstractResultSet.Listener listener) {
        this(iterator, listener, DecodeMode.DIRECT);
    }

    GrpcResultSet(AbstractResultSet.CloseableIterator<PartialResultSet> iterator, AbstractResultSet.Listener listener, DecodeMode decodeMode) {
        this.iterator = new GrpcValueIterator(iterator);
        this.listener = listener;
        this.decodeMode = decodeMode;
    }

    @Override
    public boolean canGetProtobufValue(int columnIndex) {
        return !this.closed && this.currRow != null && this.currRow.canGetProtoValue(columnIndex);
    }

    @Override
    public Value getProtobufValue(int columnIndex) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet is closed");
        Preconditions.checkState((this.currRow != null ? 1 : 0) != 0, (Object)"next() call required");
        return this.currRow.getProtoValueInternal(columnIndex);
    }

    @Override
    protected GrpcStruct currRow() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"ResultSet is closed");
        Preconditions.checkState((this.currRow != null ? 1 : 0) != 0, (Object)"next() call required");
        return this.currRow;
    }

    @Override
    public boolean next() throws SpannerException {
        if (this.error != null) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)((Object)this.error));
        }
        try {
            boolean hasNext;
            if (this.currRow == null) {
                this.metadata = this.iterator.getMetadata();
                if (this.metadata.hasTransaction()) {
                    this.listener.onTransactionMetadata(this.metadata.getTransaction(), this.iterator.isWithBeginTransaction());
                } else if (this.iterator.isWithBeginTransaction()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "The statement did not return a transaction even though one was requested");
                }
                this.currRow = new GrpcStruct(this.iterator.type(), new ArrayList<Object>(), this.decodeMode);
            }
            if (!(hasNext = this.currRow.consumeRow((Iterator<Value>)((Object)this.iterator)))) {
                this.statistics = this.iterator.getStats();
            }
            return hasNext;
        }
        catch (Throwable t) {
            throw this.yieldError(SpannerExceptionFactory.asSpannerException(t), this.iterator.isWithBeginTransaction() && this.currRow == null);
        }
    }

    @Override
    @Nullable
    public ResultSetStats getStats() {
        return this.statistics;
    }

    @Override
    public ResultSetMetadata getMetadata() {
        Preconditions.checkState((this.metadata != null ? 1 : 0) != 0, (Object)"next() call required");
        return this.metadata;
    }

    @Override
    public void close() {
        this.listener.onDone(this.iterator.isWithBeginTransaction());
        this.iterator.close("ResultSet closed");
        this.closed = true;
    }

    @Override
    public Type getType() {
        Preconditions.checkState((this.currRow != null ? 1 : 0) != 0, (Object)"next() call required");
        return this.currRow.getType();
    }

    private SpannerException yieldError(SpannerException e, boolean beginTransaction) {
        SpannerException toThrow = this.listener.onError(e, beginTransaction);
        this.close();
        throw toThrow;
    }
}

