/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mssqlbulkload;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="MSSQL_BULK_LOAD", name="i18n::ActionMssqlBulkLoad.Name", description="i18n::ActionMssqlBulkLoad.Description", image="MssqlBulkLoad.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.BulkLoading", keywords={"i18n::ActionMssqlBulkLoad.keyword"}, documentationUrl="/workflow/actions/mssqlbulkload.html")
public class ActionMssqlBulkLoad
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionMssqlBulkLoad.class;
    private String schemaname = null;
    private String tableName = null;
    private String filename = null;
    private String datafiletype = "char";
    private String fieldterminator = null;
    private String lineterminated = null;
    private String codepage = "OEM";
    private String specificcodepage = null;
    private int startfile = 0;
    private int endfile = 0;
    private String orderby = null;
    private boolean addfiletoresult = false;
    private String formatfilename = null;
    private boolean firetriggers = false;
    private boolean checkconstraints = false;
    private boolean keepnulls = false;
    private boolean tablock = false;
    private String errorfilename = null;
    private boolean adddatetime = false;
    private String orderdirection = "Asc";
    private int maxerrors = 0;
    private int batchsize = 0;
    private int rowsperbatch = 0;
    private boolean keepidentity = false;
    private boolean truncate = false;
    private DatabaseMeta connection = null;

    public ActionMssqlBulkLoad(String n) {
        super(n, "");
    }

    public ActionMssqlBulkLoad() {
        this("");
    }

    public Object clone() {
        ActionMssqlBulkLoad je = (ActionMssqlBulkLoad)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XmlHandler.addTagValue((String)"tablename", (String)this.tableName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"datafiletype", (String)this.datafiletype));
        retval.append("      ").append(XmlHandler.addTagValue((String)"fieldterminator", (String)this.fieldterminator));
        retval.append("      ").append(XmlHandler.addTagValue((String)"lineterminated", (String)this.lineterminated));
        retval.append("      ").append(XmlHandler.addTagValue((String)"codepage", (String)this.codepage));
        retval.append("      ").append(XmlHandler.addTagValue((String)"specificcodepage", (String)this.specificcodepage));
        retval.append("      ").append(XmlHandler.addTagValue((String)"formatfilename", (String)this.formatfilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"firetriggers", (boolean)this.firetriggers));
        retval.append("      ").append(XmlHandler.addTagValue((String)"checkconstraints", (boolean)this.checkconstraints));
        retval.append("      ").append(XmlHandler.addTagValue((String)"keepnulls", (boolean)this.keepnulls));
        retval.append("      ").append(XmlHandler.addTagValue((String)"keepidentity", (boolean)this.keepidentity));
        retval.append("      ").append(XmlHandler.addTagValue((String)"tablock", (boolean)this.tablock));
        retval.append("      ").append(XmlHandler.addTagValue((String)"startfile", (int)this.startfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"endfile", (int)this.endfile));
        retval.append("      ").append(XmlHandler.addTagValue((String)"orderby", (String)this.orderby));
        retval.append("      ").append(XmlHandler.addTagValue((String)"orderdirection", (String)this.orderdirection));
        retval.append("      ").append(XmlHandler.addTagValue((String)"maxerrors", (int)this.maxerrors));
        retval.append("      ").append(XmlHandler.addTagValue((String)"batchsize", (int)this.batchsize));
        retval.append("      ").append(XmlHandler.addTagValue((String)"rowsperbatch", (int)this.rowsperbatch));
        retval.append("      ").append(XmlHandler.addTagValue((String)"errorfilename", (String)this.errorfilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"adddatetime", (boolean)this.adddatetime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XmlHandler.addTagValue((String)"truncate", (boolean)this.truncate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.schemaname = XmlHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tableName = XmlHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.datafiletype = XmlHandler.getTagValue((Node)entrynode, (String)"datafiletype");
            this.fieldterminator = XmlHandler.getTagValue((Node)entrynode, (String)"fieldterminator");
            this.lineterminated = XmlHandler.getTagValue((Node)entrynode, (String)"lineterminated");
            this.codepage = XmlHandler.getTagValue((Node)entrynode, (String)"codepage");
            this.specificcodepage = XmlHandler.getTagValue((Node)entrynode, (String)"specificcodepage");
            this.formatfilename = XmlHandler.getTagValue((Node)entrynode, (String)"formatfilename");
            this.firetriggers = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"firetriggers"));
            this.checkconstraints = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"checkconstraints"));
            this.keepnulls = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"keepnulls"));
            this.keepidentity = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"keepidentity"));
            this.tablock = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"tablock"));
            this.startfile = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"startfile"), (int)0);
            this.endfile = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"endfile"), (int)0);
            this.orderby = XmlHandler.getTagValue((Node)entrynode, (String)"orderby");
            this.orderdirection = XmlHandler.getTagValue((Node)entrynode, (String)"orderdirection");
            this.errorfilename = XmlHandler.getTagValue((Node)entrynode, (String)"errorfilename");
            this.maxerrors = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"maxerrors"), (int)0);
            this.batchsize = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"batchsize"), (int)0);
            this.rowsperbatch = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"rowsperbatch"), (int)0);
            this.adddatetime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"adddatetime"));
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.addfiletoresult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.truncate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"truncate"));
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
        }
        catch (HopException e) {
            throw new HopXmlException("Unable to load action of type 'MSsql bulk load' from XML node", (Throwable)e);
        }
    }

    public void setTablename(String tableName) {
        this.tableName = tableName;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public String getTablename() {
        return this.tableName;
    }

    public void setMaxErrors(int maxerrors) {
        this.maxerrors = maxerrors;
    }

    public int getMaxErrors() {
        return this.maxerrors;
    }

    public int getBatchSize() {
        return this.batchsize;
    }

    public void setBatchSize(int batchsize) {
        this.batchsize = batchsize;
    }

    public int getRowsPerBatch() {
        return this.rowsperbatch;
    }

    public void setRowsPerBatch(int rowsperbatch) {
        this.rowsperbatch = rowsperbatch;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) {
        block66: {
            takeFirstNbrLines = "";
            lineTerminatedby = "";
            fieldTerminatedby = "";
            useFieldSeparator = false;
            useCodepage = "";
            errorfileName = "";
            result = previousResult;
            result.setResult(false);
            vfsFilename = this.resolve(this.filename);
            fileObject = null;
            if (Utils.isEmpty((CharSequence)vfsFilename)) break block66;
            try {
                fileObject = HopVfs.getFileObject((String)vfsFilename);
                if (!(fileObject instanceof LocalFile)) {
                    throw new HopException(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.OnlyLocalFileSupported", (String[])new String[]{vfsFilename}));
                }
                realFilename = HopVfs.getFilename((FileObject)fileObject);
                file = new File(realFilename);
                if (!file.exists() || !file.canRead()) break block67;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.FileExists.Label", (String[])new String[]{realFilename}));
                }
                if (this.connection == null) break block68;
                if (!"MSSQL".equals(this.connection.getPluginId())) {
                    this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.DbNotMSSQL", (String[])new String[]{this.connection.getDatabaseName()}));
                    var14_17 = result;
                    return var14_17;
                }
                db = new Database((ILoggingObject)this, (IVariables)this, this.connection);
                db.connect();
                realSchemaname = this.resolve(this.schemaname);
                realTablename = this.resolve(this.tableName);
                if (!db.checkTableExists(realSchemaname, realTablename)) ** GOTO lbl135
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.TableExists.Label", (String[])new String[]{realTablename}));
                }
                if (!Utils.isEmpty((CharSequence)(fieldTerminator = this.getRealFieldTerminator())) || !this.datafiletype.equals("char") && !this.datafiletype.equals("widechar")) ** break block63
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.FieldTerminatorMissing", (String[])new String[0]));
                var18_26 = result;
                db.close();
            }
            catch (Exception e) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.UnexpectedError.Label", (String[])new String[0]), e);
            }
            finally {
                try {
                    if (fileObject != null) {
                        fileObject.close();
                    }
                }
                catch (Exception var12_15) {}
            }
            return var18_26;
            {
                if (this.datafiletype.equals("char") || this.datafiletype.equals("widechar")) {
                    useFieldSeparator = true;
                    fieldTerminatedby = "FIELDTERMINATOR='" + fieldTerminator + "'";
                }
                if (!this.codepage.equals("Specific")) ** GOTO lbl55
                realCodePage = this.resolve(this.codepage);
                if (this.specificcodepage.length() >= 0) ** break block64
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.SpecificCodePageMissing", (String[])new String[0]));
                var19_29 = result;
                db.close();
            }
            return var19_29;
            {
                block69: {
                    useCodepage = "CODEPAGE = '" + realCodePage + "'";
                    break block69;
lbl55:
                    // 1 sources

                    useCodepage = "CODEPAGE = '" + this.codepage + "'";
                }
                realErrorFile = this.resolve(this.errorfilename);
                if (realErrorFile == null) ** GOTO lbl76
                errorfile = new File(realErrorFile);
                if (!errorfile.exists() || this.adddatetime) ** break block65
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.ErrorFileExists", (String[])new String[0]));
                var20_32 = result;
                db.close();
            }
            return var20_32;
            {
                block67: {
                    block68: {
                        try {
                            try {
                                if (this.adddatetime) {
                                    daf = new SimpleDateFormat();
                                    now = new Date();
                                    daf.applyPattern("yyyMMdd_HHmmss");
                                    d = daf.format(now);
                                    errorfileName = "ERRORFILE ='" + realErrorFile + "_" + d + "'";
                                } else {
                                    errorfileName = "ERRORFILE ='" + realErrorFile + "'";
                                }
lbl76:
                                // 3 sources

                                if (!Utils.isEmpty((CharSequence)(rowterminator = this.getRealLineterminated()))) {
                                    lineTerminatedby = "ROWTERMINATOR='" + rowterminator + "'";
                                }
                                if (this.startfile > 0) {
                                    takeFirstNbrLines = "FIRSTROW=" + this.startfile;
                                }
                                if (this.endfile > 0) {
                                    takeFirstNbrLines = "LASTROW=" + this.endfile;
                                }
                                sqlBulkLoad = "";
                                if (this.truncate) {
                                    sqlBulkLoad = "TRUNCATE TABLE " + realTablename + ";";
                                }
                                sqlBulkLoad = (String)sqlBulkLoad + "BULK INSERT " + realTablename + " FROM '" + realFilename.replace('\\', '/') + "'";
                                sqlBulkLoad = (String)sqlBulkLoad + " WITH (";
                                sqlBulkLoad = useFieldSeparator != false ? (String)sqlBulkLoad + (String)fieldTerminatedby : (String)sqlBulkLoad + "DATAFILETYPE ='" + this.datafiletype + "'";
                                if (lineTerminatedby.length() > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + "," + (String)lineTerminatedby;
                                }
                                if (takeFirstNbrLines.length() > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + "," + (String)takeFirstNbrLines;
                                }
                                if (useCodepage.length() > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + "," + (String)useCodepage;
                                }
                                if ((realFormatFile = this.resolve(this.formatfilename)) != null) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", FORMATFILE='" + realFormatFile + "'";
                                }
                                if (this.firetriggers) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",FIRE_TRIGGERS";
                                }
                                if (this.keepnulls) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",KEEPNULLS";
                                }
                                if (this.keepidentity) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",KEEPIDENTITY";
                                }
                                if (this.checkconstraints) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",CHECK_CONSTRAINTS";
                                }
                                if (this.tablock) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",TABLOCK";
                                }
                                if (this.orderby != null) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",ORDER ( " + this.orderby + " " + this.orderdirection + ")";
                                }
                                if (errorfileName.length() > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", " + (String)errorfileName;
                                }
                                if (this.maxerrors > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", MAXERRORS=" + this.maxerrors;
                                }
                                if (this.batchsize > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", BATCHSIZE=" + this.batchsize;
                                }
                                if (this.rowsperbatch > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", ROWS_PER_BATCH=" + this.rowsperbatch;
                                }
                                sqlBulkLoad = (String)sqlBulkLoad + ")";
                                try {
                                    db.execStatement((String)sqlBulkLoad);
                                    db.disconnect();
                                    if (this.isAddFileToResult()) {
                                        resultFile = new ResultFile(0, HopVfs.getFileObject((String)realFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                    }
                                    result.setResult(true);
                                }
                                catch (HopDatabaseException je) {
                                    result.setNrErrors(1L);
                                    this.logError("An error occurred executing this action : " + je.getMessage(), je);
                                }
                                catch (HopFileException e) {
                                    this.logError("An error occurred executing this action : " + e.getMessage(), e);
                                    result.setNrErrors(1L);
                                }
lbl135:
                                // 1 sources

                                result.setNrErrors(1L);
                                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.TableNotExists", (String[])new String[]{realTablename}));
                            }
                            catch (Throwable var15_22) {
                                throw var15_22;
                            }
                            finally {
                                db.close();
                            }
                        }
                        catch (HopDatabaseException dbe) {
                            result.setNrErrors(1L);
                            this.logError("An error occurred executing this entry: " + dbe.getMessage());
                        }
                    }
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Nodatabase.Label", (String[])new String[0]));
                }
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.FileNotExists", (String[])new String[]{realFilename}));
            }
        }
        result.setNrErrors(1L);
        this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Nofilename.Label", (String[])new String[0]));
        return result;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFieldTerminator(String fieldterminator) {
        this.fieldterminator = fieldterminator;
    }

    public void setLineterminated(String lineterminated) {
        this.lineterminated = lineterminated;
    }

    public void setCodePage(String codepage) {
        this.codepage = codepage;
    }

    public String getCodePage() {
        return this.codepage;
    }

    public void setSpecificCodePage(String specificcodepage) {
        this.specificcodepage = specificcodepage;
    }

    public String getSpecificCodePage() {
        return this.specificcodepage;
    }

    public void setFormatFilename(String formatfilename) {
        this.formatfilename = formatfilename;
    }

    public String getFormatFilename() {
        return this.formatfilename;
    }

    public String getFieldTerminator() {
        return this.fieldterminator;
    }

    public String getLineterminated() {
        return this.lineterminated;
    }

    public String getDataFileType() {
        return this.datafiletype;
    }

    public void setDataFileType(String datafiletype) {
        this.datafiletype = datafiletype;
    }

    public String getRealLineterminated() {
        return this.resolve(this.getLineterminated());
    }

    public String getRealFieldTerminator() {
        return this.resolve(this.getFieldTerminator());
    }

    public void setStartFile(int startfile) {
        this.startfile = startfile;
    }

    public int getStartFile() {
        return this.startfile;
    }

    public void setEndFile(int endfile) {
        this.endfile = endfile;
    }

    public int getEndFile() {
        return this.endfile;
    }

    public void setOrderBy(String orderby) {
        this.orderby = orderby;
    }

    public String getOrderBy() {
        return this.orderby;
    }

    public String getOrderDirection() {
        return this.orderdirection;
    }

    public void setOrderDirection(String orderdirection) {
        this.orderdirection = orderdirection;
    }

    public void setErrorFilename(String errorfilename) {
        this.errorfilename = errorfilename;
    }

    public String getErrorFilename() {
        return this.errorfilename;
    }

    public String getRealOrderBy() {
        return this.resolve(this.getOrderBy());
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public void setAddDatetime(boolean adddatetime) {
        this.adddatetime = adddatetime;
    }

    public boolean isAddDatetime() {
        return this.adddatetime;
    }

    public void setFireTriggers(boolean firetriggers) {
        this.firetriggers = firetriggers;
    }

    public boolean isFireTriggers() {
        return this.firetriggers;
    }

    public void setCheckConstraints(boolean checkconstraints) {
        this.checkconstraints = checkconstraints;
    }

    public boolean isCheckConstraints() {
        return this.checkconstraints;
    }

    public void setKeepNulls(boolean keepnulls) {
        this.keepnulls = keepnulls;
    }

    public boolean isKeepNulls() {
        return this.keepnulls;
    }

    public void setKeepIdentity(boolean keepidentity) {
        this.keepidentity = keepidentity;
    }

    public boolean isKeepIdentity() {
        return this.keepidentity;
    }

    public void setTablock(boolean tablock) {
        this.tablock = tablock;
    }

    public boolean isTablock() {
        return this.tablock;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        ResourceReference reference = null;
        if (this.connection != null) {
            reference = new ResourceReference((IResourceHolder)this);
            references.add(reference);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
        }
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            if (reference == null) {
                reference = new ResourceReference((IResourceHolder)this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

