/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HCatAuthUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HCatAuthUtil.class);

    HCatAuthUtil() {
    }

    public static boolean isAuthorizationEnabled(Configuration conf) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            return false;
        }
        if (SessionState.get().getAuthorizer() == null || HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER) == DefaultHiveAuthorizationProvider.class.getName()) {
            LOG.info("Metastore authorizer is skipped for V2 authorizer or DefaultHiveAuthorizationProvider");
            return false;
        }
        return true;
    }
}

