/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.google.gson.Gson;
import com.microsoft.azure.eventprocessorhost.AzureBlobLease;
import com.microsoft.azure.eventprocessorhost.BaseLease;
import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.CompleteLease;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.HostContext;
import com.microsoft.azure.eventprocessorhost.ICheckpointManager;
import com.microsoft.azure.eventprocessorhost.ILeaseManager;
import com.microsoft.azure.eventprocessorhost.LoggingUtils;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.microsoft.azure.storage.blob.BlobListingDetails;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.microsoft.azure.storage.blob.LeaseState;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureStorageCheckpointLeaseManager
implements ICheckpointManager,
ILeaseManager {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(AzureStorageCheckpointLeaseManager.class);
    private static final String METADATA_OWNER_NAME = "OWNINGHOST";
    private final String storageConnectionString;
    private final StorageCredentials storageCredentials;
    private final String storageBlobPrefix;
    private final BlobRequestOptions leaseOperationOptions = new BlobRequestOptions();
    private final BlobRequestOptions checkpointOperationOptions = new BlobRequestOptions();
    private final BlobRequestOptions renewRequestOptions = new BlobRequestOptions();
    private HostContext hostContext;
    private String storageContainerName;
    private CloudBlobClient storageClient;
    private CloudBlobContainer eventHubContainer;
    private CloudBlobDirectory consumerGroupDirectory;
    private Gson gson;
    private Hashtable<String, Checkpoint> latestCheckpoint = new Hashtable();

    AzureStorageCheckpointLeaseManager(String storageConnectionString, String storageContainerName, String storageBlobPrefix) {
        if (storageConnectionString == null || storageConnectionString.trim().isEmpty()) {
            throw new IllegalArgumentException("Provide valid Azure Storage connection string when using Azure Storage");
        }
        this.storageConnectionString = storageConnectionString;
        this.storageCredentials = null;
        if (storageContainerName != null && storageContainerName.trim().isEmpty()) {
            throw new IllegalArgumentException("Azure Storage container name must be a valid container name or null to use the default");
        }
        this.storageContainerName = storageContainerName;
        this.storageBlobPrefix = storageBlobPrefix != null ? storageBlobPrefix.trim() : "";
    }

    AzureStorageCheckpointLeaseManager(StorageCredentials storageCredentials, String storageContainerName, String storageBlobPrefix) {
        if (storageCredentials == null) {
            throw new IllegalArgumentException("Provide valid Azure Storage credentials when using Azure Storage");
        }
        this.storageConnectionString = null;
        this.storageCredentials = storageCredentials;
        if (storageContainerName != null && storageContainerName.trim().isEmpty()) {
            throw new IllegalArgumentException("Azure Storage container name must be a valid container name or null to use the default");
        }
        this.storageContainerName = storageContainerName;
        this.storageBlobPrefix = storageBlobPrefix != null ? storageBlobPrefix.trim() : "";
    }

    void initialize(HostContext hostContext) throws InvalidKeyException, URISyntaxException, StorageException {
        Pattern p;
        Matcher m;
        this.hostContext = hostContext;
        if (this.storageContainerName == null) {
            this.storageContainerName = this.hostContext.getEventHubPath();
        }
        if (!(m = (p = Pattern.compile("^(?-i)(?:[a-z0-9]|(?<=[0-9a-z])-(?=[0-9a-z])){3,63}$")).matcher(this.storageContainerName)).find()) {
            throw new IllegalArgumentException("EventHub names must conform to the following rules to be able to use it with EventProcessorHost: Must start with a letter or number, and can contain only letters, numbers, and the dash (-) character. Every dash (-) character must be immediately preceded and followed by a letter or number; consecutive dashes are not permitted in container names. All letters in a container name must be lowercase. Must be from 3 to 63 characters long.");
        }
        CloudStorageAccount storageAccount = null;
        storageAccount = this.storageConnectionString != null ? CloudStorageAccount.parse((String)this.storageConnectionString) : new CloudStorageAccount(this.storageCredentials);
        this.storageClient = storageAccount.createCloudBlobClient();
        this.eventHubContainer = this.storageClient.getContainerReference(this.storageContainerName);
        this.consumerGroupDirectory = this.eventHubContainer.getDirectoryReference(this.storageBlobPrefix + this.hostContext.getConsumerGroupName());
        this.gson = new Gson();
        this.leaseOperationOptions.setMaximumExecutionTimeInMs(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds() * 1000));
        this.storageClient.setDefaultRequestOptions(this.leaseOperationOptions);
        this.checkpointOperationOptions.setMaximumExecutionTimeInMs(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getCheckpointTimeoutInSeconds() * 1000));
        this.renewRequestOptions.setMaximumExecutionTimeInMs(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds() * 1000));
    }

    @Override
    public CompletableFuture<Boolean> checkpointStoreExists() {
        return this.storeExistsInternal(this.checkpointOperationOptions, "Checking Checpoint Store Existence", "Failure while checking checkpoint store existence");
    }

    @Override
    public CompletableFuture<Void> createCheckpointStoreIfNotExists() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> deleteCheckpointStore() {
        return this.deleteStoreInternal(this.checkpointOperationOptions);
    }

    @Override
    public CompletableFuture<Checkpoint> getCheckpoint(String partitionId) {
        CompletableFuture<Checkpoint> future = null;
        try {
            AzureBlobLease lease = this.getLeaseInternal(partitionId, this.checkpointOperationOptions);
            Checkpoint checkpoint = null;
            if (lease != null && lease.getOffset() != null && !lease.getOffset().isEmpty()) {
                checkpoint = new Checkpoint(partitionId);
                checkpoint.setOffset(lease.getOffset());
                checkpoint.setSequenceNumber(lease.getSequenceNumber());
            }
            future = CompletableFuture.completedFuture(checkpoint);
        }
        catch (StorageException | IOException | URISyntaxException e) {
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Getting Checkpoint Details"));
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> createAllCheckpointsIfNotExists(List<String> partitionIds) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> updateCheckpoint(CompleteLease lease, Checkpoint checkpoint) {
        AzureBlobLease updatedLease = new AzureBlobLease((AzureBlobLease)lease);
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(checkpoint.getPartitionId(), "Checkpointing at " + checkpoint.getOffset() + " // " + checkpoint.getSequenceNumber()));
        updatedLease.setOffset(checkpoint.getOffset());
        updatedLease.setSequenceNumber(checkpoint.getSequenceNumber());
        CompletableFuture<Object> future = null;
        try {
            if (this.updateLeaseInternal(updatedLease, this.checkpointOperationOptions)) {
                future = CompletableFuture.completedFuture(null);
            } else {
                TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(lease, "Lease lost"));
                future = new CompletableFuture();
                future.completeExceptionally(LoggingUtils.wrapException(new RuntimeException("Lease lost while updating checkpoint"), "Updating Checkpoint"));
            }
        }
        catch (StorageException | IOException e) {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(lease, "Failure updating checkpoint"), e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Updating Checkpoint"));
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteCheckpoint(String partitionId) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public int getLeaseDurationInMilliseconds() {
        return this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds() * 1000;
    }

    @Override
    public CompletableFuture<Boolean> leaseStoreExists() {
        return this.storeExistsInternal(this.leaseOperationOptions, "Checking Lease Store Existence", "Failure while checking lease store existence");
    }

    private CompletableFuture<Boolean> storeExistsInternal(BlobRequestOptions options, String action, String trace) {
        CompletableFuture<Boolean> future = null;
        try {
            future = CompletableFuture.completedFuture(this.eventHubContainer.exists(null, options, null));
        }
        catch (StorageException e) {
            TRACE_LOGGER.error(this.hostContext.withHost(trace), (Throwable)e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, action));
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> createLeaseStoreIfNotExists() {
        CompletableFuture<Void> future = null;
        try {
            this.eventHubContainer.createIfNotExists(this.leaseOperationOptions, null);
            TRACE_LOGGER.info(this.hostContext.withHost("Created lease store OK or it already existed"));
            future = CompletableFuture.completedFuture(null);
        }
        catch (StorageException e) {
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Creating Lease Store"));
            TRACE_LOGGER.error(this.hostContext.withHost("Failure while creating lease store"), (Throwable)e);
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteLeaseStore() {
        return this.deleteStoreInternal(this.leaseOperationOptions);
    }

    private CompletableFuture<Void> deleteStoreInternal(BlobRequestOptions options) {
        CompletableFuture<Void> future = null;
        try {
            for (ListBlobItem blob : this.eventHubContainer.listBlobs(null, false, EnumSet.noneOf(BlobListingDetails.class), options, null)) {
                if (blob instanceof CloudBlobDirectory) {
                    for (ListBlobItem subBlob : ((CloudBlobDirectory)blob).listBlobs(null, false, EnumSet.noneOf(BlobListingDetails.class), options, null)) {
                        ((CloudBlockBlob)subBlob).deleteIfExists(DeleteSnapshotsOption.NONE, null, options, null);
                    }
                    continue;
                }
                if (!(blob instanceof CloudBlockBlob)) continue;
                ((CloudBlockBlob)blob).deleteIfExists(DeleteSnapshotsOption.NONE, null, options, null);
            }
            this.eventHubContainer.deleteIfExists(null, options, null);
            future = CompletableFuture.completedFuture(null);
        }
        catch (StorageException | URISyntaxException e) {
            TRACE_LOGGER.error(this.hostContext.withHost("Failure while deleting lease store"), e);
            future = new CompletableFuture<Void>();
            future.completeExceptionally(new CompletionException(e));
        }
        return future;
    }

    @Override
    public CompletableFuture<CompleteLease> getLease(String partitionId) {
        CompletableFuture<CompleteLease> future = null;
        try {
            future = CompletableFuture.completedFuture(this.getLeaseInternal(partitionId, this.leaseOperationOptions));
        }
        catch (StorageException | IOException | URISyntaxException e) {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(partitionId, "Failure while getting lease details"), e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Getting Lease Details"));
        }
        return future;
    }

    private AzureBlobLease getLeaseInternal(String partitionId, BlobRequestOptions options) throws URISyntaxException, IOException, StorageException {
        AzureBlobLease retval = null;
        CloudBlockBlob leaseBlob = this.consumerGroupDirectory.getBlockBlobReference(partitionId);
        if (leaseBlob.exists(null, options, null)) {
            retval = this.downloadLease(leaseBlob, options);
        }
        return retval;
    }

    @Override
    public CompletableFuture<List<BaseLease>> getAllLeases() {
        CompletableFuture<List<BaseLease>> future = null;
        try {
            ArrayList infos = new ArrayList();
            EnumSet<BlobListingDetails> details = EnumSet.of(BlobListingDetails.METADATA);
            Iterable leaseBlobs = this.consumerGroupDirectory.listBlobs("", true, details, this.leaseOperationOptions, null);
            leaseBlobs.forEach(lbi -> {
                CloudBlob blob = (CloudBlob)lbi;
                BlobProperties bp = blob.getProperties();
                HashMap metadata = blob.getMetadata();
                Path p = Paths.get(lbi.getUri().getPath(), new String[0]);
                Path pFileName = p.getFileName();
                String partitionId = pFileName != null ? pFileName.toString() : "";
                infos.add(new BaseLease(partitionId, (String)metadata.get(METADATA_OWNER_NAME), bp.getLeaseState() == LeaseState.LEASED));
            });
            future = CompletableFuture.completedFuture(infos);
        }
        catch (StorageException | URISyntaxException | NoSuchElementException e) {
            Throwable effective = e;
            if (e instanceof NoSuchElementException) {
                effective = e.getCause();
            }
            TRACE_LOGGER.warn(this.hostContext.withHost("Failure while getting lease state details"), e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(effective, "Getting Lease Details"));
        }
        return future;
    }

    @Override
    public CompletableFuture<Void> createAllLeasesIfNotExists(List<String> partitionIds) {
        CompletableFuture<Object> future = null;
        int blobCount = 0;
        try {
            Iterable leaseBlobs = this.consumerGroupDirectory.listBlobs("", true, null, this.leaseOperationOptions, null);
            Iterator<Object> blobIterator = leaseBlobs.iterator();
            while (blobIterator.hasNext()) {
                ++blobCount;
                blobIterator.next();
            }
        }
        catch (StorageException | URISyntaxException e) {
            TRACE_LOGGER.error(this.hostContext.withHost("Exception checking lease existence - leaseContainerName: " + this.storageContainerName + " consumerGroupName: " + this.hostContext.getConsumerGroupName() + " storageBlobPrefix: " + this.storageBlobPrefix), e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Creating Leases"));
        }
        if (future == null) {
            if (blobCount == partitionIds.size()) {
                future = CompletableFuture.completedFuture(null);
            } else {
                ArrayList<CompletableFuture<CompleteLease>> createFutures = new ArrayList<CompletableFuture<CompleteLease>>();
                for (String id : partitionIds) {
                    CompletableFuture<CompleteLease> oneCreate = CompletableFuture.supplyAsync(() -> {
                        AzureBlobLease returnLease = null;
                        try {
                            returnLease = this.createLeaseIfNotExistsInternal(id, this.leaseOperationOptions);
                        }
                        catch (StorageException | IOException | URISyntaxException e) {
                            TRACE_LOGGER.error(this.hostContext.withHostAndPartition(id, "Exception creating lease - leaseContainerName: " + this.storageContainerName + " consumerGroupName: " + this.hostContext.getConsumerGroupName() + " storageBlobPrefix: " + this.storageBlobPrefix), e);
                            throw LoggingUtils.wrapException(e, "Creating Leases");
                        }
                        return returnLease;
                    }, this.hostContext.getExecutor());
                    createFutures.add(oneCreate);
                }
                CompletableFuture[] dummy = new CompletableFuture[createFutures.size()];
                future = CompletableFuture.allOf(createFutures.toArray(dummy));
            }
        }
        return future;
    }

    private AzureBlobLease createLeaseIfNotExistsInternal(String partitionId, BlobRequestOptions options) throws URISyntaxException, IOException, StorageException {
        AzureBlobLease returnLease = null;
        try {
            CloudBlockBlob leaseBlob = this.consumerGroupDirectory.getBlockBlobReference(partitionId);
            returnLease = new AzureBlobLease(partitionId, leaseBlob, this.leaseOperationOptions);
            this.uploadLease(returnLease, leaseBlob, AccessCondition.generateIfNoneMatchCondition((String)"*"), UploadActivity.Create, options);
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(partitionId, "CreateLeaseIfNotExist OK - leaseContainerName: " + this.storageContainerName + " consumerGroupName: " + this.hostContext.getConsumerGroupName() + " storageBlobPrefix: " + this.storageBlobPrefix));
        }
        catch (StorageException se) {
            StorageExtendedErrorInformation extendedErrorInfo = se.getExtendedErrorInformation();
            if (extendedErrorInfo != null && (extendedErrorInfo.getErrorCode().compareTo("BlobAlreadyExists") == 0 || extendedErrorInfo.getErrorCode().compareTo("LeaseIdMissing") == 0)) {
                TRACE_LOGGER.info(this.hostContext.withHostAndPartition(partitionId, "Lease already exists"));
                returnLease = this.getLeaseInternal(partitionId, options);
            }
            throw se;
        }
        return returnLease;
    }

    @Override
    public CompletableFuture<Void> deleteLease(CompleteLease lease) {
        CompletableFuture<Object> future = null;
        TRACE_LOGGER.info(this.hostContext.withHostAndPartition(lease, "Deleting lease"));
        try {
            ((AzureBlobLease)lease).getBlob().deleteIfExists();
            future = CompletableFuture.completedFuture(null);
        }
        catch (StorageException e) {
            TRACE_LOGGER.error(this.hostContext.withHostAndPartition(lease, "Exception deleting lease"), (Throwable)e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Deleting Lease"));
        }
        return future;
    }

    @Override
    public CompletableFuture<Boolean> acquireLease(CompleteLease lease) {
        CompletableFuture<Boolean> future = null;
        try {
            future = CompletableFuture.completedFuture(this.acquireLeaseInternal((AzureBlobLease)lease));
        }
        catch (StorageException | IOException e) {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(lease, "Failure acquiring lease"), e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Acquiring Lease"));
        }
        return future;
    }

    private boolean acquireLeaseInternal(AzureBlobLease lease) throws IOException, StorageException {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Acquiring lease"));
        CloudBlockBlob leaseBlob = lease.getBlob();
        boolean succeeded = true;
        String newLeaseId = EventProcessorHost.safeCreateUUID();
        if (newLeaseId == null || newLeaseId.isEmpty()) {
            throw new IllegalArgumentException("acquireLeaseSync: newLeaseId really is " + (newLeaseId == null ? "null" : "empty"));
        }
        try {
            String newToken = null;
            leaseBlob.downloadAttributes();
            if (leaseBlob.getProperties().getLeaseState() == LeaseState.LEASED) {
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "changeLease"));
                if (lease.getToken() == null || lease.getToken().isEmpty()) {
                    succeeded = false;
                } else {
                    newToken = leaseBlob.changeLease(newLeaseId, AccessCondition.generateLeaseCondition((String)lease.getToken()));
                }
            } else {
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "acquireLease"));
                newToken = leaseBlob.acquireLease(Integer.valueOf(this.hostContext.getPartitionManagerOptions().getLeaseDurationInSeconds()), newLeaseId);
            }
            if (succeeded) {
                lease.setToken(newToken);
                lease.setOwner(this.hostContext.getHostName());
                lease.incrementEpoch();
                this.uploadLease(lease, leaseBlob, AccessCondition.generateLeaseCondition((String)lease.getToken()), UploadActivity.Acquire, this.leaseOperationOptions);
            }
        }
        catch (StorageException se) {
            if (this.wasLeaseLost(se, lease.getPartitionId())) {
                succeeded = false;
            }
            throw se;
        }
        return succeeded;
    }

    @Override
    public CompletableFuture<Boolean> renewLease(CompleteLease lease) {
        CompletableFuture<Boolean> future = null;
        try {
            future = CompletableFuture.completedFuture(this.renewLeaseInternal(lease));
        }
        catch (StorageException se) {
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(se, "Renewing Lease"));
        }
        return future;
    }

    private boolean renewLeaseInternal(CompleteLease lease) throws StorageException {
        boolean result;
        block2: {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Renewing lease"));
            result = false;
            AzureBlobLease azLease = (AzureBlobLease)lease;
            CloudBlockBlob leaseBlob = azLease.getBlob();
            try {
                leaseBlob.renewLease(AccessCondition.generateLeaseCondition((String)azLease.getToken()), this.renewRequestOptions, null);
                result = true;
            }
            catch (StorageException se) {
                if (this.wasLeaseLost(se, azLease.getPartitionId())) break block2;
                throw se;
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<Void> releaseLease(CompleteLease lease) {
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Releasing lease"));
        CompletableFuture<Void> future = null;
        AzureBlobLease inLease = (AzureBlobLease)lease;
        CloudBlockBlob leaseBlob = inLease.getBlob();
        try {
            String leaseId = inLease.getToken();
            AzureBlobLease releasedCopy = new AzureBlobLease(inLease);
            releasedCopy.setToken("");
            releasedCopy.setOwner("");
            this.uploadLease(releasedCopy, leaseBlob, AccessCondition.generateLeaseCondition((String)leaseId), UploadActivity.Release, this.leaseOperationOptions);
            leaseBlob.releaseLease(AccessCondition.generateLeaseCondition((String)leaseId));
            future = CompletableFuture.completedFuture(null);
        }
        catch (StorageException se) {
            if (this.wasLeaseLost(se, lease.getPartitionId())) {
                future = CompletableFuture.completedFuture(null);
            } else {
                future = new CompletableFuture();
                future.completeExceptionally(LoggingUtils.wrapException(se, "Releasing Lease"));
            }
        }
        catch (IOException ie) {
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(ie, "Releasing Lease"));
        }
        return future;
    }

    @Override
    public CompletableFuture<Boolean> updateLease(CompleteLease lease) {
        CompletableFuture<Boolean> future = null;
        try {
            boolean result = this.updateLeaseInternal((AzureBlobLease)lease, this.leaseOperationOptions);
            future = CompletableFuture.completedFuture(result);
        }
        catch (StorageException | IOException e) {
            TRACE_LOGGER.warn(this.hostContext.withHostAndPartition(lease, "Failure updating lease"), e);
            future = new CompletableFuture();
            future.completeExceptionally(LoggingUtils.wrapException(e, "Updating Lease"));
        }
        return future;
    }

    public boolean updateLeaseInternal(AzureBlobLease lease, BlobRequestOptions options) throws StorageException, IOException {
        if (lease == null) {
            return false;
        }
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Updating lease"));
        String token = lease.getToken();
        if (token == null || token.length() == 0) {
            return false;
        }
        boolean result = this.renewLeaseInternal(lease);
        if (result) {
            CloudBlockBlob leaseBlob = lease.getBlob();
            try {
                this.uploadLease(lease, leaseBlob, AccessCondition.generateLeaseCondition((String)token), UploadActivity.Update, options);
            }
            catch (StorageException se) {
                if (this.wasLeaseLost(se, lease.getPartitionId())) {
                    result = false;
                }
                throw se;
            }
            catch (IOException ie) {
                throw ie;
            }
        }
        return result;
    }

    private AzureBlobLease downloadLease(CloudBlockBlob blob, BlobRequestOptions options) throws StorageException, IOException {
        String jsonLease = blob.downloadText(null, null, options, null);
        TRACE_LOGGER.debug(this.hostContext.withHost("Raw JSON downloaded: " + jsonLease));
        AzureBlobLease rehydrated = (AzureBlobLease)this.gson.fromJson(jsonLease, AzureBlobLease.class);
        AzureBlobLease blobLease = new AzureBlobLease(rehydrated, blob, this.leaseOperationOptions);
        if (blobLease.getOffset() != null) {
            this.latestCheckpoint.put(blobLease.getPartitionId(), blobLease.getCheckpoint());
        }
        return blobLease;
    }

    private void uploadLease(AzureBlobLease lease, CloudBlockBlob blob, AccessCondition condition, UploadActivity activity, BlobRequestOptions options) throws StorageException, IOException {
        if (activity != UploadActivity.Create) {
            Checkpoint cached = this.latestCheckpoint.get(lease.getPartitionId());
            if (cached != null && (cached.getSequenceNumber() > lease.getSequenceNumber() || lease.getOffset() == null)) {
                lease.setOffset(cached.getOffset());
                lease.setSequenceNumber(cached.getSequenceNumber());
                TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Replacing stale offset/seqno while uploading lease"));
            } else if (lease.getOffset() != null) {
                this.latestCheckpoint.put(lease.getPartitionId(), lease.getCheckpoint());
            }
        }
        String jsonLease = this.gson.toJson((Object)lease);
        blob.uploadText(jsonLease, null, condition, options, null);
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(lease, "Raw JSON uploading for " + (Object)((Object)activity) + ": " + jsonLease));
        if (activity == UploadActivity.Acquire || activity == UploadActivity.Release) {
            blob.downloadAttributes();
            HashMap metadata = blob.getMetadata();
            switch (activity) {
                case Acquire: {
                    metadata.put(METADATA_OWNER_NAME, lease.getOwner());
                    break;
                }
                case Release: {
                    metadata.remove(METADATA_OWNER_NAME);
                    break;
                }
            }
            blob.setMetadata(metadata);
            blob.uploadMetadata(condition, options, null);
        }
    }

    private boolean wasLeaseLost(StorageException se, String partitionId) {
        StorageExtendedErrorInformation extendedErrorInfo;
        boolean retval = false;
        TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "WAS LEASE LOST? Http " + se.getHttpStatusCode()));
        if (se.getExtendedErrorInformation() != null) {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "Http " + se.getExtendedErrorInformation().getErrorCode() + " :: " + se.getExtendedErrorInformation().getErrorMessage()));
        }
        if ((se.getHttpStatusCode() == 409 || se.getHttpStatusCode() == 412) && (extendedErrorInfo = se.getExtendedErrorInformation()) != null) {
            String errorCode = extendedErrorInfo.getErrorCode();
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "Error code: " + errorCode));
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(partitionId, "Error message: " + extendedErrorInfo.getErrorMessage()));
            if (errorCode.compareTo("LeaseLost") == 0 || errorCode.compareTo("LeaseIdMismatchWithLeaseOperation") == 0 || errorCode.compareTo("LeaseIdMismatchWithBlobOperation") == 0 || errorCode.compareTo("LeaseAlreadyPresent") == 0) {
                retval = true;
            }
        }
        return retval;
    }

    private static enum UploadActivity {
        Create,
        Acquire,
        Release,
        Update;

    }
}

