/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.servlet;

import com.ibm.as400.access.Log;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.BASE64Decoder;
import com.ibm.as400.util.servlet.ResourceBundleLoader_s;
import com.ibm.as400.util.servlet.ServletEventLog;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationServlet
extends HttpServlet {
    static final long serialVersionUID = 3761917964251765027L;
    private String realm_ = "localhost";
    private String realmDisplayName_;
    private Hashtable sessionTable_ = new Hashtable();
    private Log log_;
    private static ResourceBundleLoader_s loader_;

    public AuthenticationServlet() {
    }

    public AuthenticationServlet(String user, String password, String realm) {
        this.setUser(user);
        this.setPassword(password);
        this.setRealm(realm);
    }

    public boolean bypassAuthentication(HttpServletRequest req) {
        return false;
    }

    public Log getLog() {
        return this.log_;
    }

    public String getUser() {
        Thread currentThread = Thread.currentThread();
        String threadId = currentThread.getName();
        Properties p = (Properties)this.sessionTable_.get(threadId);
        return p.getProperty("uid");
    }

    public String getRealm() {
        return this.realm_;
    }

    Hashtable getSessionData() {
        return this.sessionTable_;
    }

    public void init(ServletConfig config) throws ServletException {
        this.log_ = new ServletEventLog(config);
        super.init(config);
        this.setRealm("localhost");
    }

    public void log(String msg) {
        if (this.log_ != null) {
            this.log_.log(msg);
        }
    }

    public void log(Exception e, String msg) {
        if (this.log_ != null) {
            this.log_.log(msg, e);
        }
    }

    private void sendAuthenticationResponse(HttpServletResponse resp, String realmDisplayName) throws IOException {
        this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_CHALLENGE"), new String[]{this.realmDisplayName_}));
        resp.setStatus(401);
        resp.setHeader("Www-authenticate", "Basic realm=\"" + this.realmDisplayName_ + "\"");
        resp.setContentType("text/html");
    }

    public void setLog(Log log) {
        if (log == null) {
            throw new NullPointerException("log");
        }
        this.log_ = log;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new NullPointerException("password");
        }
        Thread currentThread = Thread.currentThread();
        String threadId = currentThread.getName();
        Properties p = (Properties)this.sessionTable_.get(threadId);
        if (p == null) {
            p = new Properties();
        }
        p.put("pw", password);
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_SERVICE"), new String[]{req.getRemoteHost(), req.getRemoteAddr()}));
        if (!this.bypassAuthentication(req)) {
            String uidpw = req.getHeader("Authorization");
            if (uidpw != null) {
                String pw;
                String uid;
                int index = uidpw.indexOf(" ");
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] buffer = decoder.decodeBuffer(uidpw = uidpw.substring(index + 1));
                String s = new String(buffer);
                if ((index = s.indexOf(":")) == -1) {
                    uid = s;
                    pw = "";
                    Trace.log(3, "Missing ':' (colon) in authorization header.");
                } else {
                    uid = s.substring(0, index);
                    pw = s.substring(index + 1);
                }
                try {
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATING"), new String[]{this.realm_, uid}));
                    if (!this.validateAuthority(this.realm_, uid, pw)) {
                        return;
                    }
                    Thread currentThread = Thread.currentThread();
                    String threadId = currentThread.getName();
                    Properties p = new Properties();
                    p.put("realm", this.realm_);
                    p.put("uid", uid);
                    p.put("pwd", pw);
                    this.sessionTable_.put(threadId, p);
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATED"), new String[]{this.realm_, uid}));
                    if (!this.postValidation(req, resp)) {
                        return;
                    }
                    super.service(req, resp);
                    this.sessionTable_.remove(threadId);
                }
                catch (SecurityException se) {
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_AUTHENTICATEFAILED"), new String[]{uid, se.getMessage()}));
                    if (Trace.isTraceOn()) {
                        Trace.log(2, se);
                    }
                    this.sendAuthenticationResponse(resp, this.realmDisplayName_);
                }
                catch (Exception e) {
                    this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_REQFAILED"), new String[]{uid, e.getMessage()}));
                    if (Trace.isTraceOn()) {
                        Trace.log(2, e);
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof ServletException) {
                        throw (ServletException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new ServletException(e.getMessage());
                }
                this.log(ResourceBundleLoader_s.substitute(ResourceBundleLoader_s.getText("PROP_DESC_REQCOMPLETED"), new String[]{req.getRemoteHost(), req.getRemoteAddr()}));
                return;
            }
            this.sendAuthenticationResponse(resp, this.realmDisplayName_);
        } else {
            super.service(req, resp);
        }
    }

    public void setRealm(String realm) {
        if (realm == null) {
            throw new NullPointerException("realm");
        }
        if (realm.equalsIgnoreCase("localhost")) {
            try {
                InetAddress local = InetAddress.getLocalHost();
                this.realm_ = this.realmDisplayName_ = local.getHostName();
            }
            catch (UnknownHostException e) {
                this.log(ResourceBundleLoader_s.getText("PROP_DESC_REALMFAILED"));
                if (Trace.isTraceOn()) {
                    Trace.log(2, e);
                }
                this.realm_ = realm;
                this.realmDisplayName_ = realm;
            }
        } else {
            this.realm_ = realm;
            this.realmDisplayName_ = realm;
        }
    }

    public void setUser(String user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        Thread currentThread = Thread.currentThread();
        String threadId = currentThread.getName();
        Properties p = (Properties)this.sessionTable_.get(threadId);
        if (p == null) {
            p = new Properties();
        }
        p.put("uid", user);
    }

    public boolean validateAuthority(String realm, String uid, String pw) throws SecurityException, IOException {
        return true;
    }

    public boolean postValidation(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        return true;
    }
}

