/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.html;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.util.html.FormInput;
import java.beans.PropertyVetoException;

public class ButtonFormInput
extends FormInput {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private String action_;

    public ButtonFormInput() {
    }

    public ButtonFormInput(String name) {
        super(name);
    }

    public ButtonFormInput(String name, String value) {
        super(name, value);
    }

    public ButtonFormInput(String name, String value, String action) {
        super(name, value);
        try {
            this.setAction(action);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public String getAction() {
        return this.action_;
    }

    @Override
    public String getFOTag() {
        Trace.log(2, "Attempting to getFOTag() for an object that doesn't support it.");
        return "<!-- A ButtonFormInput was here -->";
    }

    @Override
    public String getTag() {
        if (this.getName() == null) {
            Trace.log(2, "Attempting to get tag before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        StringBuffer s = new StringBuffer("<input type=\"button\"");
        s.append(this.getNameAttributeTag());
        s.append(this.getValueAttributeTag(false));
        s.append(this.getSizeAttributeTag());
        s.append(this.getLanguageAttributeTag());
        s.append(this.getDirectionAttributeTag());
        s.append(this.getAttributeString());
        if (this.getAction() == null) {
            Trace.log(2, "Attempting to get tag before setting action.");
            throw new ExtendedIllegalStateException("action", 4);
        }
        s.append(" onclick=\"");
        s.append(this.action_);
        s.append("\"");
        s.append(" />");
        return s.toString();
    }

    public void setAction(String action) throws PropertyVetoException {
        if (action == null) {
            throw new NullPointerException("action");
        }
        if (action.length() == 0) {
            throw new ExtendedIllegalArgumentException("action", 2);
        }
        String old = this.action_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("action", old, action);
        }
        this.action_ = action;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("action", old, action);
        }
    }
}

