/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import java.awt.Image;
import java.beans.SimpleBeanInfo;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PresentationLoader
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String DESCRIPTION_SUFFIX = "_DESCRIPTION";
    private static final String FULLNAME_SUFFIX = "_FULLNAME";
    private static final String HELP_SUFFIX = "_HELP";
    private static final String NAME_SUFFIX = "_NAME";
    private static final String ICON_16_SUFFIX = "16.gif";
    private static final String ICON_32_SUFFIX = "32.gif";
    private static IconLoader_ iconLoader_;
    private ResourceBundle resourceBundle_;

    public PresentationLoader(String resourceBundleBaseName) {
        if (resourceBundleBaseName == null) {
            throw new NullPointerException("resourceBundleBaseName");
        }
        this.resourceBundle_ = ResourceBundle.getBundle(resourceBundleBaseName);
    }

    public PresentationLoader(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new NullPointerException("resourceBundle");
        }
        this.resourceBundle_ = resourceBundle;
    }

    public Presentation getPresentation(String keyBaseName) {
        if (keyBaseName == null) {
            throw new NullPointerException("keyBaseName");
        }
        return this.newPresentation(keyBaseName, null);
    }

    public Presentation getPresentationWithIcon(String keyBaseName, String iconFileName) {
        if (keyBaseName == null) {
            throw new NullPointerException("keyBaseName");
        }
        if (iconFileName == null) {
            throw new NullPointerException("iconFileName");
        }
        return this.newPresentation(keyBaseName, iconFileName);
    }

    public Presentation getPresentation(String keyBaseName, String keySuffix) {
        if (keyBaseName == null) {
            throw new NullPointerException("keyBaseName");
        }
        if (keySuffix == null) {
            throw new NullPointerException("keySuffix");
        }
        return this.newPresentation(PresentationLoader.newKeyBaseName(keyBaseName, keySuffix), null);
    }

    public Presentation getPresentationWithIcon(String keyBaseName, String keySuffix, String iconFileName) {
        if (keyBaseName == null) {
            throw new NullPointerException("keyBaseName");
        }
        if (keySuffix == null) {
            throw new NullPointerException("keySuffix");
        }
        if (iconFileName == null) {
            throw new NullPointerException("iconFileName");
        }
        return this.newPresentation(PresentationLoader.newKeyBaseName(keyBaseName, keySuffix), iconFileName);
    }

    private String getString(String key) {
        try {
            return this.resourceBundle_.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    static Image loadIcon(String iconFileName) {
        if (iconFileName == null) {
            throw new NullPointerException("iconFileName");
        }
        if (iconLoader_ == null) {
            iconLoader_ = new IconLoader_();
        }
        try {
            return iconLoader_.loadImage(iconFileName);
        }
        catch (Exception e) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to load icon: " + iconFileName, (Throwable)e);
            }
            return null;
        }
    }

    private static String newKeyBaseName(String keyBaseName, String keySuffix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(keyBaseName);
        buffer.append('_');
        buffer.append(keySuffix);
        return buffer.toString();
    }

    private Presentation newPresentation(String keyBaseName, String iconBaseName) {
        String name = this.getString(keyBaseName + NAME_SUFFIX);
        String fullName = this.getString(keyBaseName + FULLNAME_SUFFIX);
        String description = this.getString(keyBaseName + DESCRIPTION_SUFFIX);
        String help = this.getString(keyBaseName + HELP_SUFFIX);
        if (name == null && fullName == null && description == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to load presentation for " + keyBaseName);
            }
            throw new ExtendedIllegalArgumentException("keyBaseName", 2);
        }
        Presentation presentation = new Presentation();
        if (name != null) {
            presentation.setName(name);
        }
        if (fullName != null) {
            presentation.setFullName(fullName);
        }
        if (description != null) {
            presentation.setValue("Description Text", description);
        }
        if (help != null) {
            presentation.setValue("Help Text", help);
        }
        if (iconBaseName != null) {
            presentation.setColorIcons(iconBaseName + ICON_16_SUFFIX, iconBaseName + ICON_32_SUFFIX);
        }
        return presentation;
    }

    private static class IconLoader_
    extends SimpleBeanInfo {
        private IconLoader_() {
        }
    }
}

