/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.Descriptor;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlDescriptor;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.PcmlSAXParser;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XPCMLHelper;
import com.ibm.as400.data.XmlException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.MissingResourceException;
import java.util.zip.GZIPInputStream;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class ProgramCallDocument
implements Serializable,
Cloneable {
    static final long serialVersionUID = -1836686444079106483L;
    public static final int SERIALIZED = 0;
    public static final int SOURCE_PCML = 1;
    public static final int SOURCE_XPCML = 2;
    private AS400 m_as400;
    private PcmlDocument m_pcmlDoc;
    static boolean exceptionIfParseError_;
    private int m_timeOut = 0;

    public ProgramCallDocument(AS400 sys, String docName) throws PcmlException {
        if (sys == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (docName == null) {
            ProgramCallDocument.warnNull("docName");
        }
        this.m_as400 = sys;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, null, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 sys, String docName, InputStream xsdStream) throws PcmlException {
        if (sys == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (docName == null) {
            throw new NullPointerException("docName");
        }
        this.m_as400 = sys;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, null, xsdStream);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 sys, String docName, ClassLoader loader) throws PcmlException {
        if (sys == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (docName == null) {
            ProgramCallDocument.warnNull("docName");
        }
        this.m_as400 = sys;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, loader, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 sys, String docName, ClassLoader loader, InputStream xsdStream) throws PcmlException {
        if (sys == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (docName == null) {
            ProgramCallDocument.warnNull("docName");
        }
        this.m_as400 = sys;
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, loader, xsdStream);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument(AS400 sys, String docName, InputStream docStream, ClassLoader loader, InputStream xsdStream, int type) throws PcmlException {
        if (sys == null) {
            ProgramCallDocument.warnNull("sys");
        }
        if (docName == null) {
            ProgramCallDocument.warnNull("docName");
        }
        if (type == 0) {
            this.m_pcmlDoc = ProgramCallDocument.loadSerializedPcmlDocumentFromStream(docStream);
        } else if (type == 1) {
            this.m_pcmlDoc = ProgramCallDocument.loadSourcePcmlDocumentFromStream(docName, docStream, loader, xsdStream, false);
        } else if (type == 2) {
            this.m_pcmlDoc = ProgramCallDocument.loadSourcePcmlDocumentFromStream(docName, docStream, loader, xsdStream, true);
        } else {
            throw new ExtendedIllegalArgumentException("type (" + type + ")", 2);
        }
        this.m_as400 = sys;
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public ProgramCallDocument() throws PcmlException {
        this.m_as400 = null;
        this.m_pcmlDoc = null;
    }

    public ProgramCallDocument(String docName) throws PcmlException {
        if (docName == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, null, null);
    }

    public ProgramCallDocument(String docName, ClassLoader loader) throws XmlException {
        if (docName == null) {
            throw new NullPointerException("docName");
        }
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, loader, null);
    }

    public Object clone() {
        ProgramCallDocument newPcml = null;
        try {
            newPcml = (ProgramCallDocument)super.clone();
            if (this.m_pcmlDoc != null) {
                newPcml.m_pcmlDoc = (PcmlDocument)this.m_pcmlDoc.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newPcml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        ProgramCallDocument programCallDocument = this;
        synchronized (programCallDocument) {
            if (this.m_pcmlDoc != null) {
                this.m_pcmlDoc.setSerializingWithData(true);
            }
            out.defaultWriteObject();
        }
    }

    public static void main(String[] args) {
        PcmlDocument pd = null;
        System.setErr(System.out);
        String errMsg = SystemResourceFinder.format("PCD_ARGUMENTS");
        if (args.length == 2) {
            if (!args[0].equalsIgnoreCase("-SERIALIZE")) {
                System.out.println(errMsg);
                System.exit(-1);
            }
            try {
                pd = ProgramCallDocument.loadSourcePcmlDocument(args[1], null, null);
            }
            catch (PcmlException e) {
                System.out.println(e.getLocalizedMessage());
                System.exit(-1);
            }
            try {
                ProgramCallDocument.savePcmlDocument(pd);
            }
            catch (Exception e) {
                System.out.println(e.getLocalizedMessage());
                System.exit(-1);
            }
        } else {
            System.out.println(errMsg);
            System.exit(-1);
        }
    }

    public boolean callProgram(String name) throws PcmlException {
        try {
            this.m_pcmlDoc.setTimeOut(this.m_timeOut);
            return this.m_pcmlDoc.callProgram(name);
        }
        catch (AS400SecurityException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pe = new PcmlException(e);
            throw pe;
        }
        catch (ObjectDoesNotExistException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pe = new PcmlException(e);
            throw pe;
        }
        catch (InterruptedException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pe = new PcmlException(e);
            throw pe;
        }
        catch (ErrorCompletingRequestException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            PcmlException pe = new PcmlException(e);
            throw pe;
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
    }

    public int getErrno(String name) throws PcmlException {
        return this.m_pcmlDoc.getErrno(name);
    }

    public static Descriptor getDescriptor(String docName) throws PcmlException {
        PcmlDocument pd = null;
        pd = ProgramCallDocument.loadPcmlDocument(docName, null, null);
        return new PcmlDescriptor(pd);
    }

    public static Descriptor getDescriptor(String docName, InputStream xsdStream) throws PcmlException {
        PcmlDocument pd = null;
        pd = ProgramCallDocument.loadPcmlDocument(docName, null, xsdStream);
        return new PcmlDescriptor(pd);
    }

    public static Descriptor getDescriptor(String docName, ClassLoader loader) throws PcmlException {
        PcmlDocument pd = null;
        pd = ProgramCallDocument.loadPcmlDocument(docName, loader, null);
        return new PcmlDescriptor(pd);
    }

    public static Descriptor getDescriptor(String docName, ClassLoader loader, InputStream xsdStream) throws PcmlException {
        PcmlDocument pd = null;
        pd = ProgramCallDocument.loadPcmlDocument(docName, loader, xsdStream);
        return new PcmlDescriptor(pd);
    }

    public Descriptor getDescriptor() {
        if (this.m_pcmlDoc == null) {
            return null;
        }
        return new PcmlDescriptor(this.m_pcmlDoc);
    }

    public int getIntReturnValue(String name) throws PcmlException {
        return this.m_pcmlDoc.getIntReturnValue(name);
    }

    public int getIntValue(String name) throws PcmlException {
        return this.m_pcmlDoc.getIntValue(name);
    }

    public int getIntValue(String name, int[] indices) throws PcmlException {
        return this.m_pcmlDoc.getIntValue(name, new PcmlDimensions(indices));
    }

    public ProgramCall getProgramCall() {
        return this.m_pcmlDoc == null ? null : this.m_pcmlDoc.getProgramCall();
    }

    public String getStringValue(String name) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(name, 0);
    }

    public String getStringValue(String name, int type) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(name, type);
    }

    public String getStringValue(String name, int[] indices) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(name, new PcmlDimensions(indices), 0);
    }

    public String getStringValue(String name, int[] indices, int type) throws PcmlException {
        return this.m_pcmlDoc.getStringValue(name, new PcmlDimensions(indices), type);
    }

    public AS400Message[] getMessageList(String name) throws PcmlException {
        return this.m_pcmlDoc.getMessageList(name);
    }

    public int getOutputsize(String name) throws PcmlException {
        return this.m_pcmlDoc.getOutputsize(name);
    }

    public int getOutputsize(String name, int[] indices) throws PcmlException {
        return this.m_pcmlDoc.getOutputsize(name, new PcmlDimensions(indices));
    }

    public Object getValue(String name) throws PcmlException {
        if (Trace.isTraceOn()) {
            Trace.log(7, "Entered method ProgramCallDocument.getValue(" + name + ")");
        }
        Object val = this.m_pcmlDoc.getValue(name);
        if (Trace.isTraceOn()) {
            Trace.log(7, "Exiting method ProgramCallDocument.getValue(" + name + ")");
        }
        return val;
    }

    public Object getValue(String name, int[] indices) throws PcmlException {
        if (Trace.isTraceOn()) {
            Trace.log(7, "Entered method ProgramCallDocument.getValue(" + name + ", indices)");
        }
        Object val = this.m_pcmlDoc.getValue(name, new PcmlDimensions(indices));
        if (Trace.isTraceOn()) {
            Trace.log(7, "Exiting method ProgramCallDocument.getValue(" + name + ", indices)");
        }
        return val;
    }

    public AS400 getSystem() {
        return this.m_as400;
    }

    public void serialize() throws PcmlException {
        if (this.m_pcmlDoc == null) {
            throw new PcmlException("DOCUMENT_NOT_SET");
        }
        try {
            ProgramCallDocument.savePcmlDocument(this.m_pcmlDoc);
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
    }

    public void serialize(OutputStream outputStream) throws IOException, PcmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_pcmlDoc == null) {
            throw new PcmlException("DOCUMENT_NOT_SET");
        }
        ProgramCallDocument.savePcmlDocument(this.m_pcmlDoc, outputStream);
    }

    public void serialize(File file) throws IOException, XmlException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file);
            this.serialize(fos);
        }
    }

    public void setIntValue(String name, int value) throws PcmlException {
        this.setValue(name, value);
    }

    public void setIntValue(String name, int[] indices, int value) throws PcmlException {
        this.setValue(name, indices, value);
    }

    public void setStringValue(String name, String value) throws PcmlException {
        this.setStringValue(name, value, 0);
    }

    public void setStringValue(String name, String value, int type) throws PcmlException {
        this.m_pcmlDoc.setStringValue(name, value, type);
    }

    public void setStringValue(String name, int[] indices, String value, int type) throws PcmlException {
        this.m_pcmlDoc.setStringValue(name, value, new PcmlDimensions(indices), type);
    }

    public void setCharArrayValue(String name, char[] value) throws PcmlException {
        this.setCharArrayValue(name, value, 0);
    }

    public void setCharArrayValue(String name, char[] value, int type) throws PcmlException {
        this.m_pcmlDoc.setCharArrayValue(name, value, type);
    }

    public void setCharArrayValue(String name, int[] indices, char[] value, int type) throws PcmlException {
        this.m_pcmlDoc.setCharArrayValue(name, value, new PcmlDimensions(indices), type);
    }

    public void setDocument(String docName) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (docName == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, null, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public void setDocument(String docName, InputStream xsdStream) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (docName == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, null, xsdStream);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public void setDocument(String docName, ClassLoader loader) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (docName == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, loader, null);
        if (this.m_as400 != null) {
            this.m_pcmlDoc.setAs400(this.m_as400);
        }
    }

    public void setDocument(String docName, ClassLoader loader, InputStream xsdStream) throws PcmlException {
        if (this.m_pcmlDoc != null) {
            throw new PcmlException("DOCUMENT_ALREADY_SET");
        }
        if (docName == null) {
            throw new NullPointerException("docName");
        }
        this.m_pcmlDoc = ProgramCallDocument.loadPcmlDocument(docName, loader, xsdStream);
        this.m_pcmlDoc.setAs400(this.m_as400);
    }

    public void setSystem(AS400 system) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.m_as400 = system;
        this.m_pcmlDoc.setAs400(this.m_as400);
    }

    public void setValue(String name, Object value) throws PcmlException {
        this.m_pcmlDoc.setValue(name, value);
    }

    public void setValue(String name, int[] indices, Object value) throws PcmlException {
        this.m_pcmlDoc.setValue(name, value, new PcmlDimensions(indices));
    }

    public void setPath(String program, String path) throws PcmlException {
        this.m_pcmlDoc.setPath(program, path);
    }

    public void setThreadsafeOverride(String program, boolean threadsafe) throws PcmlException {
        this.m_pcmlDoc.setThreadsafeOverride(program, threadsafe);
    }

    public boolean getThreadsafeOverride(String program) throws PcmlException {
        return this.m_pcmlDoc.getThreadsafeOverride(program);
    }

    private static void savePcmlDocument(PcmlDocument pd) throws PcmlException, IOException {
        String outFileName = pd.getDocName() + ".pcml.ser";
        try (FilterOutputStream fos = null;){
            fos = new BufferedOutputStream(new FileOutputStream(outFileName));
            ProgramCallDocument.savePcmlDocument(pd, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePcmlDocument(PcmlDocument pd, OutputStream outStream) throws PcmlException, IOException {
        pd.setSerializingWithData(false);
        try (ObjectOutputStream out = null;){
            out = new ObjectOutputStream(outStream);
            out.writeObject(pd);
            String outFileName = pd.getDocName() + ".pcml.ser";
            Trace.log(7, SystemResourceFinder.format("PCML_SERIALIZED", new Object[]{outFileName}));
        }
    }

    private static PcmlDocument loadPcmlDocument(String docName, ClassLoader loader, InputStream xsdStream) throws PcmlException {
        PcmlDocument pd = null;
        pd = ProgramCallDocument.loadSerializedPcmlDocument(docName, loader);
        if (pd != null) {
            return pd;
        }
        pd = ProgramCallDocument.loadZippedSerializedPcmlDocument(docName, loader);
        if (pd != null) {
            return pd;
        }
        pd = ProgramCallDocument.loadSourcePcmlDocument(docName, loader, xsdStream);
        return pd;
    }

    private static PcmlDocument loadSerializedPcmlDocumentFromStream(InputStream docStream) throws PcmlException {
        PcmlDocument pd = null;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(docStream);
            pd = (PcmlDocument)in.readObject();
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return pd;
    }

    private static PcmlDocument loadSourcePcmlDocumentFromStream(String docName, InputStream docStream, ClassLoader loader, InputStream xsdStream, boolean isXPCML) throws PcmlException {
        PcmlDocument pd = null;
        try {
            PcmlSAXParser psp = new PcmlSAXParser(docName, docStream, xsdStream, isXPCML, exceptionIfParseError_);
            pd = psp.getPcmlDocument();
        }
        catch (ParseException pe) {
            if (Trace.isTraceErrorOn()) {
                pe.printStackTrace(Trace.getPrintWriter());
            }
            pe.reportErrors();
            throw new PcmlException(pe);
        }
        catch (PcmlSpecificationException pse) {
            if (Trace.isTraceErrorOn()) {
                pse.printStackTrace(Trace.getPrintWriter());
            }
            pse.reportErrors();
            throw new PcmlException(pse);
        }
        catch (RuntimeException e) {
            Throwable cause;
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            if ((cause = e.getCause()) instanceof PcmlSpecificationException) {
                PcmlSpecificationException pse = (PcmlSpecificationException)cause;
                pse.reportErrors();
                throw new PcmlException(pse);
            }
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        return pd;
    }

    private static PcmlDocument loadSerializedPcmlDocument(String docName, ClassLoader loader) throws PcmlException {
        PcmlDocument pd = null;
        InputStream is = null;
        ObjectInputStream in = null;
        try {
            is = SystemResourceFinder.getSerializedPCMLDocument(docName, loader);
            in = new ObjectInputStream(is);
            pd = (PcmlDocument)in.readObject();
        }
        catch (MissingResourceException e) {
        }
        catch (StreamCorruptedException e) {
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        catch (ClassNotFoundException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        finally {
            block32: {
                block31: {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            if (!Trace.isTraceErrorOn()) break block31;
                            e.printStackTrace(Trace.getPrintWriter());
                        }
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        if (!Trace.isTraceErrorOn()) break block32;
                        e.printStackTrace(Trace.getPrintWriter());
                    }
                }
            }
        }
        return pd;
    }

    private static PcmlDocument loadZippedSerializedPcmlDocument(String docName, ClassLoader loader) throws PcmlException {
        PcmlDocument pd = null;
        InputStream is = null;
        GZIPInputStream gzis = null;
        ObjectInputStream in = null;
        try {
            is = SystemResourceFinder.getSerializedPCMLDocument(docName, loader);
            gzis = new GZIPInputStream(is);
            in = new ObjectInputStream(gzis);
            pd = (PcmlDocument)in.readObject();
        }
        catch (MissingResourceException e) {
        }
        catch (IOException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        catch (ClassNotFoundException e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        finally {
            block34: {
                block33: {
                    block32: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e) {
                                if (!Trace.isTraceErrorOn()) break block32;
                                e.printStackTrace(Trace.getPrintWriter());
                            }
                        }
                    }
                    if (gzis != null) {
                        try {
                            gzis.close();
                        }
                        catch (Exception e) {
                            if (!Trace.isTraceErrorOn()) break block33;
                            e.printStackTrace(Trace.getPrintWriter());
                        }
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {
                        if (!Trace.isTraceErrorOn()) break block34;
                        e.printStackTrace(Trace.getPrintWriter());
                    }
                }
            }
        }
        return pd;
    }

    private static PcmlDocument loadSourcePcmlDocument(String docName, ClassLoader loader, InputStream xsdStream) throws PcmlException {
        PcmlDocument pd = null;
        try {
            InputStream docStream = SystemResourceFinder.getPCMLDocument(docName, loader);
            boolean isXPCML = SystemResourceFinder.isXPCML(docName, loader);
            PcmlSAXParser psp = new PcmlSAXParser(docName, docStream, xsdStream, isXPCML, exceptionIfParseError_);
            pd = psp.getPcmlDocument();
        }
        catch (ParseException pe) {
            pe.reportErrors();
            throw new PcmlException(pe);
        }
        catch (PcmlSpecificationException pse) {
            pse.reportErrors();
            throw new PcmlException(pse);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PcmlSpecificationException) {
                PcmlSpecificationException pse = (PcmlSpecificationException)cause;
                pse.reportErrors();
                throw new PcmlException(pse);
            }
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        catch (Exception e) {
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        return pd;
    }

    public void generateXPCML(String pgmName, OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_pcmlDoc == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_pcmlDoc.generateXPCML(pgmName, outputStream);
    }

    public void generateXPCML(OutputStream outputStream) throws IOException, XmlException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        if (this.m_pcmlDoc == null) {
            throw new XmlException("DOCUMENT_NOT_SET");
        }
        this.m_pcmlDoc.generateXPCML(null, outputStream);
    }

    public void generateXPCML(String fileName) throws IOException, XmlException {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(fileName);
            this.generateXPCML(null, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateXPCML(String pgmName, String fileName) throws IOException, XmlException {
        if (fileName == null) {
            throw new NullPointerException("fileName");
        }
        if (pgmName == null) {
            throw new NullPointerException("pgmName");
        }
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(fileName);
            this.generateXPCML(pgmName, fos);
        }
    }

    public void setXsdName(String xsdName) {
        this.m_pcmlDoc.setXsdName(xsdName);
    }

    public String getXsdName() {
        return this.m_pcmlDoc.getXsdName();
    }

    public static void transformPCMLToXPCML(InputStream pcmlStream, OutputStream xpcmlStream) throws IOException, PcmlException, TransformerException, SAXException {
        if (pcmlStream == null) {
            throw new NullPointerException("pcmlStream");
        }
        if (xpcmlStream == null) {
            throw new NullPointerException("xpcmlStream");
        }
        XPCMLHelper.doTransform("pcml_xpcml.xsl", pcmlStream, xpcmlStream);
    }

    public static void condenseXPCML(InputStream fullStream, OutputStream xsdStream, OutputStream condensedStream, String xsdStreamName) throws IOException, PcmlException, TransformerException, SAXException {
        String xpcmlName = "";
        if (fullStream == null) {
            throw new NullPointerException("fullStream");
        }
        if (xsdStream == null) {
            throw new NullPointerException("xsdStream");
        }
        if (condensedStream == null) {
            throw new NullPointerException("condensedStream");
        }
        if (xsdStreamName == null) {
            throw new NullPointerException("xsdStreamName");
        }
        ByteArrayOutputStream outStream1 = new ByteArrayOutputStream();
        byte[] bytesIn = new byte[1000];
        int bytesRead = 0;
        bytesRead = fullStream.read(bytesIn);
        while (bytesRead != -1) {
            outStream1.write(bytesIn, 0, bytesRead);
            bytesRead = fullStream.read(bytesIn);
        }
        outStream1.flush();
        outStream1.close();
        ByteArrayInputStream inStreamFull = new ByteArrayInputStream(outStream1.toByteArray());
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inStreamFull));
        try {
            String line = lnr.readLine();
            boolean found = false;
            while (line != null && !found) {
                int index3;
                int index2;
                int index1;
                if (line.indexOf("xsi:noNamespaceSchemaLocation=") != -1) {
                    found = true;
                    index1 = line.indexOf("xsi:noNamespaceSchemaLocation=");
                    index2 = 0;
                    index2 = line.indexOf("'", index1);
                    index3 = 0;
                    if (index2 == -1) {
                        index2 = line.indexOf("\"", index1);
                        if (index2 != -1) {
                            index3 = line.indexOf("\"", index2 + 1);
                        }
                    } else {
                        index3 = line.indexOf("'", index2 + 1);
                    }
                    xpcmlName = line.substring(index2 + 1, index3);
                    continue;
                }
                if (line.indexOf("xsi:noNamespaceSchemaLocation =") != -1) {
                    found = true;
                    index1 = line.indexOf("xsi:noNamespaceSchemaLocation =");
                    index2 = 0;
                    index2 = line.indexOf("'", index1);
                    index3 = 0;
                    if (index2 == -1) {
                        index2 = line.indexOf("\"", index1);
                        if (index2 != -1) {
                            index3 = line.indexOf("\"", index2 + 1);
                        }
                    } else {
                        index3 = line.indexOf("'", index2 + 1);
                    }
                    xpcmlName = line.substring(index2 + 1, index3);
                    continue;
                }
                line = lnr.readLine();
            }
        }
        catch (IOException e) {
            Trace.log(7, "Error when reading input stream in condenseXPCML");
            if (Trace.isTraceErrorOn()) {
                e.printStackTrace(Trace.getPrintWriter());
            }
            throw new PcmlException(e);
        }
        if (xpcmlName == "") {
            xpcmlName = "xpcml.xsd";
        }
        ByteArrayInputStream inStream1 = new ByteArrayInputStream(outStream1.toByteArray());
        ByteArrayInputStream inStream2 = new ByteArrayInputStream(outStream1.toByteArray());
        XPCMLHelper.doCondenseTransform("xpcml_xsd.xsl", inStream1, xsdStream, xpcmlName);
        XPCMLHelper.doCondenseTransform("xpcml_basic.xsl", inStream2, condensedStream, xsdStreamName);
    }

    private static final void warnNull(String parmName) {
        if (Trace.isTraceOn()) {
            Trace.log(4, "Null value specified for '" + parmName + "' parameter on ProgramCallDocument constructor.");
        }
    }

    public void setTimeOut(int timeOut) {
        this.m_timeOut = timeOut;
    }

    public int getTimeout() {
        return this.m_timeOut;
    }

    static {
        String property = null;
        try {
            property = SystemProperties.getProperty("com.ibm.as400.data.ProgramCallDocument.throwSAXExceptionIfParseError");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        exceptionIfParseError_ = property == null ? false : property.trim().equalsIgnoreCase("true");
    }
}

