/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import javax.crypto.interfaces.DHPublicKey;

class DDMACCSECRequestDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    DDMACCSECRequestDataStream(boolean useStrongEncryption, int byteType, byte[] iasp, KeyPair keyPair, boolean useAES) {
        super(new byte[byteType == 0 || byteType == 4 ? (byteType == 0 ? 28 : (useAES ? 90 : 52)) : 16]);
        this.setGDSId((byte)-48);
        this.setType(1);
        switch (byteType) {
            case 0: {
                this.set16bit(22, 6);
                break;
            }
            case 4: {
                if (useAES) {
                    this.set16bit(84, 6);
                    break;
                }
                this.set16bit(46, 6);
                break;
            }
            default: {
                this.set16bit(10, 6);
            }
        }
        this.set16bit(4205, 8);
        this.set16bit(6, 10);
        this.set16bit(4514, 12);
        switch (byteType) {
            case 1: {
                this.set16bit(11, 14);
                break;
            }
            case 2: {
                this.set16bit(16, 14);
                break;
            }
            case 4: {
                this.set16bit(9, 14);
                if (useAES) {
                    this.set16bit(68, 16);
                } else {
                    this.set16bit(36, 16);
                }
                this.set16bit(4572, 18);
                int pubKeyOffset = 0;
                int keysize = 32;
                if (useAES) {
                    keysize = 64;
                }
                byte[] publicKey = ((DHPublicKey)keyPair.getPublic()).getY().toByteArray();
                pubKeyOffset = publicKey.length - keysize;
                Trace.log(1, "DMMACCSECRequestDataStream  clientPublicKey:", publicKey);
                for (int i = 0; i < keysize; ++i) {
                    this.data_[20 + i] = pubKeyOffset + i < 0 ? (byte)0 : publicKey[pubKeyOffset + i];
                }
                if (!useAES) break;
                this.set16bit(6, 84);
                this.set16bit(6409, 86);
                this.set16bit(2, 88);
                break;
            }
            default: {
                if (useStrongEncryption) {
                    this.set16bit(8, 14);
                } else {
                    this.set16bit(6, 14);
                }
                this.set16bit(12, 16);
                this.set16bit(4572, 18);
                long t = System.currentTimeMillis();
                int high = (int)(t >>> 32);
                int low = (int)t;
                this.data_[20] = (byte)(high >>> 24);
                this.data_[21] = (byte)(high >>> 16);
                this.data_[22] = (byte)(high >>> 8);
                this.data_[23] = (byte)high;
                this.data_[24] = (byte)(low >>> 24);
                this.data_[25] = (byte)(low >>> 16);
                this.data_[26] = (byte)(low >>> 8);
                this.data_[27] = (byte)low;
            }
        }
    }

    byte[] getClientSeed() {
        byte[] seed = new byte[8];
        System.arraycopy(this.data_, 20, seed, 0, 8);
        return seed;
    }

    @Override
    void write(OutputStream out) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Sending DDM ACCSEC request...");
        }
        super.write(out);
    }
}

