/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;

public abstract class ConvTableBidiMap
extends ConvTable {
    public char[] toUnicode_ = null;
    public byte[] fromUnicode_ = null;

    ConvTableBidiMap(int ccsid, char[] toUnicode, char[] fromUnicode) {
        super(ccsid);
        this.ccsid_ = ccsid;
        this.toUnicode_ = toUnicode;
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing bidi single-byte conversion table for ccsid: " + this.ccsid_, fromUnicode.length);
        }
        this.fromUnicode_ = this.decompressSB(fromUnicode, (byte)63);
        this.bidiStringType_ = AS400BidiTransform.getStringType(ccsid);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded bidi single-byte map for ccsid: " + this.ccsid_);
        }
    }

    @Override
    final String byteArrayToString(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        int type = properties.getBidiStringType();
        if (Trace.traceConversion_) {
            Trace.log(5, "Bidi String Type: " + type);
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length];
        int i = 0;
        while (i < length) {
            dest[i] = this.toUnicode_[0xFF & buf[offset + i++]];
        }
        if (type == -1) {
            if (Trace.traceConversion_) {
                Trace.log(5, "Destination string (no java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
            }
            return String.copyValueOf(dest);
        }
        AS400BidiTransform abt = new AS400BidiTransform(this.ccsid_);
        abt.setBidiConversionProperties(properties);
        abt.setJavaStringType(properties.getBidiStringType());
        abt.setAS400StringType(AS400BidiTransform.getStringType(this.ccsid_));
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        String destString = abt.toJavaLayout(String.copyValueOf(dest));
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (after java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(destString.toCharArray()));
        }
        return destString;
    }

    @Override
    final byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        return this.charArrayToByteArray(source.toCharArray(), properties);
    }

    @Override
    final char[] byteArrayToCharArray(byte[] buf, int offset, int length, BidiConversionProperties properties) {
        int type = properties.getBidiStringType();
        if (Trace.traceConversion_) {
            Trace.log(5, "Bidi String Type: " + type);
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, buf, offset, length);
        }
        char[] dest = new char[length];
        int i = 0;
        while (i < length) {
            dest[i] = this.toUnicode_[0xFF & buf[offset + i++]];
        }
        if (type == -1) {
            if (Trace.traceConversion_) {
                Trace.log(5, "Destination string (no java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
            }
            return dest;
        }
        AS400BidiTransform abt = new AS400BidiTransform(this.ccsid_);
        abt.setBidiConversionProperties(properties);
        abt.setJavaStringType(properties.getBidiStringType());
        abt.setAS400StringType(AS400BidiTransform.getStringType(this.ccsid_));
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(dest));
        }
        char[] destCharArray = abt.toJavaLayout(dest);
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string (after java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(destCharArray));
        }
        return destCharArray;
    }

    @Override
    final byte[] charArrayToByteArray(char[] source, BidiConversionProperties properties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array (before java layout was applied) for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(source));
        }
        AS400BidiTransform abt = new AS400BidiTransform(this.ccsid_);
        abt.setBidiConversionProperties(properties);
        abt.setJavaStringType(properties.getBidiStringType());
        abt.setAS400StringType(AS400BidiTransform.getStringType(this.ccsid_));
        source = abt.toAS400Layout(source);
        byte[] dest = new byte[source.length];
        int i = 0;
        while (i < source.length) {
            dest[i] = this.fromUnicode_[source[i++]];
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, dest);
        }
        return dest;
    }
}

