/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforcedelete;

import com.sforce.soap.partner.Error;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransform;
import org.apache.hop.pipeline.transforms.salesforcedelete.SalesforceDeleteData;
import org.apache.hop.pipeline.transforms.salesforcedelete.SalesforceDeleteMeta;

public class SalesforceDelete
extends SalesforceTransform<SalesforceDeleteMeta, SalesforceDeleteData> {
    private static final Class<?> PKG = SalesforceDeleteMeta.class;

    public SalesforceDelete(TransformMeta transformMeta, SalesforceDeleteMeta meta, SalesforceDeleteData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, meta, data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (((SalesforceDeleteData)this.data).iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((SalesforceDeleteData)this.data).deleteId = new String[((SalesforceDeleteMeta)this.meta).getBatchSizeInt()];
            ((SalesforceDeleteData)this.data).outputBuffer = new Object[((SalesforceDeleteMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceDeleteData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((SalesforceDeleteMeta)this.meta).getFields(((SalesforceDeleteData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            String realFieldName = this.resolve(((SalesforceDeleteMeta)this.meta).getDeleteField());
            if (Utils.isEmpty((CharSequence)realFieldName)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.DeleteKeyFieldMissing", (String[])new String[0]));
            }
            ((SalesforceDeleteData)this.data).indexOfKeyField = this.getInputRowMeta().indexOfValue(realFieldName);
            if (((SalesforceDeleteData)this.data).indexOfKeyField < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.CanNotFindFDeleteKeyField", (String[])new String[]{realFieldName}));
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"SalesforceDelete.log.Exception", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    private void writeToSalesForce(Object[] rowData) throws HopException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.Log.WriteToSalesforce", (Object[])new Object[]{((SalesforceDeleteData)this.data).iBufferPos, ((SalesforceDeleteMeta)this.meta).getBatchSizeInt()}));
            }
            if (((SalesforceDeleteData)this.data).iBufferPos < ((SalesforceDeleteMeta)this.meta).getBatchSizeInt()) {
                ((SalesforceDeleteData)this.data).deleteId[((SalesforceDeleteData)this.data).iBufferPos] = this.getInputRowMeta().getString(rowData, ((SalesforceDeleteData)this.data).indexOfKeyField);
                ((SalesforceDeleteData)this.data).outputBuffer[((SalesforceDeleteData)this.data).iBufferPos] = rowData;
                ++((SalesforceDeleteData)this.data).iBufferPos;
            }
            if (((SalesforceDeleteData)this.data).iBufferPos >= ((SalesforceDeleteMeta)this.meta).getBatchSizeInt()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.Log.CallingFlush", (String[])new String[0]));
                }
                this.flushBuffers();
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.WriteToSalesforce", (String[])new String[]{e.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws HopException {
        try {
            if (((SalesforceDeleteData)this.data).deleteId.length > ((SalesforceDeleteData)this.data).iBufferPos) {
                String[] smallBuffer = new String[((SalesforceDeleteData)this.data).iBufferPos];
                System.arraycopy(((SalesforceDeleteData)this.data).deleteId, 0, smallBuffer, 0, ((SalesforceDeleteData)this.data).iBufferPos);
                ((SalesforceDeleteData)this.data).deleteId = smallBuffer;
            }
            ((SalesforceDeleteData)this.data).deleteResult = ((SalesforceDeleteData)this.data).connection.delete(((SalesforceDeleteData)this.data).deleteId);
            int nr = ((SalesforceDeleteData)this.data).deleteResult.length;
            for (int j = 0; j < nr; ++j) {
                if (((SalesforceDeleteData)this.data).deleteResult[j].isSuccess()) {
                    this.putRow(((SalesforceDeleteData)this.data).outputRowMeta, ((SalesforceDeleteData)this.data).outputBuffer[j]);
                    this.incrementLinesOutput();
                    if (!this.checkFeedback(this.getLinesInput()) || !this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.log.LineRow", (String[])new String[]{String.valueOf(this.getLinesInput())}));
                    continue;
                }
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceDelete.Found.Error", (String[])new String[0]));
                    }
                    Error err = ((SalesforceDeleteData)this.data).deleteResult[j].getErrors()[0];
                    throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()}));
                }
                Object errorMessage = "";
                int nrErrors = ((SalesforceDeleteData)this.data).deleteResult[j].getErrors().length;
                for (int i = 0; i < nrErrors; ++i) {
                    Error err = ((SalesforceDeleteData)this.data).deleteResult[j].getErrors()[i];
                    errorMessage = (String)errorMessage + BaseMessages.getString(PKG, (String)"SalesforceDelete.Error.FlushBuffer", (Object[])new Object[]{j, err.getStatusCode(), err.getMessage()});
                }
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceDelete.PassingRowToErrorTransform", (String[])new String[0]));
                }
                this.putError(this.getInputRowMeta(), ((SalesforceDeleteData)this.data).outputBuffer[j], 1L, (String)errorMessage, null, "SalesforceDelete001");
            }
            ((SalesforceDeleteData)this.data).deleteId = new String[((SalesforceDeleteMeta)this.meta).getBatchSizeInt()];
            ((SalesforceDeleteData)this.data).outputBuffer = new Object[((SalesforceDeleteMeta)this.meta).getBatchSizeInt()][];
            ((SalesforceDeleteData)this.data).iBufferPos = 0;
        }
        catch (Exception e) {
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SalesforceDelete.FailedToDeleted", (String[])new String[]{e.getMessage()}));
            }
            if (this.log.isDebug()) {
                this.logDebug("Passing row to error transform");
            }
            for (int i = 0; i < ((SalesforceDeleteData)this.data).iBufferPos; ++i) {
                this.putError(((SalesforceDeleteData)this.data).inputRowMeta, ((SalesforceDeleteData)this.data).outputBuffer[i], 1L, e.getMessage(), null, "SalesforceDelete002");
            }
        }
        finally {
            if (((SalesforceDeleteData)this.data).deleteResult != null) {
                ((SalesforceDeleteData)this.data).deleteResult = null;
            }
        }
    }

    @Override
    public boolean init() {
        if (super.init()) {
            try {
                ((SalesforceDeleteData)this.data).connection.setTimeOut(Const.toInt((String)this.resolve(((SalesforceDeleteMeta)this.meta).getTimeout()), (int)0));
                ((SalesforceDeleteData)this.data).connection.setUsingCompression(((SalesforceDeleteMeta)this.meta).isCompression());
                ((SalesforceDeleteData)this.data).connection.setRollbackAllChangesOnError(((SalesforceDeleteMeta)this.meta).isRollbackAllChangesOnError());
                ((SalesforceDeleteData)this.data).connection.connect();
                return true;
            }
            catch (HopException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceDelete.Log.ErrorOccurredDuringTransformInitialize", (String[])new String[0]) + ke.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
        if (((SalesforceDeleteData)this.data).outputBuffer != null) {
            ((SalesforceDeleteData)this.data).outputBuffer = null;
        }
        if (((SalesforceDeleteData)this.data).deleteId != null) {
            ((SalesforceDeleteData)this.data).deleteId = null;
        }
        super.dispose();
    }
}

