/*
 * Decompiled with CFR 0.152.
 */
package jflex.dfa;

import java.util.ArrayList;
import java.util.HashMap;
import jflex.core.NFA;
import jflex.dfa.DFA;
import jflex.logging.Out;
import jflex.option.Options;
import jflex.state.StateSet;
import jflex.state.StateSetEnumerator;

public class DfaFactory {
    public static DFA createFromNfa(NFA nfa) {
        StateSet newState;
        int numStates = nfa.numStates();
        HashMap<StateSet, Integer> dfaStates = new HashMap<StateSet, Integer>(numStates);
        ArrayList<StateSet> dfaList = new ArrayList<StateSet>(numStates);
        DFA dfa = new DFA(nfa.numEntryStates(), nfa.numInput(), nfa.numLexStates());
        int numDFAStates = 0;
        int currentDFAState = 0;
        Out.println("Converting NFA to DFA : ");
        nfa.epsilonFill();
        for (int i = 0; i < nfa.numEntryStates(); ++i) {
            newState = nfa.epsilon(i);
            dfaStates.put(newState, numDFAStates);
            dfaList.add(newState);
            dfa.setEntryState(i, numDFAStates);
            dfa.setFinal(numDFAStates, nfa.containsFinal(newState));
            dfa.setAction(numDFAStates, nfa.getAction(newState));
            ++numDFAStates;
        }
        --numDFAStates;
        StateSet tempStateSet = nfa.tempStateSet();
        StateSetEnumerator states = nfa.states();
        newState = new StateSet(numStates);
        while (currentDFAState <= numDFAStates) {
            StateSet currentState = (StateSet)dfaList.get(currentDFAState);
            for (int input = 0; input < nfa.numInput(); ++input) {
                tempStateSet.clear();
                states.reset(currentState);
                while (states.hasMoreElements()) {
                    tempStateSet.add(nfa.reachableStates(states.nextElement(), input));
                }
                newState.copy(tempStateSet);
                states.reset(tempStateSet);
                while (states.hasMoreElements()) {
                    newState.add(nfa.epsilon(states.nextElement()));
                }
                if (!newState.containsElements()) continue;
                Integer nextDFAState = (Integer)dfaStates.get(newState);
                if (nextDFAState != null) {
                    dfa.addTransition(currentDFAState, input, nextDFAState);
                    continue;
                }
                if (Options.progress) {
                    Out.print(".");
                }
                StateSet storeState = new StateSet(newState);
                dfaStates.put(storeState, ++numDFAStates);
                dfaList.add(storeState);
                dfa.addTransition(currentDFAState, input, numDFAStates);
                dfa.setFinal(numDFAStates, nfa.containsFinal(storeState));
                dfa.setAction(numDFAStates, nfa.getAction(storeState));
            }
            ++currentDFAState;
        }
        if (Options.verbose) {
            Out.println("");
        }
        return dfa;
    }

    private DfaFactory() {
    }
}

