/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.service.reads.repair.BlockingReadRepair;
import org.apache.cassandra.service.reads.repair.ReadOnlyReadRepair;
import org.apache.cassandra.service.reads.repair.ReadRepair;

public enum ReadRepairStrategy implements ReadRepair.Factory
{
    NONE{

        @Override
        public <E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>> ReadRepair<E, P> create(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, long queryStartNanoTime) {
            return new ReadOnlyReadRepair<E, P>(command, replicaPlan, queryStartNanoTime);
        }
    }
    ,
    BLOCKING{

        @Override
        public <E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E, P>> ReadRepair<E, P> create(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, long queryStartNanoTime) {
            return new BlockingReadRepair<E, P>(command, replicaPlan, queryStartNanoTime);
        }
    };


    public static ReadRepairStrategy fromString(String s) {
        return ReadRepairStrategy.valueOf(s.toUpperCase());
    }
}

