/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.util.Arrays;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadQuery;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.Clock;

public class MultiPartitionPager<T extends SinglePartitionReadQuery>
implements QueryPager {
    private final SinglePartitionPager[] pagers;
    private final DataLimits limit;
    private final int nowInSec;
    private int remaining;
    private int current;

    public MultiPartitionPager(SinglePartitionReadQuery.Group<T> group, PagingState state, ProtocolVersion protocolVersion) {
        int i;
        this.limit = group.limits();
        this.nowInSec = group.nowInSec();
        if (state != null) {
            for (i = 0; i < group.queries.size() && !((SinglePartitionReadQuery)group.queries.get(i)).partitionKey().getKey().equals(state.partitionKey); ++i) {
            }
        }
        if (i >= group.queries.size()) {
            this.pagers = null;
            return;
        }
        this.pagers = new SinglePartitionPager[group.queries.size() - i];
        SinglePartitionReadQuery query = (SinglePartitionReadQuery)group.queries.get(i);
        this.pagers[0] = query.getPager(state, protocolVersion);
        for (int j = i + 1; j < group.queries.size(); ++j) {
            this.pagers[j - i] = ((SinglePartitionReadQuery)group.queries.get(j)).getPager(null, protocolVersion);
        }
        this.remaining = state == null ? this.limit.count() : state.remaining;
    }

    private MultiPartitionPager(SinglePartitionPager[] pagers, DataLimits limit, int nowInSec, int remaining, int current) {
        this.pagers = pagers;
        this.limit = limit;
        this.nowInSec = nowInSec;
        this.remaining = remaining;
        this.current = current;
    }

    @Override
    public QueryPager withUpdatedLimit(DataLimits newLimits) {
        SinglePartitionPager[] newPagers = Arrays.copyOf(this.pagers, this.pagers.length);
        newPagers[this.current] = newPagers[this.current].withUpdatedLimit(newLimits);
        return new MultiPartitionPager<T>(newPagers, newLimits, this.nowInSec, this.remaining, this.current);
    }

    @Override
    public PagingState state() {
        if (this.isExhausted()) {
            return null;
        }
        PagingState state = this.pagers[this.current].state();
        return new PagingState(this.pagers[this.current].key(), state == null ? null : state.rowMark, this.remaining, this.pagers[this.current].remainingInPartition());
    }

    @Override
    public boolean isExhausted() {
        if (this.remaining <= 0 || this.pagers == null) {
            return true;
        }
        while (this.current < this.pagers.length) {
            if (!this.pagers[this.current].isExhausted()) {
                return false;
            }
            ++this.current;
        }
        return true;
    }

    @Override
    public ReadExecutionController executionController() {
        for (int i = this.current; i < this.pagers.length; ++i) {
            if (this.pagers[i] == null) continue;
            return this.pagers[i].executionController();
        }
        throw new AssertionError((Object)"Shouldn't be called on an exhausted pager");
    }

    @Override
    public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestValidationException, RequestExecutionException {
        int toQuery = Math.min(this.remaining, pageSize);
        return new PagersIterator(toQuery, consistency, clientState, null, queryStartNanoTime);
    }

    @Override
    public PartitionIterator fetchPageInternal(int pageSize, ReadExecutionController executionController) throws RequestValidationException, RequestExecutionException {
        int toQuery = Math.min(this.remaining, pageSize);
        return new PagersIterator(toQuery, null, null, executionController, Clock.Global.nanoTime());
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    private class PagersIterator
    extends AbstractIterator<RowIterator>
    implements PartitionIterator {
        private final int pageSize;
        private PartitionIterator result;
        private boolean closed;
        private final long queryStartNanoTime;
        private final ConsistencyLevel consistency;
        private final ClientState clientState;
        private final ReadExecutionController executionController;
        private int pagerMaxRemaining;
        private int counted;

        public PagersIterator(int pageSize, ConsistencyLevel consistency, ClientState clientState, ReadExecutionController executionController, long queryStartNanoTime) {
            this.pageSize = pageSize;
            this.consistency = consistency;
            this.clientState = clientState;
            this.executionController = executionController;
            this.queryStartNanoTime = queryStartNanoTime;
        }

        @Override
        protected RowIterator computeNext() {
            while (this.result == null || !this.result.hasNext()) {
                boolean isDone;
                if (this.result != null) {
                    this.result.close();
                    this.counted += this.pagerMaxRemaining - MultiPartitionPager.this.pagers[MultiPartitionPager.this.current].maxRemaining();
                }
                boolean bl = isDone = this.counted >= this.pageSize || this.result != null && MultiPartitionPager.this.limit.isGroupByLimit() && !MultiPartitionPager.this.pagers[MultiPartitionPager.this.current].isExhausted();
                if (isDone || MultiPartitionPager.this.isExhausted()) {
                    this.closed = true;
                    return (RowIterator)this.endOfData();
                }
                this.pagerMaxRemaining = MultiPartitionPager.this.pagers[MultiPartitionPager.this.current].maxRemaining();
                int toQuery = this.pageSize - this.counted;
                this.result = this.consistency == null ? MultiPartitionPager.this.pagers[MultiPartitionPager.this.current].fetchPageInternal(toQuery, this.executionController) : MultiPartitionPager.this.pagers[MultiPartitionPager.this.current].fetchPage(toQuery, this.consistency, this.clientState, this.queryStartNanoTime);
            }
            return (RowIterator)this.result.next();
        }

        @Override
        public void close() {
            MultiPartitionPager.this.remaining = MultiPartitionPager.this.remaining - this.counted;
            if (this.result != null && !this.closed) {
                this.result.close();
            }
        }
    }
}

