/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.util.UUID;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowInfo;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@VisibleForTesting
class TagWithUniqueIds<@UnknownKeyFor KeyT, @UnknownKeyFor ElementT>
extends DoFn<KV<KeyT, ElementT>, KV<KeyT, TableRowInfo<ElementT>>> {
    private transient @Nullable @UnknownKeyFor @Initialized String randomUUID = null;
    private transient @UnknownKeyFor @NonNull @Initialized long sequenceNo = 0L;
    private final @Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> elementToId;

    public TagWithUniqueIds() {
        this.elementToId = null;
    }

    public TagWithUniqueIds(@Nullable @UnknownKeyFor @Initialized SerializableFunction<ElementT, @UnknownKeyFor @NonNull @Initialized String> elementToId) {
        this.elementToId = elementToId;
    }

    @DoFn.StartBundle
    public void startBundle() {
        if (this.elementToId == null) {
            this.randomUUID = UUID.randomUUID().toString();
        }
    }

    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String uniqueId = this.elementToId == null ? this.randomUUID + this.sequenceNo++ : (String)this.elementToId.apply(((KV)context.element()).getValue());
        context.output((Object)KV.of((Object)((KV)context.element()).getKey(), new TableRowInfo<Object>(((KV)context.element()).getValue(), uniqueId)));
    }
}

