/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.testing.gui.TestingGuiPlugin;
import org.apache.hop.testing.xp.ValidatePipelineUnitTestExtensionPoint;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.pipeline.extension.HopGuiPipelineGraphExtension;
import org.apache.hop.ui.testing.PipelineUnitTestSetLocationDialog;
import org.eclipse.swt.events.MouseEvent;

@ExtensionPoint(extensionPointId="PipelineGraphMouseDown", id="LocationMouseDoubleClickExtensionPoint", description="Open a data set when double clicked on it")
public class LocationMouseDoubleClickExtensionPoint
implements IExtensionPoint<HopGuiPipelineGraphExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiPipelineGraphExtension pipelineGraphExtension) throws HopException {
        HopGuiPipelineGraph pipelineGraph = pipelineGraphExtension.getPipelineGraph();
        PipelineMeta pipelineMeta = pipelineGraph.getPipelineMeta();
        PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
        if (unitTest == null) {
            return;
        }
        HopGui hopGui = HopGui.getInstance();
        try {
            AreaOwner areaOwner;
            List dataSets = hopGui.getMetadataProvider().getSerializer(DataSet.class).loadAll();
            HashMap<String, IRowMeta> transformFieldsMap = new HashMap<String, IRowMeta>();
            for (TransformMeta transformMeta : pipelineMeta.getTransforms()) {
                try {
                    IRowMeta transformFields = pipelineMeta.getTransformFields(pipelineGraph.getVariables(), transformMeta);
                    transformFieldsMap.put(transformMeta.getName(), transformFields);
                }
                catch (Exception transformFields) {}
            }
            MouseEvent e = pipelineGraphExtension.getEvent();
            Point point = pipelineGraphExtension.getPoint();
            if ((e.button == 1 || e.button == 2) && (areaOwner = pipelineGraph.getVisibleAreaOwner(point.x, point.y)) != null && areaOwner.getAreaType() != null) {
                String transformName;
                PipelineUnitTestSetLocation goldenLocation;
                if ("Input_DataSet".equals(areaOwner.getParent())) {
                    PipelineUnitTestSetLocationDialog dialog;
                    String transformName2 = (String)areaOwner.getOwner();
                    PipelineUnitTestSetLocation inputLocation = unitTest.findInputLocation(transformName2);
                    if (inputLocation != null && (dialog = new PipelineUnitTestSetLocationDialog(hopGui.getDisplay().getActiveShell(), variables, (IHopMetadataProvider)hopGui.getMetadataProvider(), inputLocation, dataSets, transformFieldsMap)).open()) {
                        hopGui.getMetadataProvider().getSerializer(PipelineUnitTest.class).save((IHopMetadata)unitTest);
                        pipelineGraph.updateGui();
                    }
                } else if ("Golden_DataSet".equals(areaOwner.getParent())) {
                    PipelineUnitTestSetLocationDialog dialog;
                    String transformName3 = (String)areaOwner.getOwner();
                    PipelineUnitTestSetLocation goldenLocation2 = unitTest.findGoldenLocation(transformName3);
                    if (goldenLocation2 != null && (dialog = new PipelineUnitTestSetLocationDialog(hopGui.getDisplay().getActiveShell(), variables, (IHopMetadataProvider)hopGui.getMetadataProvider(), goldenLocation2, dataSets, transformFieldsMap)).open()) {
                        hopGui.getMetadataProvider().getSerializer(PipelineUnitTest.class).save((IHopMetadata)unitTest);
                        pipelineGraph.updateGui();
                    }
                } else if ("Golden_DataSet_Result".equals(areaOwner.getParent()) && (goldenLocation = unitTest.findGoldenLocation(transformName = (String)areaOwner.getOwner())) != null) {
                    IPipelineEngine pipeline = pipelineGraph.getPipeline();
                    if (pipeline == null) {
                        return;
                    }
                    List results = (List)pipeline.getExtensionDataMap().get("UnitTestResults");
                    if (results == null || results.isEmpty()) {
                        return;
                    }
                    ValidatePipelineUnitTestExtensionPoint.showUnitTestErrors((IPipelineEngine<PipelineMeta>)pipeline, results, hopGui);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getDisplay().getActiveShell(), "Error", "Error editing location", e);
        }
    }

    private void openDataSet(String dataSetName) {
        HopGui hopGui = HopGui.getInstance();
        MetadataManager manager = new MetadataManager(hopGui.getVariables(), (IHopMetadataProvider)hopGui.getMetadataProvider(), DataSet.class, hopGui.getShell());
        manager.editMetadata(dataSetName);
    }
}

