/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005]g!\u0002\u0012$\u0003\u0003q\u0003\u0002C\u001d\u0001\u0005\u000b\u0007I\u0011\u0001\u001e\t\u0011\u0005\u0003!\u0011!Q\u0001\nmBQA\u0011\u0001\u0005\u0002\rCQA\u0015\u0001\u0007\u0002MCQa\u0016\u0001\u0007\u0002MCQ\u0001\u0017\u0001\u0005\u0002eCQ\u0001\u001b\u0001\u0005\u0002%DQ\u0001\u001b\u0001\u0005\u00021DQ\u0001\u001b\u0001\u0005\u0002]DQ\u0001\u001b\u0001\u0005\u0002mDa\u0001\u001b\u0001\u0005\u0002\u0005=\u0001B\u00025\u0001\t\u0003\t\u0019\u0003\u0003\u0004i\u0001\u0011\u0005\u0011q\u0005\u0005\u0007Q\u0002!\t!!\f\t\r!\u0004A\u0011AA \u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002X\u0001!\t!!\u0018\t\u000f\u0005]\u0003\u0001\"\u0001\u0002f!9\u0011Q\u000f\u0001\u0005\u0002\u0005]\u0004bBA;\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u0003\u0003A\u0011AAB\u0011\u001d\tY\t\u0001C\u0001\u0003\u0007Cq!!$\u0001\t\u0003\ty\tC\u0005\u0002\u0012\u0002\u0001\r\u0011\"\u0003\u0002\u0010\"I\u00111\u0013\u0001A\u0002\u0013%\u0011Q\u0013\u0005\t\u00037\u0003\u0001\u0015)\u0003\u0002p!I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\n\u0003O\u0003\u0001\u0019!C\u0005\u0003SC\u0001\"!,\u0001A\u0003&\u0011\u0011\u0015\u0005\t\u0003o\u0003A\u0011A\u0013\u0002:\"A\u0011q\u0018\u0001\u0005\u0002\u0015\n\t\r\u0003\u0005\u0002H\u0002!\t!JAP\u0005!\u0011VmY3jm\u0016\u0014(B\u0001\u0013&\u0003!\u0011XmY3jm\u0016\u0014(B\u0001\u0014(\u0003%\u0019HO]3b[&twM\u0003\u0002)S\u0005)1\u000f]1sW*\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0007\u0001)\"a\f%\u0014\u0007\u0001\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VM\u001a\t\u0003c]J!\u0001\u000f\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0019M$xN]1hK2+g/\u001a7\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\u0014\u0002\u000fM$xN]1hK&\u0011\u0001)\u0010\u0002\r'R|'/Y4f\u0019\u00164X\r\\\u0001\u000egR|'/Y4f\u0019\u00164X\r\u001c\u0011\u0002\rqJg.\u001b;?)\t!\u0015\u000bE\u0002F\u0001\u0019k\u0011a\t\t\u0003\u000f\"c\u0001\u0001B\u0003J\u0001\t\u0007!JA\u0001U#\tYe\n\u0005\u00022\u0019&\u0011QJ\r\u0002\b\u001d>$\b.\u001b8h!\t\tt*\u0003\u0002Qe\t\u0019\u0011I\\=\t\u000be\u001a\u0001\u0019A\u001e\u0002\u000f=t7\u000b^1siR\tA\u000b\u0005\u00022+&\u0011aK\r\u0002\u0005+:LG/\u0001\u0004p]N#x\u000e]\u0001\u0012aJ,g-\u001a:sK\u0012dunY1uS>tW#\u0001.\u0011\u0007EZV,\u0003\u0002]e\t1q\n\u001d;j_:\u0004\"AX3\u000f\u0005}\u001b\u0007C\u000113\u001b\u0005\t'B\u00012.\u0003\u0019a$o\\8u}%\u0011AMM\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002ee\u0005)1\u000f^8sKR\u0011AK\u001b\u0005\u0006W\u001e\u0001\rAR\u0001\tI\u0006$\u0018-\u0013;f[R\u0011A+\u001c\u0005\u0006]\"\u0001\ra\\\u0001\u000bI\u0006$\u0018MQ;gM\u0016\u0014\bc\u00019v\r6\t\u0011O\u0003\u0002sg\u00069Q.\u001e;bE2,'B\u0001;3\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mF\u00141\"\u0011:sCf\u0014UO\u001a4feR\u0019A\u000b_=\t\u000b9L\u0001\u0019A8\t\u000biL\u0001\u0019\u0001(\u0002\u00115,G/\u00193bi\u0006$\"\u0001\u0016?\t\u000buT\u0001\u0019\u0001@\u0002\u0019\u0011\fG/Y%uKJ\fGo\u001c:\u0011\t}\fIA\u0012\b\u0005\u0003\u0003\t)AD\u0002a\u0003\u0007I\u0011aM\u0005\u0004\u0003\u000f\u0011\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\tiA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\t9A\r\u000b\u0006)\u0006E\u0011\u0011\u0005\u0005\u0007{.\u0001\r!a\u0005\u0011\u000b\u0005U\u0011q\u0004$\u000e\u0005\u0005]!\u0002BA\r\u00037\tA!\u001e;jY*\u0011\u0011QD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005]\u0001\"\u0002>\f\u0001\u0004qEc\u0001+\u0002&!1Q\u0010\u0004a\u0001\u0003'!R\u0001VA\u0015\u0003WAQ!`\u0007A\u0002yDQA_\u0007A\u00029#2\u0001VA\u0018\u0011\u001d\t\tD\u0004a\u0001\u0003g\tQAY=uKN\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY\"A\u0002oS>LA!!\u0010\u00028\tQ!)\u001f;f\u0005V4g-\u001a:\u0015\u000bQ\u000b\t%a\u0011\t\u000f\u0005Er\u00021\u0001\u00024!)!p\u0004a\u0001\u001d\u0006Y!/\u001a9peR,%O]8s)\u0015!\u0016\u0011JA'\u0011\u0019\tY\u0005\u0005a\u0001;\u00069Q.Z:tC\u001e,\u0007bBA(!\u0001\u0007\u0011\u0011K\u0001\ni\"\u0014xn^1cY\u0016\u00042a`A*\u0013\u0011\t)&!\u0004\u0003\u0013QC'o\\<bE2,\u0017a\u0002:fgR\f'\u000f\u001e\u000b\u0004)\u0006m\u0003BBA&#\u0001\u0007Q\fF\u0003U\u0003?\n\t\u0007\u0003\u0004\u0002LI\u0001\r!\u0018\u0005\b\u0003G\u0012\u0002\u0019AA)\u0003\u0015)'O]8s)\u001d!\u0016qMA5\u0003WBa!a\u0013\u0014\u0001\u0004i\u0006bBA2'\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003[\u001a\u0002\u0019AA8\u0003-i\u0017\u000e\u001c7jg\u0016\u001cwN\u001c3\u0011\u0007E\n\t(C\u0002\u0002tI\u00121!\u00138u\u0003\u0011\u0019Ho\u001c9\u0015\u0007Q\u000bI\b\u0003\u0004\u0002LQ\u0001\r!\u0018\u000b\u0006)\u0006u\u0014q\u0010\u0005\u0007\u0003\u0017*\u0002\u0019A/\t\u000f\u0005\rT\u00031\u0001\u0002R\u0005I\u0011n]*uCJ$X\r\u001a\u000b\u0003\u0003\u000b\u00032!MAD\u0013\r\tII\r\u0002\b\u0005>|G.Z1o\u0003%I7o\u0015;paB,G-\u0001\u0005tiJ,\u0017-\\%e+\t\ty'\u0001\u0002jI\u00061\u0011\u000eZ0%KF$2\u0001VAL\u0011%\tIJGA\u0001\u0002\u0004\ty'A\u0002yIE\n1!\u001b3!\u0003-y6/\u001e9feZL7o\u001c:\u0016\u0005\u0005\u0005\u0006cA#\u0002$&\u0019\u0011QU\u0012\u0003%I+7-Z5wKJ\u001cV\u000f]3sm&\u001cxN]\u0001\u0010?N,\b/\u001a:wSN|'o\u0018\u0013fcR\u0019A+a+\t\u0013\u0005eU$!AA\u0002\u0005\u0005\u0016\u0001D0tkB,'O^5t_J\u0004\u0003f\u0001\u0010\u00022B\u0019\u0011'a-\n\u0007\u0005U&GA\u0005ue\u0006t7/[3oi\u0006i1/\u001a;SK\u000e,\u0017N^3s\u0013\u0012$2\u0001VA^\u0011\u001d\til\ba\u0001\u0003_\n1aX5e\u0003A\tG\u000f^1dQN+\b/\u001a:wSN|'\u000fF\u0002U\u0003\u0007Dq!!2!\u0001\u0004\t\t+\u0001\u0003fq\u0016\u001c\u0017AC:va\u0016\u0014h/[:pe\"\u001a\u0001!a3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5(\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\fyM\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public abstract class Receiver<T>
implements Serializable {
    private final StorageLevel storageLevel;
    private int id;
    private transient ReceiverSupervisor _supervisor;

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public abstract void onStart();

    public abstract void onStop();

    public Option<String> preferredLocation() {
        return None$.MODULE$;
    }

    public void store(T dataItem) {
        this.supervisor().pushSingle(dataItem);
    }

    public void store(ArrayBuffer<T> dataBuffer) {
        this.supervisor().pushArrayBuffer(dataBuffer, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ArrayBuffer<T> dataBuffer, Object metadata) {
        this.supervisor().pushArrayBuffer(dataBuffer, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(Iterator<T> dataIterator) {
        this.supervisor().pushIterator(dataIterator, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(java.util.Iterator<T> dataIterator, Object metadata) {
        this.supervisor().pushIterator((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(dataIterator).asScala(), (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(java.util.Iterator<T> dataIterator) {
        this.supervisor().pushIterator((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(dataIterator).asScala(), (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(Iterator<T> dataIterator, Object metadata) {
        this.supervisor().pushIterator(dataIterator, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ByteBuffer bytes) {
        this.supervisor().pushBytes(bytes, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)None$.MODULE$);
    }

    public void store(ByteBuffer bytes, Object metadata) {
        this.supervisor().pushBytes(bytes, (Option<Object>)new Some(metadata), (Option<StreamBlockId>)None$.MODULE$);
    }

    public void reportError(String message, Throwable throwable) {
        this.supervisor().reportError(message, throwable);
    }

    public void restart(String message) {
        ReceiverSupervisor qual$1 = this.supervisor();
        String x$1 = message;
        Option<Throwable> x$2 = qual$1.restartReceiver$default$2();
        qual$1.restartReceiver(x$1, x$2);
    }

    public void restart(String message, Throwable error) {
        this.supervisor().restartReceiver(message, (Option<Throwable>)new Some((Object)error));
    }

    public void restart(String message, Throwable error, int millisecond) {
        this.supervisor().restartReceiver(message, (Option<Throwable>)new Some((Object)error), millisecond);
    }

    public void stop(String message) {
        this.supervisor().stop(message, (Option<Throwable>)None$.MODULE$);
    }

    public void stop(String message, Throwable error) {
        this.supervisor().stop(message, (Option<Throwable>)new Some((Object)error));
    }

    public boolean isStarted() {
        return this.supervisor().isReceiverStarted();
    }

    public boolean isStopped() {
        return this.supervisor().isReceiverStopped();
    }

    public int streamId() {
        return this.id();
    }

    private int id() {
        return this.id;
    }

    private void id_$eq(int x$1) {
        this.id = x$1;
    }

    private ReceiverSupervisor _supervisor() {
        return this._supervisor;
    }

    private void _supervisor_$eq(ReceiverSupervisor x$1) {
        this._supervisor = x$1;
    }

    public void setReceiverId(int _id) {
        this.id_$eq(_id);
    }

    public void attachSupervisor(ReceiverSupervisor exec) {
        Predef$.MODULE$.assert(this._supervisor() == null);
        this._supervisor_$eq(exec);
    }

    public ReceiverSupervisor supervisor() {
        Predef$.MODULE$.assert(this._supervisor() != null, (Function0 & java.io.Serializable & Serializable)() -> "A ReceiverSupervisor has not been attached to the receiver yet. Maybe you are starting some computation in the receiver before the Receiver.onStart() has been called.");
        return this._supervisor();
    }

    public Receiver(StorageLevel storageLevel) {
        this.storageLevel = storageLevel;
        this.id = -1;
        this._supervisor = null;
    }
}

